/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.fontawesome;

import j2html.tags.UnescapedText;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;

public class SvgTag {
    private static final String SPACE = " ";
    private final SymbolRequest.Builder builder;
    private static final String ICON_MD = "icon-md";
    private static final String FONT_AWESOME_API = "font-awesome-api";

    public static SvgTag fontAwesomeSvgIcon(String iconName) {
        return new SvgTag(iconName);
    }

    public static SvgTag fontAwesomeSvgIcon(String iconName, FontAwesomeStyle style) {
        return new SvgTag(iconName, style);
    }

    public SvgTag(String iconName) {
        this(iconName, FontAwesomeStyle.SOLID);
    }

    public SvgTag(String iconName, FontAwesomeStyle style) {
        this.builder = new SymbolRequest.Builder().withName(style.name().toLowerCase(Locale.ENGLISH) + "/" + iconName).withPluginName(FONT_AWESOME_API).withClasses(ICON_MD);
    }

    public SvgTag withClasses(String ... classNames) {
        this.builder.withClasses(this.join(Arrays.asList(classNames)) + " icon-md");
        return this;
    }

    private String join(List<String> classes) {
        return String.join((CharSequence)SPACE, classes);
    }

    public String render() {
        String symbol = Symbol.get((SymbolRequest)this.builder.build());
        return new UnescapedText(symbol).render();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this.builder);
    }

    public static enum FontAwesomeStyle {
        SOLID,
        REGULAR,
        BRANDS;

    }
}

