/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.libs.LibraryAdder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class LibraryCachingConfiguration
extends AbstractDescribableImpl<LibraryCachingConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(LibraryCachingConfiguration.class.getName());
    private int refreshTimeMinutes;
    private String excludedVersionsStr;
    private String includedVersionsStr;
    private static final String VERSIONS_SEPARATOR = " ";
    private static final String GLOBAL_LIBRARIES_DIR = "global-libraries-cache";
    public static final String LAST_READ_FILE = "last_read";

    @DataBoundConstructor
    public LibraryCachingConfiguration(int refreshTimeMinutes, String excludedVersionsStr) {
        this.refreshTimeMinutes = refreshTimeMinutes;
        this.excludedVersionsStr = excludedVersionsStr;
        this.includedVersionsStr = "";
    }

    @Restricted(value={NoExternalUse.class})
    LibraryCachingConfiguration(int refreshTimeMinutes, String excludedVersionsStr, String includedVersionsStr) {
        this.refreshTimeMinutes = refreshTimeMinutes;
        this.excludedVersionsStr = excludedVersionsStr;
        this.includedVersionsStr = includedVersionsStr;
    }

    public int getRefreshTimeMinutes() {
        return this.refreshTimeMinutes;
    }

    public long getRefreshTimeMilliseconds() {
        return Long.valueOf(this.getRefreshTimeMinutes()) * 60000L;
    }

    public Boolean isRefreshEnabled() {
        return this.refreshTimeMinutes > 0;
    }

    public String getExcludedVersionsStr() {
        return this.excludedVersionsStr;
    }

    public String getIncludedVersionsStr() {
        if (StringUtils.isBlank((String)this.includedVersionsStr)) {
            return null;
        }
        return this.includedVersionsStr;
    }

    @DataBoundSetter
    public void setIncludedVersionsStr(String includedVersionsStr) {
        this.includedVersionsStr = includedVersionsStr;
    }

    private List<String> getExcludedVersions() {
        if (this.excludedVersionsStr == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.excludedVersionsStr.split(VERSIONS_SEPARATOR));
    }

    private List<String> getIncludedVersions() {
        if (this.includedVersionsStr == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.includedVersionsStr.split(VERSIONS_SEPARATOR));
    }

    public Boolean isExcluded(String version) {
        if (StringUtils.isBlank((String)version)) {
            return false;
        }
        for (String it : this.getExcludedVersions()) {
            if (!StringUtils.isNotBlank((String)it) || !version.contains(it)) continue;
            return true;
        }
        return false;
    }

    public Boolean isIncluded(String version) {
        if (StringUtils.isBlank((String)version)) {
            return false;
        }
        for (String it : this.getIncludedVersions()) {
            if (!StringUtils.isNotBlank((String)it) || !version.contains(it)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "LibraryCachingConfiguration{refreshTimeMinutes=" + this.refreshTimeMinutes + ", excludedVersions=" + this.excludedVersionsStr + "}";
    }

    public static FilePath getGlobalLibrariesCacheDir() {
        String cacheRootDirOverride = SystemProperties.getString((String)(LibraryCachingConfiguration.class.getName() + ".cacheRootDir"));
        File cacheRootDir = cacheRootDirOverride != null ? new File(cacheRootDirOverride) : new File(Jenkins.get().getRootDir(), GLOBAL_LIBRARIES_DIR);
        return new FilePath(cacheRootDir);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LibraryCachingConfiguration> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doClearCache(@QueryParameter String name, @QueryParameter boolean forceDelete) throws InterruptedException {
            block14: {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                try {
                    if (!LibraryCachingConfiguration.getGlobalLibrariesCacheDir().exists()) break block14;
                    for (FilePath libraryNamePath : LibraryCachingConfiguration.getGlobalLibrariesCacheDir().list("*-name.txt")) {
                        String cacheName;
                        try (InputStream stream = libraryNamePath.read();){
                            cacheName = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                        }
                        if (!cacheName.equals(name)) continue;
                        FilePath libraryCachePath = LibraryCachingConfiguration.getGlobalLibrariesCacheDir().child(libraryNamePath.getName().replace("-name.txt", ""));
                        if (forceDelete) {
                            LOGGER.log(Level.FINER, "Force deleting cache for {0}", name);
                            libraryCachePath.deleteRecursive();
                            libraryNamePath.delete();
                            continue;
                        }
                        LOGGER.log(Level.FINER, "Safe deleting cache for {0}", name);
                        ReentrantReadWriteLock retrieveLock = LibraryAdder.getReadWriteLockFor(libraryCachePath.getName());
                        if (retrieveLock.writeLock().tryLock(10L, TimeUnit.SECONDS)) {
                            try {
                                libraryCachePath.deleteRecursive();
                                libraryNamePath.delete();
                                continue;
                            }
                            finally {
                                retrieveLock.writeLock().unlock();
                            }
                        }
                        return FormValidation.error((String)"The cache dir could not be deleted because it is currently being used by another thread. Please try again.");
                    }
                }
                catch (IOException ex) {
                    return FormValidation.error((Throwable)ex, (String)"The cache dir was not deleted successfully");
                }
            }
            return FormValidation.ok((String)"The cache dir was deleted successfully.");
        }
    }
}

