/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.scm.SCM;
import hudson.slaves.WorkspaceList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.libs.LibraryRecord;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.jenkinsci.plugins.workflow.libs.Messages;
import org.jenkinsci.plugins.workflow.libs.SCMSourceRetriever;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;
import org.jenkinsci.plugins.workflow.steps.scm.SCMStep;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class SCMBasedRetriever
extends LibraryRetriever {
    private static final Logger LOGGER = Logger.getLogger(SCMBasedRetriever.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Non-final for write access via the Script Console")
    public static boolean INCLUDE_SRC_TEST_IN_LIBRARIES = Boolean.getBoolean(SCMSourceRetriever.class.getName() + ".INCLUDE_SRC_TEST_IN_LIBRARIES");
    static final Pattern PROHIBITED_DOUBLE_DOT = Pattern.compile("(^|.*[\\\\/])\\.\\.($|[\\\\/].*)");
    private boolean clone;
    @CheckForNull
    private String libraryPath;

    public boolean isClone() {
        return this.clone;
    }

    @DataBoundSetter
    public void setClone(boolean clone) {
        this.clone = clone;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    @DataBoundSetter
    public void setLibraryPath(String libraryPath) {
        if ((libraryPath = Util.fixEmptyAndTrim((String)libraryPath)) != null && !((String)libraryPath).endsWith("/")) {
            libraryPath = (String)libraryPath + "/";
        }
        this.libraryPath = libraryPath;
    }

    protected final void doRetrieve(String name, boolean changelog, @NonNull SCM scm, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
        if (this.libraryPath != null && PROHIBITED_DOUBLE_DOT.matcher(this.libraryPath).matches()) {
            throw new AbortException("Library path may not contain '..'");
        }
        if (this.clone && changelog) {
            listener.getLogger().println("WARNING: ignoring request to compute changelog in clone mode");
            changelog = false;
        }
        GenericSCMStep delegate = new GenericSCMStep(scm);
        delegate.setPoll(false);
        delegate.setChangelog(changelog);
        Jenkins node = Jenkins.get();
        if (this.clone) {
            Object srcTest;
            if (this.libraryPath == null) {
                SCMBasedRetriever.retrySCMOperation(listener, () -> SCMBasedRetriever.lambda$doRetrieve$0((SCMStep)delegate, run, target, listener));
            } else {
                FilePath root = target.child("root");
                SCMBasedRetriever.retrySCMOperation(listener, () -> SCMBasedRetriever.lambda$doRetrieve$1((SCMStep)delegate, run, root, listener));
                FilePath subdir = root.child(this.libraryPath);
                if (!subdir.isDirectory()) {
                    throw new AbortException("Did not find " + this.libraryPath + " in checkout");
                }
                for (String content : List.of("src", "vars", "resources")) {
                    FilePath contentDir = subdir.child(content);
                    if (!contentDir.isDirectory()) continue;
                    LOGGER.fine(() -> "Moving " + content + " to top level in " + target);
                    contentDir.renameTo(target.child(content));
                }
            }
            if (!INCLUDE_SRC_TEST_IN_LIBRARIES && (srcTest = target.child("src/test")).isDirectory()) {
                listener.getLogger().println("Excluding src/test/ from checkout of " + scm.getKey() + " so that library test code cannot be accessed by Pipelines.");
                listener.getLogger().println("To remove this log message, move the test code outside of src/. To restore the previous behavior that allowed access to files in src/test/, pass -D" + SCMSourceRetriever.class.getName() + ".INCLUDE_SRC_TEST_IN_LIBRARIES=true to the java command used to start Jenkins.");
                srcTest.deleteRecursive();
            }
            block16: for (FilePath child : target.list()) {
                String subdir;
                switch (subdir = child.getName()) {
                    case "src": {
                        continue block16;
                    }
                    case "vars": {
                        continue block16;
                    }
                    case "resources": {
                        continue block16;
                    }
                }
                child.deleteRecursive();
                LOGGER.fine(() -> "Deleted " + child);
            }
        } else {
            FilePath baseWorkspace;
            if (run.getParent() instanceof TopLevelItem) {
                baseWorkspace = node.getWorkspaceFor((TopLevelItem)run.getParent());
                if (baseWorkspace == null) {
                    throw new IOException(node.getDisplayName() + " may be offline");
                }
            } else {
                throw new AbortException("Cannot check out in non-top-level build");
            }
            String checkoutDirName = LibraryRecord.directoryNameFor(scm.getKey());
            FilePath dir = baseWorkspace.withSuffix(SCMBasedRetriever.getFilePathSuffix() + "libs").child(checkoutDirName);
            Computer computer = node.toComputer();
            if (computer == null) {
                throw new IOException(node.getDisplayName() + " may be offline");
            }
            try (WorkspaceList.Lease lease = computer.getWorkspaceList().allocate(dir);){
                String excludes;
                lease.path.withSuffix("-scm-key.txt").write(scm.getKey(), "UTF-8");
                SCMBasedRetriever.retrySCMOperation(listener, () -> SCMBasedRetriever.lambda$doRetrieve$4((SCMStep)delegate, run, lease, listener, (Node)node));
                if (this.libraryPath == null) {
                    this.libraryPath = ".";
                }
                String string = excludes = INCLUDE_SRC_TEST_IN_LIBRARIES ? null : "src/test/";
                if (lease.path.child(this.libraryPath).child("src/test").exists()) {
                    listener.getLogger().println("Excluding src/test/ from checkout of " + scm.getKey() + " so that library test code cannot be accessed by Pipelines.");
                    listener.getLogger().println("To remove this log message, move the test code outside of src/. To restore the previous behavior that allowed access to files in src/test/, pass -D" + SCMSourceRetriever.class.getName() + ".INCLUDE_SRC_TEST_IN_LIBRARIES=true to the java command used to start Jenkins.");
                }
                lease.path.child(this.libraryPath).copyRecursiveTo("src/**/*.groovy,vars/*.groovy,vars/*.txt,resources/", excludes, target);
            }
        }
    }

    protected static <T> T retrySCMOperation(TaskListener listener, Callable<T> task) throws Exception {
        T ret = null;
        for (int retryCount = Jenkins.get().getScmCheckoutRetryCount(); retryCount >= 0; --retryCount) {
            try {
                ret = task.call();
                break;
            }
            catch (AbortException e) {
                if (e.getMessage() != null) {
                    listener.error(e.getMessage());
                }
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (Exception e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error("Checkout failed"));
            }
            if (retryCount == 0) {
                throw new AbortException("Maximum checkout retry attempts reached, aborting");
            }
            listener.getLogger().println("Retrying after 10 seconds");
            Thread.sleep(10000L);
        }
        return ret;
    }

    private static String getFilePathSuffix() {
        return System.getProperty(WorkspaceList.class.getName(), "@");
    }

    private static /* synthetic */ Object lambda$doRetrieve$4(SCMStep delegate, Run run, WorkspaceList.Lease lease, TaskListener listener, Node node) throws Exception {
        delegate.checkout(run, lease.path, listener, node.createLauncher(listener));
        return null;
    }

    private static /* synthetic */ Object lambda$doRetrieve$1(SCMStep delegate, Run run, FilePath root, TaskListener listener) throws Exception {
        delegate.checkout(run, root, listener, Jenkins.get().createLauncher(listener));
        WorkspaceList.tempDir((FilePath)root).deleteRecursive();
        return null;
    }

    private static /* synthetic */ Object lambda$doRetrieve$0(SCMStep delegate, Run run, FilePath target, TaskListener listener) throws Exception {
        delegate.checkout(run, target, listener, Jenkins.get().createLauncher(listener));
        WorkspaceList.tempDir((FilePath)target).deleteRecursive();
        return null;
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class WorkspaceListener
    extends ItemListener {
        public void onDeleted(Item item) {
            WorkspaceListener.deleteLibsDir(item, item.getFullName());
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            WorkspaceListener.deleteLibsDir(item, oldFullName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void deleteLibsDir(Item item, String itemFullName) {
            if (item instanceof Job && item.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob")) {
                Item item2 = item;
                synchronized (item2) {
                    String base = WorkspaceListener.expandVariablesForDirectory(Jenkins.get().getRawWorkspaceDir(), itemFullName, item.getRootDir().getPath());
                    FilePath dir = new FilePath(new File(base)).withSuffix(SCMBasedRetriever.getFilePathSuffix() + "libs");
                    try {
                        if (dir.isDirectory()) {
                            LOGGER.log(Level.INFO, () -> "Deleting obsolete library workspace " + dir);
                            dir.deleteRecursive();
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        LOGGER.log(Level.WARNING, e, () -> "Could not delete obsolete library workspace " + dir);
                    }
                }
            }
        }

        private static String expandVariablesForDirectory(String base, String itemFullName, String itemRootDir) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("JENKINS_HOME", Jenkins.get().getRootDir().getPath());
            properties.put("ITEM_ROOTDIR", itemRootDir);
            properties.put("ITEM_FULLNAME", itemFullName);
            properties.put("ITEM_FULL_NAME", itemFullName.replace(':', '$'));
            return Util.replaceMacro((String)base, Collections.unmodifiableMap(properties));
        }
    }

    protected static abstract class SCMBasedRetrieverDescriptor
    extends LibraryRetrieverDescriptor {
        protected SCMBasedRetrieverDescriptor() {
        }

        @POST
        public FormValidation doCheckLibraryPath(@QueryParameter String libraryPath) {
            if ((libraryPath = Util.fixEmptyAndTrim((String)libraryPath)) == null) {
                return FormValidation.ok();
            }
            if (PROHIBITED_DOUBLE_DOT.matcher(libraryPath).matches()) {
                return FormValidation.error((String)Messages.SCMSourceRetriever_library_path_no_double_dot());
            }
            return FormValidation.ok();
        }
    }
}

