/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.Messages;
import io.jenkins.plugins.util.QualityGateStatus;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public abstract class QualityGate
extends AbstractDescribableImpl<QualityGate>
implements Serializable {
    private static final long serialVersionUID = -397278599489426668L;
    private double threshold = 0.0;
    private QualityGateCriticality criticality = QualityGateCriticality.UNSTABLE;

    protected QualityGate() {
    }

    public abstract String getName();

    @DataBoundSetter
    public final void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public final double getThreshold() {
        return this.threshold;
    }

    private int asInt(double value) {
        return Double.valueOf(value).intValue();
    }

    @DataBoundSetter
    public final void setIntegerThreshold(int integerThreshold) {
        this.threshold = this.asInt(integerThreshold);
    }

    public final int getIntegerThreshold() {
        return this.asInt(this.threshold);
    }

    public String toString() {
        return this.getName() + String.format(" - %s: %f", new Object[]{this.getCriticality(), this.getThreshold()});
    }

    @DataBoundSetter
    public final void setCriticality(QualityGateCriticality criticality) {
        this.criticality = criticality;
    }

    public final QualityGateCriticality getCriticality() {
        return this.criticality;
    }

    public final QualityGateStatus getStatus() {
        return this.getCriticality().getStatus();
    }

    public static enum QualityGateCriticality {
        NOTE(QualityGateStatus.NOTE),
        UNSTABLE(QualityGateStatus.WARNING),
        ERROR(QualityGateStatus.ERROR),
        FAILURE(QualityGateStatus.FAILED);

        private final QualityGateStatus status;

        private QualityGateCriticality(QualityGateStatus status) {
            this.status = status;
        }

        public QualityGateStatus getStatus() {
            return this.status;
        }
    }

    @Extension
    public static class QualityGateDescriptor
    extends Descriptor<QualityGate> {
        private final JenkinsFacade jenkins;

        @VisibleForTesting
        QualityGateDescriptor(JenkinsFacade jenkinsFacade) {
            this.jenkins = jenkinsFacade;
        }

        public QualityGateDescriptor() {
            this(new JenkinsFacade());
        }

        @POST
        public ListBoxModel doFillCriticalityItems(@AncestorInPath BuildableItem project) {
            if (this.jenkins.hasPermission(Jenkins.READ)) {
                ListBoxModel options = new ListBoxModel();
                if (project instanceof FreeStyleProject) {
                    options.add(Messages.QualityGate_Unstable(), QualityGateCriticality.UNSTABLE.name());
                    options.add(Messages.QualityGate_Failure(), QualityGateCriticality.FAILURE.name());
                } else {
                    options.add(Messages.QualityGate_UnstableStage(), QualityGateCriticality.NOTE.name());
                    options.add(Messages.QualityGate_UnstableRun(), QualityGateCriticality.UNSTABLE.name());
                    options.add(Messages.QualityGate_FailureStage(), QualityGateCriticality.ERROR.name());
                    options.add(Messages.QualityGate_FailureRun(), QualityGateCriticality.FAILURE.name());
                }
                return options;
            }
            return new ListBoxModel();
        }
    }
}

