/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.DescriptorExtensionList;
import hudson.model.AbstractItem;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.View;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.access.AccessDeniedException;

public class JenkinsFacade
implements Serializable {
    private static final long serialVersionUID = 1904631270145841113L;

    public <T> List<T> getExtensionsFor(Class<T> extensionType) {
        return this.getJenkins().getExtensionList(extensionType);
    }

    public <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> getDescriptorsFor(Class<T> describableType) {
        return this.getJenkins().getDescriptorList(describableType);
    }

    public Descriptor getDescriptorOrDie(Class<? extends Describable> describableType) {
        return this.getJenkins().getDescriptorOrDie(describableType);
    }

    @CheckForNull
    public Descriptor getDescriptor(Class<? extends Describable> describableType) {
        return this.getJenkins().getDescriptor(describableType);
    }

    public boolean hasPermission(Permission permission) {
        return this.getJenkins().getACL().hasPermission(permission);
    }

    public boolean hasPermission(Permission permission, @CheckForNull Job<?, ?> project) {
        if (project == null) {
            return this.hasPermission(permission);
        }
        return this.getAuthorizationStrategy().getACL(project).hasPermission(permission);
    }

    public boolean hasPermission(Permission permission, @CheckForNull View view) {
        if (view == null) {
            return this.hasPermission(permission);
        }
        return this.getAuthorizationStrategy().getACL(view).hasPermission(permission);
    }

    public boolean hasPermission(Permission permission, @CheckForNull AccessControlled accessControlled) {
        if (accessControlled != null) {
            return accessControlled.hasPermission(permission);
        }
        return this.hasPermission(permission);
    }

    public boolean hasPermission(Permission permission, @CheckForNull AbstractItem item) {
        if (item == null) {
            return this.hasPermission(permission);
        }
        return this.getAuthorizationStrategy().getACL(item).hasPermission(permission);
    }

    private AuthorizationStrategy getAuthorizationStrategy() {
        return this.getJenkins().getAuthorizationStrategy();
    }

    public Optional<Job<?, ?>> getJob(String name) {
        try {
            return Optional.ofNullable((Job)this.getJenkins().getItemByFullName(name, Job.class));
        }
        catch (AccessDeniedException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Run<?, ?>> getBuild(String id) {
        try {
            return Optional.ofNullable(Run.fromExternalizableId((String)id));
        }
        catch (AccessDeniedException ignored) {
            return Optional.empty();
        }
    }

    public String getSymbol(SymbolRequest symbol) {
        return Symbol.get((SymbolRequest)symbol);
    }

    public String getImagePath(String icon) {
        return this.getContextPath() + Jenkins.RESOURCE_PATH + icon;
    }

    private String getContextPath() {
        StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
        if (currentRequest != null) {
            return currentRequest.getContextPath();
        }
        return "";
    }

    public String getAbsoluteUrl(String ... urlElements) {
        return this.getAbsoluteUrl(StringUtils.join((Object[])urlElements, (String)"/"));
    }

    private String getAbsoluteUrl(String url) {
        try {
            String rootUrl = this.getJenkins().getRootUrl();
            if (rootUrl != null) {
                return rootUrl + url;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return url;
    }

    public Set<String> getAllJobNames() {
        return this.getAllJobs().stream().map(this::getFullNameOf).collect(Collectors.toSet());
    }

    public List<Job> getAllJobs() {
        return this.getJenkins().getAllItems(Job.class);
    }

    public String getFullNameOf(Job<?, ?> job) {
        return job.getFullName();
    }

    public boolean isPluginInstalled(String pluginId) {
        return this.getJenkins().getPlugin(pluginId) != null;
    }

    public String getLegacyInstanceId() {
        return this.getJenkins().getLegacyInstanceId();
    }

    private Jenkins getJenkins() {
        return Jenkins.get();
    }
}

