/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import io.github.t12y.resemble.Options;
import io.github.t12y.resemble.Resemble;
import io.github.t12y.resemble.Result;
import io.github.t12y.ssim.SSIM;
import io.github.t12y.ssim.models.MSSIMMatrix;
import io.github.t12y.ssim.models.Matrix;
import io.github.t12y.ssim.models.Options;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageComparison {
    public static final String RESEMBLE = "resemble";
    public static final String SSIM = "ssim";
    private static final String[] IGNORED_BOX_KEYS = new String[]{"left", "right", "top", "bottom"};
    private static final String[] IGNORED_COLOR_KEYS = new String[]{"r", "g", "b"};
    static final Logger logger = LoggerFactory.getLogger(ImageComparison.class);
    private double[] baselinePixels;
    private double[] latestPixels;
    private int height;
    private int width;
    private double stopWhenMismatchIsLessThan;
    private double failureThreshold;
    private boolean baselineMissing;
    private boolean scaleMismatch;
    private String[] engines;
    private Map<String, Object> options;
    private Map<String, Object> result;

    private ImageComparison(byte[] baselineImg, byte[] latestImg, Map<String, Object> options, boolean allowScaling) {
        BufferedImage baselineImage;
        BufferedImage latestImage;
        this.baselineMissing = baselineImg == null || baselineImg.length == 0;
        try {
            latestImage = ImageIO.read(new ByteArrayInputStream(latestImg));
            baselineImage = this.baselineMissing ? latestImage : ImageIO.read(new ByteArrayInputStream(baselineImg));
        }
        catch (IOException e) {
            logger.error("image comparison failed while reading images: {}", (Object)e.getMessage());
            return;
        }
        this.height = baselineImage.getHeight();
        this.width = baselineImage.getWidth();
        this.options = options;
        int latestHeight = latestImage.getHeight();
        int latestWidth = latestImage.getWidth();
        if (this.width != latestWidth || this.height != latestHeight) {
            if (allowScaling) {
                Image scaledImage = latestImage.getScaledInstance(this.width, this.height, 4);
                latestImage = new BufferedImage(this.width, this.height, 2);
                latestImage.getGraphics().drawImage(scaledImage, 0, 0, null);
                latestHeight = this.height;
                latestWidth = this.width;
            } else {
                this.scaleMismatch = true;
            }
        }
        this.baselinePixels = ImageComparison.unpackPixels(baselineImage.getRGB(0, 0, this.width, this.height, null, 0, this.width));
        this.latestPixels = ImageComparison.unpackPixels(latestImage.getRGB(0, 0, latestWidth, latestHeight, null, 0, latestWidth));
        String latestDataUrl = ImageComparison.getDataUrl(latestImg);
        String baselineDataUrl = this.baselineMissing ? latestDataUrl : ImageComparison.getDataUrl(baselineImg);
        this.result = new HashMap<String, Object>();
        this.result.put("baseline", baselineDataUrl);
        this.result.put("latest", latestDataUrl);
    }

    private static String getDataUrl(byte[] img) {
        String format = "png";
        try {
            ImageInputStream input = ImageIO.createImageInputStream(new ByteArrayInputStream(img));
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(input);
                format = reader.getFormatName();
            }
        }
        catch (Exception e) {
            logger.error("image comparison failed to detect image type: {}", (Object)e.getMessage());
        }
        return "data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(img);
    }

    private void configure(Map<String, Object> defaultOptions) {
        String defaultEngine = ImageComparison.asString(defaultOptions.get("engine"));
        if (defaultEngine == null) {
            defaultEngine = RESEMBLE;
        }
        this.result.put("defaultEngine", defaultEngine);
        double defaultFailureThreshold = ImageComparison.toDouble(defaultOptions.get("failureThreshold"), 0.0);
        this.result.put("defaultFailureThreshold", defaultFailureThreshold);
        this.failureThreshold = this.getDouble("failureThreshold", defaultFailureThreshold);
        this.result.put("failureThreshold", this.failureThreshold);
        String engineConfig = this.getString("engine", defaultEngine).toLowerCase().replaceAll("[^a-z,|]", "");
        this.result.put("engine", engineConfig);
        if (engineConfig.contains("|")) {
            this.stopWhenMismatchIsLessThan = this.failureThreshold;
            this.engines = engineConfig.split("\\|");
        } else {
            this.stopWhenMismatchIsLessThan = -1.0;
            this.engines = engineConfig.split(",");
        }
    }

    public static Map<String, Object> compare(byte[] baselineImg, byte[] latestImg, Map<String, Object> options, Map<String, Object> defaultOptions) throws MismatchException {
        boolean allowScaling = ImageComparison.toBool(defaultOptions.get("allowScaling"));
        ImageComparison imageComparison = new ImageComparison(baselineImg, latestImg, options, allowScaling);
        imageComparison.configure(defaultOptions);
        if (imageComparison.baselineMissing) {
            imageComparison.result.put("isBaselineMissing", true);
            throw new MismatchException("baseline image was empty or not found", imageComparison.result);
        }
        if (imageComparison.scaleMismatch) {
            imageComparison.result.put("isScaleMismatch", true);
            throw new MismatchException("latest image dimensions != baseline image dimensions", imageComparison.result);
        }
        double mismatchPercentage = 100.0;
        String[] stringArray = imageComparison.engines;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            double currentMismatchPercentage;
            String engine;
            switch (engine = stringArray[i]) {
                case "resemble": {
                    currentMismatchPercentage = imageComparison.execResemble();
                    break;
                }
                case "ssim": {
                    currentMismatchPercentage = imageComparison.execSSIM();
                    break;
                }
                default: {
                    logger.error("skipping unsupported image comparison engine: {}", (Object)engine);
                    continue block8;
                }
            }
            if (currentMismatchPercentage <= mismatchPercentage) {
                mismatchPercentage = currentMismatchPercentage;
            }
            if (mismatchPercentage < imageComparison.stopWhenMismatchIsLessThan) break;
        }
        return imageComparison.checkMismatch(mismatchPercentage);
    }

    private Map<String, Object> checkMismatch(double mismatchPercentage) {
        this.result.put("mismatchPercentage", mismatchPercentage);
        if (mismatchPercentage <= 0.0 || mismatchPercentage < this.failureThreshold) {
            return this.result;
        }
        String msg = "latest image differed from baseline more than allowable threshold: " + mismatchPercentage + "% >= " + this.failureThreshold + "%";
        this.result.put("isMismatch", true);
        throw new MismatchException(msg, this.result);
    }

    private double execResemble() {
        Result resembleResult = Resemble.analyzeImages((double[])this.baselinePixels, (double[])this.latestPixels, (Options)this.resembleOptions());
        this.result.put("resembleMismatchPercentage", resembleResult.mismatchedPercent);
        return resembleResult.mismatchedPercent;
    }

    private double execSSIM() {
        MSSIMMatrix ssimResult = io.github.t12y.ssim.SSIM.ssim((Matrix)new Matrix(this.height, this.width, this.baselinePixels), (Matrix)new Matrix(this.height, this.width, this.latestPixels), (io.github.t12y.ssim.models.Options)this.ssimOptions());
        double mismatchPercentage = (1.0 - ssimResult.mssim) * 100.0;
        this.result.put("ssimMismatchPercentage", mismatchPercentage);
        return mismatchPercentage;
    }

    private Options resembleOptions() {
        String ignoreOption = this.getString("ignore", "less");
        Options opts = switch (ignoreOption.toLowerCase().replaceAll("[^a-z]", "")) {
            case "nothing" -> Options.ignoreNothing();
            case "less" -> Options.ignoreLess();
            case "antialiasing" -> Options.ignoreAntialiasing();
            case "colors" -> Options.ignoreColors();
            case "alpha" -> Options.ignoreAlpha();
            default -> {
                logger.error("invalid 'ignore' option for resemble engine: {}", (Object)ignoreOption);
                yield Options.ignoreNothing();
            }
        };
        opts.width = this.width;
        opts.height = this.height;
        opts.ignoredBoxes = this.getIgnoredBoxes();
        opts.ignoreAreasColoredWith = ImageComparison.getIntArray(this.options.get("ignoreAreasColoredWith"), IGNORED_COLOR_KEYS);
        opts.ignoreColors = this.getBool("ignoreColors", opts.ignoreColors);
        opts.ignoreAntialiasing = this.getBool("ignoreAntialiasing", opts.ignoreAntialiasing);
        Object tolerancesObj = this.options.get("tolerances");
        if (tolerancesObj instanceof Map) {
            Map tolerances = (Map)tolerancesObj;
            opts.redTolerance = ImageComparison.toDouble(tolerances.get("red"), opts.redTolerance);
            opts.greenTolerance = ImageComparison.toDouble(tolerances.get("green"), opts.greenTolerance);
            opts.blueTolerance = ImageComparison.toDouble(tolerances.get("blue"), opts.blueTolerance);
            opts.alphaTolerance = ImageComparison.toDouble(tolerances.get("alpha"), opts.alphaTolerance);
            opts.minBrightness = ImageComparison.toDouble(tolerances.get("minBrightness"), opts.minBrightness);
            opts.maxBrightness = ImageComparison.toDouble(tolerances.get("maxBrightness"), opts.maxBrightness);
        }
        return opts;
    }

    private io.github.t12y.ssim.models.Options ssimOptions() {
        io.github.t12y.ssim.models.Options opts = io.github.t12y.ssim.models.Options.Defaults();
        opts.ssim = Options.SSIMImpl.valueOf((String)this.getString(SSIM, ImageComparison.asString(opts.ssim)));
        opts.rgb2grayVersion = Options.RGB2Gray.valueOf((String)this.getString("rgb2grayVersion", ImageComparison.asString(opts.rgb2grayVersion)));
        opts.k1 = this.getDouble("k1", opts.k1);
        opts.k2 = this.getDouble("k2", opts.k2);
        opts.windowSize = this.getInt("windowSize", opts.windowSize);
        opts.bitDepth = this.getInt("bitDepth", opts.bitDepth);
        opts.maxSize = this.getInt("maxSize", opts.maxSize);
        opts.ignoredBoxes = this.getIgnoredBoxes();
        return opts;
    }

    private boolean getBool(String name, boolean defaultValue) {
        if (!this.options.containsKey(name)) {
            return defaultValue;
        }
        return ImageComparison.toBool(this.options.get(name));
    }

    private static boolean toBool(Object obj) {
        if (obj == null) {
            return false;
        }
        return Boolean.parseBoolean(ImageComparison.asString(obj));
    }

    private double getDouble(String name, double defaultValue) {
        return ImageComparison.toDouble(this.options.get(name), defaultValue);
    }

    private static double toDouble(Object obj, double defaultValue) {
        if (!(obj instanceof Number)) {
            return defaultValue;
        }
        return ((Number)obj).doubleValue();
    }

    private int getInt(String name, int defaultValue) {
        Object val = this.options.get(name);
        if (!(val instanceof Number)) {
            return defaultValue;
        }
        return ((Number)val).intValue();
    }

    private String getString(String name, String defaultValue) {
        if (!this.options.containsKey(name)) {
            return defaultValue;
        }
        return ImageComparison.asString(this.options.get(name));
    }

    private static String asString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    private int[][] getIgnoredBoxes() {
        Object boxes = this.options.get("ignoredBoxes");
        if (!(boxes instanceof Collection)) {
            return null;
        }
        ArrayList<int[]> ignoredBoxes = new ArrayList<int[]>();
        for (Object boxObj : (Collection)boxes) {
            int[] ignoredBox = ImageComparison.getIntArray(boxObj, IGNORED_BOX_KEYS);
            if (ignoredBox == null) continue;
            ignoredBoxes.add(ignoredBox);
        }
        return (int[][])ignoredBoxes.toArray((T[])new int[0][]);
    }

    private static int[] getIntArray(Object obj, String[] keys) {
        if (!(obj instanceof Map)) {
            return null;
        }
        int[] vals = new int[keys.length];
        Map m = (Map)obj;
        for (int i = 0; i < keys.length; ++i) {
            Object val = m.get(keys[i]);
            if (!(val instanceof Number)) continue;
            vals[i] = ((Number)val).intValue();
        }
        return vals;
    }

    private static double[] unpackPixels(int[] packed) {
        int packedLength = packed.length;
        double[] unpacked = new double[packedLength * 4];
        for (int i = 0; i < packedLength; ++i) {
            int packedPixel = packed[i];
            int unpackedIndex = i * 4;
            unpacked[unpackedIndex] = 0xFF & packedPixel >> 16;
            unpacked[unpackedIndex + 1] = 0xFF & packedPixel >> 8;
            unpacked[unpackedIndex + 2] = 0xFF & packedPixel;
            unpacked[unpackedIndex + 3] = 0xFF & packedPixel >>> 24;
        }
        return unpacked;
    }

    public static class MismatchException
    extends RuntimeException {
        public Map<String, Object> data;

        public MismatchException(String msg, Map<String, Object> data) {
            super(msg);
            data.put("error", this.getMessage());
            this.data = data;
        }
    }
}

