/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.PerfHook;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.Suite;
import com.intuit.karate.core.AfterHookType;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.ParallelProcessor;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioCall;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioIterator;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.resource.MemoryResource;
import com.intuit.karate.resource.Resource;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureRuntime
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(FeatureRuntime.class);
    public final Suite suite;
    public final FeatureRuntime rootFeature;
    public final ScenarioCall caller;
    public final FeatureCall featureCall;
    public final Iterator<ScenarioRuntime> scenarios;
    public final PerfHook perfHook;
    public final FeatureResult result;
    protected ScenarioResult setupResult;
    private ScenarioEngine mockEngine;
    private final ParallelProcessor<ScenarioRuntime> processor;
    public final Map<String, ScenarioCall.Result> CALLONCE_CACHE = new HashMap<String, ScenarioCall.Result>();
    public final Map<String, Map<String, Object>> SETUPONCE_CACHE = new HashMap<String, Map<String, Object>>();
    private Runnable next;
    private boolean beforeHookDone;
    private boolean beforeHookResult = true;
    private ScenarioRuntime lastExecutedScenario;

    public Resource resolveFromThis(String path) {
        return this.featureCall.feature.getResource().resolve(path);
    }

    public Resource resolveFromRoot(String path) {
        return this.rootFeature.featureCall.feature.getResource().resolve(path);
    }

    public void setNext(Runnable next) {
        this.next = next;
    }

    public void setMockEngine(ScenarioEngine mockEngine) {
        this.mockEngine = mockEngine;
    }

    public ScenarioEngine getMockEngine() {
        return this.mockEngine;
    }

    public static FeatureRuntime forTempUse(HttpClientFactory hcf) {
        Suite sr = Suite.forTempUse(hcf);
        File workingDir = new File(sr.buildDir).getAbsoluteFile();
        MemoryResource resource = new MemoryResource(workingDir, "Feature:\nScenario:\n");
        Feature feature = Feature.read(resource);
        return FeatureRuntime.of(sr, new FeatureCall(feature));
    }

    public static FeatureRuntime of(Feature feature) {
        return FeatureRuntime.of(new FeatureCall(feature));
    }

    public static FeatureRuntime of(FeatureCall feature) {
        return FeatureRuntime.of(new Suite(), feature, null);
    }

    public static FeatureRuntime of(Suite sr, FeatureCall feature) {
        return FeatureRuntime.of(sr, feature, null);
    }

    public static FeatureRuntime of(Suite sr, FeatureCall feature, Map<String, Object> arg) {
        return new FeatureRuntime(sr, feature, ScenarioCall.none(arg), null);
    }

    public static FeatureRuntime of(Suite sr, FeatureCall feature, Map<String, Object> arg, PerfHook perfHook) {
        return new FeatureRuntime(sr, feature, ScenarioCall.none(arg), perfHook);
    }

    public FeatureRuntime(ScenarioCall call) {
        this(call.parentRuntime.featureRuntime.suite, call.featureCall, call, call.parentRuntime.featureRuntime.perfHook);
        this.result.setLoopIndex(call.getLoopIndex());
        this.result.setCallDepth(call.depth);
        if (call.arg != null && !call.arg.isNull()) {
            this.result.setCallArg((Map)call.arg.getValue());
        }
    }

    private FeatureRuntime(Suite suite, FeatureCall featureCall, ScenarioCall caller, PerfHook perfHook) {
        this.suite = suite;
        this.featureCall = featureCall;
        this.caller = caller;
        this.rootFeature = caller.isNone() ? this : caller.parentRuntime.featureRuntime;
        this.result = new FeatureResult(featureCall.feature);
        this.scenarios = new ScenarioIterator(this).filterSelected().iterator();
        this.perfHook = perfHook;
        this.processor = caller.isNone() && suite.parallel && perfHook == null ? new ParallelProcessor<ScenarioRuntime>(suite.scenarioExecutor, this.scenarios, suite.pendingTasks){

            @Override
            public void process(ScenarioRuntime sr) {
                FeatureRuntime.this.processScenario(sr);
            }

            @Override
            public void onComplete() {
                FeatureRuntime.this.afterFeature();
            }

            @Override
            public boolean shouldRunSynchronously(ScenarioRuntime sr) {
                return sr.tags.valuesFor("parallel").isAnyOf("false");
            }
        } : null;
    }

    public boolean beforeHook() {
        if (this.beforeHookDone) {
            return this.beforeHookResult;
        }
        this.beforeHookDone = true;
        for (RuntimeHook hook : this.suite.hooks) {
            this.beforeHookResult = this.beforeHookResult && hook.beforeFeature(this);
        }
        return this.beforeHookResult;
    }

    @Override
    public void run() {
        if (this.processor != null) {
            this.processor.execute();
        } else {
            if (!this.beforeHook()) {
                logger.info("before-feature hook returned [false], aborting: {}", (Object)this);
            } else {
                this.scenarios.forEachRemaining(this::processScenario);
            }
            this.afterFeature();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScenario(ScenarioRuntime sr) {
        if (this.beforeHook()) {
            this.lastExecutedScenario = sr;
            sr.run();
            if (!sr.result.getStepResults().isEmpty()) {
                FeatureResult featureResult = this.result;
                synchronized (featureResult) {
                    this.result.addResult(sr.result);
                    if (!sr.dryRun && this.isLastScenarioInOutline(sr.scenario)) {
                        sr.engine.invokeAfterHookIfConfigured(AfterHookType.AFTER_OUTLINE);
                        this.suite.hooks.forEach(h -> h.afterScenarioOutline(sr));
                    }
                }
            }
        }
    }

    private boolean isLastScenarioInOutline(Scenario scenario) {
        if (!scenario.isOutlineExample()) {
            return false;
        }
        int completedScenarios = 0;
        for (ScenarioResult result : this.result.getScenarioResults()) {
            if (result.getScenario().getSection().getIndex() != scenario.getSection().getIndex()) continue;
            ++completedScenarios;
        }
        return completedScenarios == scenario.getSection().getScenarioOutline().getNumScenarios();
    }

    public synchronized void afterFeature() {
        this.result.sortScenarioResults();
        if (this.lastExecutedScenario != null) {
            this.lastExecutedScenario.engine.invokeAfterHookIfConfigured(AfterHookType.AFTER_FEATURE);
            this.result.setVariables(this.lastExecutedScenario.engine.getAllVariablesAsMap());
            this.result.setConfig(this.lastExecutedScenario.engine.getConfig());
        }
        if (!this.result.isEmpty()) {
            for (RuntimeHook hook : this.suite.hooks) {
                hook.afterFeature(this);
            }
        }
        if (this.next != null) {
            this.next.run();
        }
    }

    public String toString() {
        return this.featureCall.feature.toString();
    }
}

