/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.ScenarioOutline;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.ScenarioRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ScenarioOutlineResult {
    private final ScenarioOutline scenarioOutline;
    private final ScenarioRuntime runtime;

    public ScenarioOutlineResult(ScenarioOutline scenarioOutline, ScenarioRuntime runtime) {
        this.scenarioOutline = scenarioOutline;
        this.runtime = runtime;
    }

    public Map<String, Object> toKarateJson() {
        if (this.scenarioOutline == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.scenarioOutline.getName());
        map.put("description", this.scenarioOutline.getDescription());
        map.put("line", this.scenarioOutline.getLine());
        map.put("sectionIndex", this.scenarioOutline.getSection().getIndex());
        map.put("exampleTableCount", this.scenarioOutline.getNumExampleTables());
        map.put("exampleTables", this.scenarioOutline.getAllExampleData());
        map.put("numScenariosToExecute", this.scenarioOutline.getNumScenarios());
        ArrayList<Map<String, Object>> scenarioResults = new ArrayList<Map<String, Object>>();
        if (this.runtime.featureRuntime != null && this.runtime.featureRuntime.result != null) {
            boolean needToAddRecent = this.runtime.result != null;
            for (ScenarioResult result : this.runtime.featureRuntime.result.getScenarioResults()) {
                if (result.getScenario().getSection().getIndex() != this.scenarioOutline.getSection().getIndex()) continue;
                scenarioResults.add(result.toInfoJson());
                if (!result.equals(this.runtime.result)) continue;
                needToAddRecent = false;
            }
            if (needToAddRecent) {
                scenarioResults.add(this.runtime.result.toInfoJson());
            }
        }
        map.put("scenarioResults", scenarioResults);
        map.put("numScenariosExecuted", scenarioResults.size());
        return map;
    }
}

