/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.FileUtils;
import com.intuit.karate.KarateException;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.Target;
import com.intuit.karate.shell.Command;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerTarget
implements Target {
    private final String imageId;
    private String containerId;
    private Function<Integer, String> command;
    private final Map<String, Object> options;
    private boolean pull = false;
    private boolean karateChrome = false;
    static final Logger logger = LoggerFactory.getLogger(DockerTarget.class);

    public DockerTarget(String dockerImage) {
        this(Collections.singletonMap("docker", dockerImage));
    }

    public DockerTarget(Map<String, Object> options) {
        this.options = options;
        if (options != null) {
            this.imageId = (String)options.get("docker");
            Integer vncPort = (Integer)options.get("vncPort");
            String secComp = (String)options.get("secComp");
            Boolean temp = (Boolean)options.get("pull");
            this.pull = temp == null ? false : temp;
            StringBuilder sb = new StringBuilder();
            sb.append("docker run -d -e KARATE_SOCAT_START=true");
            if (secComp == null) {
                sb.append(" --cap-add=SYS_ADMIN");
            } else {
                sb.append(" --security-opt seccomp=").append(secComp);
            }
            if (vncPort != null) {
                sb.append(" -p ").append(vncPort).append(":5900");
            }
            if (this.imageId != null) {
                if (this.imageId.contains("/chrome-headless")) {
                    this.command = p -> sb.toString() + " -p 9222 " + this.imageId;
                } else if (this.imageId.contains("/karate-chrome")) {
                    this.karateChrome = true;
                    this.command = p -> sb.toString() + " -p 9222 " + this.imageId;
                }
            }
        } else {
            this.imageId = null;
        }
    }

    public void setCommand(Function<Integer, String> command) {
        this.command = command;
    }

    public Function<Integer, String> getCommand() {
        return this.command;
    }

    @Override
    public Map<String, Object> start(ScenarioRuntime sr) {
        if (this.command == null) {
            throw new RuntimeException("docker target command (function) not set");
        }
        if (this.imageId != null && this.pull) {
            sr.logger.debug("attempting to pull docker image: {}", this.imageId);
            Command.execLine(null, "docker pull " + this.imageId);
        }
        this.containerId = Command.execLine(null, this.command.apply(null));
        int port = this.getContainerPort(this.containerId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.options != null) {
            map.putAll(this.options);
        }
        boolean remoteHost = this.options != null && this.options.get("remoteHost") != null && (Boolean)this.options.get("remoteHost") != false;
        boolean useDockerHost = this.options != null && this.options.get("useDockerHost") != null && (Boolean)this.options.get("useDockerHost") != false;
        String host = "127.0.0.1";
        if (remoteHost) {
            String gateway = Command.execLine(null, "docker inspect -f '{{.NetworkSettings.Gateway}}' " + this.containerId);
            host = gateway.replaceAll("'", "");
        } else if (useDockerHost) {
            host = "host.docker.internal";
        }
        map.put("start", false);
        map.put("host", host);
        map.put("port", port);
        map.put("type", "chrome");
        Command.waitForHttp("http://" + host + ":" + port + "/json");
        return map;
    }

    @Override
    public Map<String, Object> stop(ScenarioRuntime sr) {
        Command.execLine(null, "docker stop " + this.containerId);
        if (!this.karateChrome) {
            Command.execLine(null, "docker rm " + this.containerId);
            return Collections.EMPTY_MAP;
        }
        String shortName = this.containerId.contains("_") ? this.containerId : StringUtils.truncate(this.containerId, 12, false);
        String dirName = "karate-chrome_" + shortName;
        String buildDir = sr.featureRuntime.suite.buildDir;
        String resultsDir = buildDir + File.separator + dirName;
        Command.execLine(null, "docker cp " + this.containerId + ":/tmp " + resultsDir);
        Command.execLine(null, "docker rm " + this.containerId);
        String video = resultsDir + File.separator + "karate.mp4";
        File file = new File(video);
        if (!file.exists()) {
            sr.logger.warn("video file missing: {}", file);
            return Collections.EMPTY_MAP;
        }
        File copy = new File(buildDir + File.separator + dirName + ".mp4");
        FileUtils.copy(file, copy);
        return Collections.singletonMap("video", copy.getPath());
    }

    private int getContainerPort(String containerId) {
        String format = "--format='{{(index (index .NetworkSettings.Ports \"9222/tcp\") 0).HostPort}}'";
        if (FileUtils.isOsWindows()) {
            format = format.replace("\"", "\\\"");
        }
        logger.debug("cmd: docker format {} {}", (Object)format, (Object)containerId);
        String dockerInspect = Command.exec(false, null, "docker", "inspect", format, containerId);
        dockerInspect = dockerInspect.replaceAll("[^\\d]", "");
        logger.debug("docker inspect command output: {}", (Object)dockerInspect);
        try {
            return Integer.parseInt(dockerInspect);
        }
        catch (NumberFormatException e) {
            throw new KarateException("Error fetching port from started docker container", e);
        }
    }

    public String getContainerId() {
        return this.containerId;
    }
}

