/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.appium;

import com.intuit.karate.Json;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.WebDriver;
import com.intuit.karate.driver.appium.MobileDriverOptions;
import com.intuit.karate.http.ResourceType;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AppiumDriver
extends WebDriver {
    private boolean isWebSession;

    protected AppiumDriver(MobileDriverOptions options) {
        super(options);
        Map<String, Object> sessionPayload = options.getWebDriverSessionPayload();
        this.isWebSession = options.isWebSession();
    }

    @Override
    public String attribute(String locator, String name) {
        String id = this.elementId(locator);
        return (String)this.http.path("element", id, "attribute", name).get().json().get("value");
    }

    @Override
    protected String selectorPayload(String id) {
        if (this.isWebSession) {
            return super.selectorPayload(id);
        }
        Json json = Json.object();
        if (id.startsWith("/")) {
            json.set("using", "xpath").set("value", id);
        } else if (id.startsWith("@")) {
            json.set("using", "accessibility id").set("value", id.substring(1));
        } else if (id.startsWith("#")) {
            json.set("using", "id").set("value", id.substring(1));
        } else if (id.startsWith(":")) {
            json.set("using", "-ios predicate string").set("value", id.substring(1));
        } else if (id.startsWith("^")) {
            json.set("using", "-ios class chain").set("value", id.substring(1));
        } else if (id.startsWith("-")) {
            json.set("using", "-android uiautomator").set("value", id.substring(1));
        } else {
            json.set("using", "name").set("value", id);
        }
        return json.toString();
    }

    @Override
    public Element click(String locator) {
        String id = this.elementId(locator);
        this.http.path("element", id, "click").postJson("{}");
        return DriverElement.locatorExists(this, locator);
    }

    public void setContext(String context) {
        Json contextBody = Json.object();
        contextBody.set("name", context);
        this.http.path("context").post(contextBody);
    }

    public void hideKeyboard() {
        this.http.path("appium", "device", "hide_keyboard").postJson("{}");
    }

    public String startRecordingScreen() {
        return (String)this.http.path("appium", "start_recording_screen").postJson("{}").json().get("value");
    }

    public String startRecordingScreen(Map<String, Object> payload) {
        HashMap<String, Map<String, Object>> options = new HashMap<String, Map<String, Object>>();
        options.put("options", payload);
        return (String)this.http.path("appium", "start_recording_screen").post(options).json().get("value");
    }

    public String stopRecordingScreen() {
        return (String)this.http.path("appium", "stop_recording_screen").postJson("{}").json().get("value");
    }

    public String stopRecordingScreen(Map<String, Object> payload) {
        HashMap<String, Map<String, Object>> options = new HashMap<String, Map<String, Object>>();
        options.put("options", payload);
        return (String)this.http.path("appium", "stop_recording_screen").post(options).json().get("value");
    }

    public void saveRecordingScreen(String fileName, boolean embed) {
        String videoTemp = this.stopRecordingScreen();
        byte[] bytes = Base64.getDecoder().decode(videoTemp);
        File src = new File(fileName);
        try (FileOutputStream fileOutputStream = new FileOutputStream(src.getAbsolutePath());){
            fileOutputStream.write(bytes);
        }
        catch (Exception e) {
            this.logger.error("error while saveRecordingScreen {}", e.getMessage());
        }
        if (embed && src.exists()) {
            this.getRuntime().embed(bytes, ResourceType.MP4);
        }
    }

    public void saveRecordingScreen(String fileName) {
        this.saveRecordingScreen(fileName, false);
    }

    @Override
    public String text(String locator) {
        String id = this.elementId(locator);
        return (String)this.http.path("element", id, "text").get().json().get("value");
    }

    @Override
    protected Base64.Decoder getDecoder() {
        return Base64.getMimeDecoder();
    }

    @Override
    public void close() {
    }

    @Override
    public Object script(String expression) {
        if (this.isWebSession) {
            return super.script(expression);
        }
        return this.eval(expression).getValue();
    }

    public Object script(String expression, List<Map<String, Object>> args) {
        return this.eval(expression, args).getValue();
    }

    public Object script(String expression, Map<String, Object> args) {
        ArrayList<Map<String, Object>> scriptArgs = new ArrayList<Map<String, Object>>(1);
        scriptArgs.add(args);
        return this.eval(expression, scriptArgs).getValue();
    }

    @Override
    protected <T> T retryIfEnabled(String locator, Supplier<T> action) {
        if (this.isWebSession) {
            return super.retryIfEnabled(locator, action);
        }
        if (this.options.isRetryEnabled()) {
            this.waitFor(locator);
        }
        return action.get();
    }

    @Override
    public DriverOptions getOptions() {
        if (this.isWebSession) {
            return super.getOptions();
        }
        return (MobileDriverOptions)this.options;
    }

    @Override
    public Element waitForText(String locator, String expected) {
        if (this.isWebSession) {
            return super.waitForText(locator, expected);
        }
        return (Element)this.waitUntil(() -> {
            String text = this.optional(locator).getText();
            if (!expected.equals(text)) {
                return null;
            }
            return DriverElement.locatorExists(this, locator);
        });
    }

    @Override
    public Element clear(String locator) {
        if (this.isWebSession) {
            return super.clear(locator);
        }
        String id = this.elementId(locator);
        this.http.path("element", id, "clear").postJson("{}");
        return DriverElement.locatorExists(this, locator);
    }
}

