/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.playwright;

import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.Input;
import com.intuit.karate.driver.Keys;
import com.intuit.karate.driver.playwright.PlaywrightMessage;
import com.intuit.karate.driver.playwright.PlaywrightWait;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.WebSocketClient;
import com.intuit.karate.http.WebSocketOptions;
import com.intuit.karate.shell.Command;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class PlaywrightDriver
implements Driver {
    public static final String DRIVER_TYPE = "playwright";
    private final DriverOptions options;
    private final Command command;
    private final WebSocketClient client;
    private final PlaywrightWait wait;
    private final Logger logger;
    private boolean submit;
    private boolean initialized;
    private boolean terminated;
    private String browserGuid;
    private String browserContextGuid;
    private final Object LOCK = new Object();
    private int nextId;
    private String currentDialog;
    private String currentDialogText;
    private String currentDialogType;
    private boolean dialogAccept = true;
    private String dialogInput = "";
    private String currentFrame;
    private String currentPage;
    private final Map<String, Set<String>> pageFrames = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Frame> frameInfo = new HashMap<String, Frame>();
    private static final Map<String, Object> NO_ARGS = (Map)Json.of("{ value: { v: 'undefined' }, handles: [] }").value();
    protected int currentMouseXpos;
    protected int currentMouseYpos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndWait() {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                this.LOCK.wait();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAndProceed() {
        this.initialized = true;
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    public int nextId() {
        return ++this.nextId;
    }

    public void waitSync() {
        this.client.waitSync();
    }

    public static PlaywrightDriver start(Map<String, Object> map, ScenarioRuntime sr) {
        String playwrightUrl;
        Command command;
        DriverOptions options = new DriverOptions(map, sr, 4444, DRIVER_TYPE);
        if (options.start) {
            Map<String, Object> pwOptions = options.playwrightOptions == null ? Collections.EMPTY_MAP : options.playwrightOptions;
            options.arg("" + options.port);
            String browserType = (String)pwOptions.get("browserType");
            if (browserType == null) {
                browserType = "chromium";
            }
            options.arg(browserType);
            if (options.headless) {
                options.arg("true");
            }
            CompletableFuture future = new CompletableFuture();
            command = options.startProcess(s -> {
                int pos = s.indexOf("ws://");
                if (pos != -1) {
                    if ((pos = (s = s.substring(pos).trim()).indexOf(32)) != -1) {
                        s = s.substring(0, pos);
                    }
                    future.complete(s);
                }
            });
            try {
                playwrightUrl = (String)future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            options.processLogger.debug("playwright server url ready: {}", playwrightUrl);
        } else {
            command = null;
            playwrightUrl = options.playwrightUrl;
            if (playwrightUrl == null) {
                throw new RuntimeException("playwrightUrl is mandatory if start == false");
            }
        }
        return new PlaywrightDriver(options, command, playwrightUrl);
    }

    public PlaywrightDriver(DriverOptions options, Command command, String webSocketUrl) {
        this.options = options;
        this.logger = options.driverLogger;
        this.command = command;
        this.wait = new PlaywrightWait(this, options);
        WebSocketOptions wsOptions = new WebSocketOptions(webSocketUrl);
        wsOptions.setMaxPayloadSize(options.maxPayloadSize);
        wsOptions.setTextConsumer(text -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< {}", text);
            } else {
                this.logger.debug("<< {}", StringUtils.truncate(text, 1024, true));
            }
            Map map = (Map)Json.of(text).value();
            PlaywrightMessage pwm = new PlaywrightMessage(this, map);
            this.receive(pwm);
        });
        this.client = new WebSocketClient(wsOptions, this.logger);
        this.lockAndWait();
        this.logger.debug("contexts ready, frame: {}, page: {}, browser-context: {}, browser: {}", this.currentFrame, this.currentPage, this.browserContextGuid, this.browserGuid);
    }

    private PlaywrightMessage method(String method, String guid) {
        return new PlaywrightMessage(this, method, guid);
    }

    public void send(PlaywrightMessage pwm) {
        String json = JsonUtils.toJson(pwm.toMap());
        this.logger.debug(">> {}", json);
        this.client.send(json);
    }

    private PlaywrightMessage page(String method) {
        return this.method(method, this.currentPage);
    }

    private PlaywrightMessage frame(String method) {
        return this.method(method, this.currentFrame);
    }

    public void receive(PlaywrightMessage pwm) {
        if (pwm.methodIs("frameAttached")) {
            String pageGuid = pwm.getGuid();
            String frameGuid = (String)pwm.getParam("frame.guid");
            Set<String> frames = this.pageFrames.get(pageGuid);
            if (frames == null) {
                frames = new LinkedHashSet<String>();
                this.pageFrames.put(pageGuid, frames);
            }
            frames.add(frameGuid);
        } else if (pwm.methodIs("frameDetached")) {
            String pageGuid = pwm.getGuid();
            String frameGuid = (String)pwm.getParam("frame.guid");
            this.frameInfo.remove(frameGuid);
            Set<String> frames = this.pageFrames.get(pageGuid);
            frames.remove(frameGuid);
        } else if (pwm.methodIs("navigated")) {
            String frameGuid = pwm.getGuid();
            String url = (String)pwm.getParam("url");
            String name = (String)pwm.getParam("name");
            this.frameInfo.put(frameGuid, new Frame(frameGuid, url, name));
        } else if (pwm.methodIs("__create__")) {
            if (pwm.paramHas("type", "Page")) {
                String pageGuid = (String)pwm.getParam("guid");
                String frameGuid = (String)pwm.getParam("initializer.mainFrame.guid");
                Set<String> frames = this.pageFrames.get(pageGuid);
                if (frames == null) {
                    frames = new LinkedHashSet<String>();
                    this.pageFrames.put(pageGuid, frames);
                }
                frames.add(frameGuid);
                if (!this.initialized) {
                    this.currentPage = pageGuid;
                    this.currentFrame = frameGuid;
                    this.unlockAndProceed();
                }
            } else if (pwm.paramHas("type", "Dialog")) {
                this.currentDialog = (String)pwm.getParam("guid");
                this.currentDialogText = (String)pwm.getParam("initializer.message");
                this.currentDialogType = (String)pwm.getParam("initializer.type");
                if ("alert".equals(this.currentDialogType)) {
                    this.method("dismiss", this.currentDialog).sendWithoutWaiting();
                } else {
                    if (this.dialogInput == null) {
                        this.dialogInput = "";
                    }
                    this.method(this.dialogAccept ? "accept" : "dismiss", this.currentDialog).param("promptText", this.dialogInput).sendWithoutWaiting();
                }
            } else if (pwm.paramHas("type", "Browser")) {
                Map temp;
                this.browserGuid = (String)pwm.getParam("guid");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sdkLanguage", "javascript");
                if (!this.options.headless) {
                    map.put("noDefaultViewport", false);
                }
                if (this.options.playwrightOptions != null && (temp = (Map)this.options.playwrightOptions.get("context")) != null) {
                    map.putAll(temp);
                }
                this.method("newContext", this.browserGuid).params(map).sendWithoutWaiting();
            } else if (pwm.paramHas("type", "BrowserContext")) {
                this.browserContextGuid = (String)pwm.getParam("guid");
                this.method("newPage", this.browserContextGuid).sendWithoutWaiting();
            } else {
                this.logger.trace("ignoring __create__: {}", pwm);
            }
        } else {
            this.wait.receive(pwm);
        }
    }

    public PlaywrightMessage sendAndWait(PlaywrightMessage pwm, Predicate<PlaywrightMessage> condition) {
        PlaywrightMessage result;
        boolean wasSubmit = this.submit;
        if (condition == null && this.submit) {
            this.submit = false;
            condition = PlaywrightWait.DOM_CONTENT_LOADED;
        }
        if ((result = this.wait.send(pwm, condition)) == null && !wasSubmit) {
            throw new RuntimeException("failed to get reply for: " + pwm);
        }
        return result;
    }

    @Override
    public DriverOptions getOptions() {
        return this.options;
    }

    @Override
    public Driver timeout(Integer millis) {
        this.options.setTimeout(millis);
        return this;
    }

    @Override
    public Driver timeout() {
        return this.timeout(null);
    }

    private PlaywrightMessage evalOnce(String expression, boolean quickly, boolean fireAndForget) {
        PlaywrightMessage toSend = this.frame("evaluateExpression").param("expression", expression).param("isFunction", false).param("arg", NO_ARGS);
        if (quickly) {
            toSend.setTimeout(this.options.getRetryInterval());
        }
        if (fireAndForget) {
            toSend.sendWithoutWaiting();
            return null;
        }
        return toSend.send();
    }

    private PlaywrightMessage eval(String expression) {
        return this.eval(expression, false);
    }

    private PlaywrightMessage eval(String expression, boolean quickly) {
        PlaywrightMessage pwm = this.evalOnce(expression, quickly, false);
        if (pwm.isError()) {
            String message = "js eval failed once:" + expression + ", error: " + pwm.getResult();
            this.logger.warn(message, new Object[0]);
            this.options.sleep();
            pwm = this.evalOnce(expression, quickly, false);
            if (pwm.isError()) {
                message = "js eval failed twice:" + expression + ", error: " + pwm.getResult();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        return pwm;
    }

    @Override
    public Object script(String expression) {
        return this.eval(expression).getResultValue();
    }

    @Override
    public String elementId(String locator) {
        return (String)this.frame("querySelector").param("selector", locator).send().getResult("element.guid");
    }

    @Override
    public List<String> elementIds(String locator) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void retryIfEnabled(String locator) {
        if (this.options.isRetryEnabled()) {
            this.waitFor(locator);
        }
        if (this.options.highlight) {
            String highlightJs = this.options.highlight(locator, this.options.highlightDuration);
            this.evalOnce(highlightJs, true, true);
        }
    }

    @Override
    public void setUrl(String url) {
        this.frame("goto").param("url", url).param("waitUntil", "load").send();
    }

    @Override
    public void activate() {
        this.page("bringToFront").send();
    }

    @Override
    public void refresh() {
        this.page("reload").param("waitUntil", "load").send();
    }

    @Override
    public void reload() {
        this.refresh();
    }

    @Override
    public void back() {
        this.page("goBack").param("waitUntil", "load").send();
    }

    @Override
    public void forward() {
        this.page("goForward").param("waitUntil", "load").send();
    }

    @Override
    public void maximize() {
    }

    @Override
    public void minimize() {
    }

    @Override
    public void fullscreen() {
    }

    @Override
    public void close() {
        this.page("close").send();
    }

    @Override
    public void quit() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.method("close", this.browserGuid).sendWithoutWaiting();
        this.client.close();
        if (this.command != null) {
            this.command.close(false);
        }
    }

    @Override
    public String property(String id, String name) {
        this.retryIfEnabled(id);
        return (String)this.eval(DriverOptions.selector(id) + "['" + name + "']").getResultValue();
    }

    @Override
    public String html(String id) {
        return this.property(id, "outerHTML");
    }

    @Override
    public String text(String id) {
        return this.property(id, "textContent");
    }

    @Override
    public String value(String locator) {
        return this.property(locator, "value");
    }

    @Override
    public String getUrl() {
        return (String)this.eval("document.location.href").getResultValue();
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
    }

    @Override
    public String getTitle() {
        return (String)this.eval("document.title").getResultValue();
    }

    @Override
    public Element click(String locator) {
        this.retryIfEnabled(locator);
        this.eval(DriverOptions.selector(locator) + ".click()");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element value(String locator, String value) {
        this.retryIfEnabled(locator);
        this.eval(DriverOptions.selector(locator) + ".value = '" + value + "'");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public String attribute(String id, String name) {
        this.retryIfEnabled(id);
        return (String)this.eval(DriverOptions.selector(id) + ".getAttribute('" + name + "')").getResultValue();
    }

    @Override
    public boolean enabled(String id) {
        this.retryIfEnabled(id);
        PlaywrightMessage pwm = this.eval(DriverOptions.selector(id) + ".disabled");
        Boolean disabled = (Boolean)pwm.getResultValue();
        return disabled == false;
    }

    @Override
    public boolean waitUntil(String expression) {
        return this.options.retry(() -> {
            try {
                return (Boolean)this.eval(expression, true).getResultValue();
            }
            catch (Exception e) {
                this.logger.warn("waitUntil evaluate failed: {}", e.getMessage());
                return false;
            }
        }, b -> b, "waitUntil (js)", true);
    }

    @Override
    public Driver submit() {
        this.submit = true;
        return this;
    }

    @Override
    public Element focus(String locator) {
        this.retryIfEnabled(locator);
        this.eval(this.options.focusJs(locator));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element clear(String locator) {
        this.eval(DriverOptions.selector(locator) + ".value = ''");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Map<String, Object> position(String locator) {
        return this.position(locator, false);
    }

    @Override
    public Map<String, Object> position(String locator, boolean relative) {
        boolean submitTemp = this.submit;
        this.submit = false;
        this.retryIfEnabled(locator);
        Map map = (Map)this.eval(relative ? DriverOptions.getRelativePositionJs(locator) : DriverOptions.getPositionJs(locator)).getResultValue();
        this.submit = submitTemp;
        return map;
    }

    private PlaywrightMessage evalFrame(String frameGuid, String expression) {
        return this.method("evaluateExpression", frameGuid).param("expression", expression).param("isFunction", false).param("arg", NO_ARGS).send();
    }

    @Override
    public void switchPage(String titleOrUrl) {
        if (titleOrUrl == null) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : this.pageFrames.entrySet()) {
            String pageGuid = entry.getKey();
            String frameGuid = entry.getValue().iterator().next();
            String title = (String)this.evalFrame(frameGuid, "document.title").getResultValue();
            if (title != null && title.contains(titleOrUrl)) {
                this.currentPage = pageGuid;
                this.currentFrame = frameGuid;
                this.activate();
                return;
            }
            String url = (String)this.evalFrame(frameGuid, "document.location.href").getResultValue();
            if (url == null || !url.contains(titleOrUrl)) continue;
            this.currentPage = pageGuid;
            this.currentFrame = frameGuid;
            this.activate();
            return;
        }
        this.logger.warn("failed to find page by title / url: {}", titleOrUrl);
    }

    @Override
    public void switchPage(int index) {
        if (index == -1 || index >= this.pageFrames.size()) {
            this.logger.warn("not switching page for size {}: {}", this.pageFrames.size(), index);
            return;
        }
        List<String> temp = this.getPages();
        this.currentPage = temp.get(index);
        this.currentFrame = this.pageFrames.get(this.currentPage).iterator().next();
        this.activate();
    }

    private void waitForFrame(String previousFrame) {
        String previousFrameUrl = this.frameInfo.get((Object)previousFrame).url;
        this.logger.debug("waiting for frame url to switch from: {} - {}", previousFrame, previousFrameUrl);
        Integer retryInterval = this.options.getRetryInterval();
        this.options.setRetryInterval(1000);
        this.options.retry(() -> this.evalFrame(this.currentFrame, "document.location.href"), pwm -> !pwm.isError() && !pwm.getResultValue().equals(previousFrameUrl), "waiting for frame context", false);
        this.options.setRetryInterval(retryInterval);
    }

    @Override
    public void switchFrame(int index) {
        String previousFrame = this.currentFrame;
        ArrayList temp = new ArrayList(this.pageFrames.get(this.currentPage));
        if (++index < temp.size()) {
            this.currentFrame = (String)temp.get(index);
            this.logger.debug("switched to frame: {} - pages: {}", this.currentFrame, this.pageFrames);
            this.waitForFrame(previousFrame);
        } else {
            this.logger.warn("not switching frame for size {}: {}", temp.size(), index);
        }
    }

    @Override
    public void switchFrame(String locator) {
        String previousFrame = this.currentFrame;
        if (locator == null) {
            this.switchFrame(-1);
        } else {
            if (locator.startsWith("#")) {
                locator = locator.substring(1);
            }
            for (Frame frame : this.frameInfo.values()) {
                if (!frame.url.contains(locator) && !frame.name.contains(locator)) continue;
                this.currentFrame = frame.frameGuid;
                this.logger.debug("switched to frame: {} - pages: {}", this.currentFrame, this.pageFrames);
                this.waitForFrame(previousFrame);
                return;
            }
        }
    }

    @Override
    public Map<String, Object> getDimensions() {
        this.logger.warn("getDimensions() not supported", new Object[0]);
        return Collections.EMPTY_MAP;
    }

    @Override
    public List<String> getPages() {
        return new ArrayList<String>(this.pageFrames.keySet());
    }

    @Override
    public String getDialogText() {
        return this.currentDialogText;
    }

    @Override
    public byte[] screenshot(boolean embed) {
        return this.screenshot(null, embed);
    }

    @Override
    public Map<String, Object> cookie(String name) {
        List<Map> list = this.getCookies();
        if (list == null) {
            return null;
        }
        for (Map map : list) {
            if (map == null || !name.equals(map.get("name"))) continue;
            return map;
        }
        return null;
    }

    @Override
    public void cookie(Map<String, Object> cookie) {
        if (cookie.get("url") == null && cookie.get("domain") == null) {
            cookie = new HashMap<String, Object>(cookie);
            cookie.put("url", this.getUrl());
        }
        this.method("addCookies", this.browserContextGuid).param("cookies", Collections.singletonList(cookie)).send();
    }

    @Override
    public void deleteCookie(String name) {
        List<Map> cookies = this.getCookies();
        ArrayList<Map> filtered = new ArrayList<Map>(cookies.size());
        for (Map m : cookies) {
            if (name.equals(m.get("name"))) continue;
            filtered.add(m);
        }
        this.clearCookies();
        this.method("addCookies", this.browserContextGuid).param("cookies", filtered).send();
    }

    @Override
    public void clearCookies() {
        this.method("clearCookies", this.browserContextGuid).send();
    }

    @Override
    public List<Map> getCookies() {
        return (List)this.method("cookies", this.browserContextGuid).param("urls", Collections.EMPTY_LIST).send().getResult("cookies");
    }

    @Override
    public void dialog(boolean accept) {
        this.dialog(accept, null);
    }

    @Override
    public void dialog(boolean accept, String input) {
        this.dialogAccept = accept;
        this.dialogInput = input;
    }

    @Override
    public Element input(String locator, String value) {
        this.retryIfEnabled(locator);
        this.eval(this.options.focusJs(locator));
        Input input = new Input(value);
        HashSet<String> pressed = new HashSet<String>();
        while (input.hasNext()) {
            char c = input.next();
            String keyValue = Keys.keyValue(c);
            if (keyValue != null) {
                if (Keys.isModifier(c)) {
                    pressed.add(keyValue);
                    this.page("keyboardDown").param("key", keyValue).send();
                    continue;
                }
                this.page("keyboardPress").param("key", keyValue).send();
                continue;
            }
            this.page("keyboardType").param("text", "" + c).send();
        }
        for (String keyValue : pressed) {
            this.page("keyboardUp").param("key", keyValue).send();
        }
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public void actions(List<Map<String, Object>> sequence) {
        boolean submitRequested = this.submit;
        this.submit = false;
        for (Map<String, Object> map : sequence) {
            List actions = (List)map.get("actions");
            if (actions == null) {
                this.logger.warn("no actions property found: {}", sequence);
                return;
            }
            Iterator iterator = actions.iterator();
            block11: while (iterator.hasNext()) {
                String pageAction;
                Map action = (Map)iterator.next();
                String type = (String)action.get("type");
                if (type == null) {
                    this.logger.warn("no type property found: {}", action);
                    continue;
                }
                switch (type) {
                    case "pointerMove": {
                        pageAction = "mouseMove";
                        break;
                    }
                    case "pointerDown": {
                        pageAction = "mouseDown";
                        break;
                    }
                    case "pointerUp": {
                        pageAction = "mouseUp";
                        break;
                    }
                    default: {
                        this.logger.warn("unexpected action type: {}", action);
                        continue block11;
                    }
                }
                Integer x = (Integer)action.get("x");
                Integer y = (Integer)action.get("y");
                if (x != null) {
                    this.currentMouseXpos = x;
                }
                if (y != null) {
                    this.currentMouseYpos = y;
                }
                Integer duration = (Integer)action.get("duration");
                PlaywrightMessage toSend = this.page(pageAction);
                if ("mouseMove".equals(pageAction) && x != null && y != null) {
                    toSend.param("x", x).param("y", y);
                } else {
                    toSend.params(Collections.EMPTY_MAP);
                }
                if (!iterator.hasNext() && submitRequested) {
                    this.submit = true;
                }
                toSend.send();
                if (duration == null) continue;
                this.options.sleep(duration);
            }
        }
    }

    @Override
    public Element select(String locator, String text) {
        this.retryIfEnabled(locator);
        this.eval(this.options.optionSelector(locator, text));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element select(String locator, int index) {
        this.retryIfEnabled(locator);
        this.eval(this.options.optionSelector(locator, index));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public byte[] screenshot(String locator, boolean embed) {
        PlaywrightMessage toSend = this.page("screenshot").param("type", "png");
        if (locator != null) {
            toSend.param("clip", this.position(locator));
        }
        PlaywrightMessage pwm = toSend.send();
        String data = (String)pwm.getResult("binary");
        byte[] bytes = Base64.getDecoder().decode(data);
        if (embed) {
            this.getRuntime().embed(bytes, ResourceType.PNG);
        }
        return bytes;
    }

    @Override
    public byte[] pdf(Map<String, Object> options) {
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        PlaywrightMessage pwm = this.page("pdf").params(options).send();
        String temp = (String)pwm.getResult("pdf");
        return Base64.getDecoder().decode(temp);
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    private static class Frame {
        final String frameGuid;
        final String url;
        final String name;

        Frame(String frameGuid, String url, String name) {
            this.frameGuid = frameGuid;
            this.url = url;
            this.name = name;
        }
    }
}

