/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Constants;
import com.intuit.karate.FileUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.core.Config;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.http.Cookies;
import com.intuit.karate.http.CustomHttpRequestRetryHandler;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpLogger;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.Response;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.LenientSslConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.cookie.DefaultCookieSpec;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class ApacheHttpClient
implements HttpClient,
HttpRequestInterceptor {
    private final ScenarioEngine engine;
    private final Logger logger;
    private final HttpLogger httpLogger;
    private HttpClientBuilder clientBuilder;
    private CookieStore cookieStore;
    private HttpRequest request;

    public ApacheHttpClient(ScenarioEngine engine) {
        this.engine = engine;
        this.logger = engine.logger;
        this.httpLogger = new HttpLogger(this.logger);
        this.configure(engine.getConfig());
    }

    private void configure(final Config config) {
        this.clientBuilder = HttpClientBuilder.create();
        if (config.isHttpRetryEnabled()) {
            this.clientBuilder.setRetryHandler((HttpRequestRetryHandler)new CustomHttpRequestRetryHandler(this.logger));
        } else {
            this.clientBuilder.disableAutomaticRetries();
        }
        if (!config.isFollowRedirects()) {
            this.clientBuilder.disableRedirectHandling();
        } else {
            this.clientBuilder.setRedirectStrategy((RedirectStrategy)LaxRedirectStrategy.INSTANCE);
        }
        this.cookieStore = new BasicCookieStore();
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.clientBuilder.setDefaultCookieSpecRegistry(LenientCookieSpec.registry());
        this.clientBuilder.useSystemProperties();
        if (config.isSslEnabled()) {
            String algorithm = config.getSslAlgorithm();
            KeyStore trustStore = this.engine.getKeyStore(config.getSslTrustStore(), config.getSslTrustStorePassword(), config.getSslTrustStoreType());
            KeyStore keyStore = this.engine.getKeyStore(config.getSslKeyStore(), config.getSslKeyStorePassword(), config.getSslKeyStoreType());
            try {
                SSLContextBuilder builder = SSLContexts.custom().setProtocol(algorithm);
                builder = trustStore == null && config.isSslTrustAll() ? builder.loadTrustMaterial((TrustStrategy)new TrustAllStrategy()) : (config.isSslTrustAll() ? builder.loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()) : builder.loadTrustMaterial(trustStore, null));
                if (keyStore != null) {
                    char[] keyPassword = config.getSslKeyStorePassword() == null ? null : config.getSslKeyStorePassword().toCharArray();
                    builder = builder.loadKeyMaterial(keyStore, keyPassword);
                }
                SSLContext sslContext = builder.build();
                Object socketFactory = keyStore != null ? new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier()) : new LenientSslConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
                this.clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            }
            catch (Exception e) {
                this.logger.error("ssl context init failed: {}", e.getMessage());
                throw new RuntimeException(e);
            }
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom().setCookieSpec("karate").setConnectTimeout(config.getConnectTimeout()).setSocketTimeout(config.getReadTimeout());
        if (config.getLocalAddress() != null) {
            try {
                InetAddress localAddress = InetAddress.getByName(config.getLocalAddress());
                configBuilder.setLocalAddress(localAddress);
            }
            catch (Exception e) {
                this.logger.warn("failed to resolve local address: {} - {}", config.getLocalAddress(), e.getMessage());
            }
        }
        if (config.isNtlmEnabled()) {
            ArrayList<String> authSchemes = new ArrayList<String>();
            authSchemes.add("NTLM");
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            NTCredentials ntCredentials = new NTCredentials(config.getNtlmUsername(), config.getNtlmPassword(), config.getNtlmWorkstation(), config.getNtlmDomain());
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)ntCredentials);
            this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            configBuilder.setTargetPreferredAuthSchemes(authSchemes);
        }
        this.clientBuilder.setDefaultRequestConfig(configBuilder.build());
        SocketConfig.Builder socketBuilder = SocketConfig.custom().setSoTimeout(config.getConnectTimeout());
        this.clientBuilder.setDefaultSocketConfig(socketBuilder.build());
        if (config.getProxyUri() != null) {
            try {
                final URI proxyUri = new URIBuilder(config.getProxyUri()).build();
                this.clientBuilder.setProxy(new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme()));
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword()));
                    this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
                if (config.getNonProxyHosts() != null) {
                    ProxySelector proxySelector = new ProxySelector(){
                        private final List<String> proxyExceptions;
                        {
                            this.proxyExceptions = config.getNonProxyHosts();
                        }

                        @Override
                        public List<Proxy> select(URI uri) {
                            return Collections.singletonList(this.proxyExceptions.contains(uri.getHost()) ? Proxy.NO_PROXY : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort())));
                        }

                        @Override
                        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                            ApacheHttpClient.this.logger.info("connect failed to uri: {}", uri, ioe);
                        }
                    };
                    this.clientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(proxySelector));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.clientBuilder.addInterceptorLast((HttpRequestInterceptor)this);
    }

    @Override
    public void setConfig(Config config) {
        this.configure(config);
    }

    @Override
    public Config getConfig() {
        return this.engine.getConfig();
    }

    @Override
    public Response invoke(HttpRequest request) {
        byte[] bytes;
        CloseableHttpResponse httpResponse;
        this.request = request;
        RequestBuilder requestBuilder = RequestBuilder.create((String)request.getMethod()).setUri(request.getUrl());
        if (request.getBody() != null) {
            EntityBuilder entityBuilder = EntityBuilder.create().setBinary(request.getBody());
            List<String> transferEncoding = request.getHeaderValues("Transfer-Encoding");
            if (transferEncoding != null) {
                for (String te : transferEncoding) {
                    if (te == null) continue;
                    if (te.contains("chunked")) {
                        entityBuilder.chunked();
                    }
                    if (!te.contains("gzip")) continue;
                    entityBuilder.gzipCompress();
                }
                request.removeHeader("Transfer-Encoding");
            }
            requestBuilder.setEntity(entityBuilder.build());
        }
        if (request.getHeaders() != null) {
            request.getHeaders().forEach((k, vals) -> vals.forEach(v -> requestBuilder.addHeader(k, v)));
        }
        try (CloseableHttpClient client = this.clientBuilder.build();){
            httpResponse = client.execute(requestBuilder.build());
            HttpEntity responseEntity = httpResponse.getEntity();
            if (responseEntity == null || responseEntity.getContent() == null) {
                bytes = Constants.ZERO_BYTES;
            } else {
                InputStream is = responseEntity.getContent();
                bytes = FileUtils.toBytes(is);
            }
            request.setEndTime(System.currentTimeMillis());
            httpResponse.close();
        }
        catch (Exception e) {
            if (e instanceof ClientProtocolException && e.getCause() != null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        Map<String, List<String>> headers = ApacheHttpClient.toHeaders((HttpMessage)httpResponse);
        List storedCookies = this.cookieStore.getCookies();
        Header[] requestCookieHeaders = httpResponse.getHeaders("Set-Cookie");
        ArrayList<String> mergedCookieValues = new ArrayList<String>(requestCookieHeaders.length);
        HashSet<String> alreadyMerged = new HashSet<String>(requestCookieHeaders.length);
        for (Header ch : requestCookieHeaders) {
            String requestCookieValue = ch.getValue();
            io.netty.handler.codec.http.cookie.Cookie c = ClientCookieDecoder.LAX.decode(requestCookieValue);
            mergedCookieValues.add(requestCookieValue);
            alreadyMerged.add(c.name());
        }
        for (Cookie c : storedCookies) {
            String name;
            if (c.getValue() == null || alreadyMerged.contains(name = c.getName())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", name);
            map.put("value", c.getValue());
            map.put("domain", c.getDomain());
            if (c.getExpiryDate() != null) {
                map.put("max-age", c.getExpiryDate().getTime());
            }
            map.put("secure", c.isSecure());
            io.netty.handler.codec.http.cookie.Cookie nettyCookie = Cookies.fromMap(map);
            String cookieValue = ServerCookieEncoder.LAX.encode(nettyCookie);
            mergedCookieValues.add(cookieValue);
        }
        headers.put("Set-Cookie", mergedCookieValues);
        this.cookieStore.clear();
        Response response = new Response(statusCode, headers, bytes);
        this.httpLogger.logResponse(this.getConfig(), request, response);
        return response;
    }

    public void process(org.apache.http.HttpRequest hr, HttpContext hc) throws HttpException, IOException {
        this.request.setHeaders(ApacheHttpClient.toHeaders((HttpMessage)hr));
        this.httpLogger.logRequest(this.getConfig(), this.request);
        this.request.setStartTime(System.currentTimeMillis());
    }

    private static Map<String, List<String>> toHeaders(HttpMessage msg) {
        Header[] headers = msg.getAllHeaders();
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(headers.length);
        for (Header outer : headers) {
            String name = outer.getName();
            Header[] inner = msg.getHeaders(name);
            ArrayList<String> list = new ArrayList<String>(inner.length);
            for (Header h : inner) {
                list.add(h.getValue());
            }
            map.put(name, list);
        }
        return map;
    }

    public static class LenientCookieSpec
    extends DefaultCookieSpec {
        static final String KARATE = "karate";

        public LenientCookieSpec() {
            super(new String[]{"EEE, dd-MMM-yy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss Z"}, false);
        }

        public boolean match(Cookie cookie, CookieOrigin origin) {
            return true;
        }

        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        }

        public static Registry<CookieSpecProvider> registry() {
            CookieSpecProvider specProvider = hc -> new LenientCookieSpec();
            return RegistryBuilder.create().register(KARATE, (Object)specProvider).build();
        }
    }
}

