/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Constants;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerHandler;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public class HttpServerHandler
implements HttpService {
    private final ServerHandler handler;

    public HttpServerHandler(ServerHandler handler) {
        this.handler = handler;
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.from((CompletableFuture)req.aggregate().thenApply(ahr -> {
            Request request = this.toRequest(ctx, (AggregatedHttpRequest)ahr);
            Response response = this.handler.handle(request);
            return this.toResponse(ctx, response);
        }));
    }

    private Request toRequest(ServiceRequestContext ctx, AggregatedHttpRequest req) {
        Request request = new Request();
        request.setRequestContext((RequestContext)ctx);
        request.setUrl(req.path());
        request.setUrlBase(req.scheme() + "://" + req.authority());
        request.setMethod(req.method().name());
        RequestHeaders rh = req.headers();
        if (rh != null) {
            Set names = rh.names();
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(names.size());
            request.setHeaders(headers);
            for (AsciiString name : names) {
                if (name.charAt(0) == ':') continue;
                headers.put(name.toString(), rh.getAll((CharSequence)name));
            }
        }
        if (!req.content().isEmpty()) {
            byte[] bytes = req.content().array();
            request.setBody(bytes);
        }
        return request;
    }

    private HttpResponse toResponse(ServiceRequestContext ctx, Response response) {
        byte[] body = response.getBody();
        if (body == null) {
            body = Constants.ZERO_BYTES;
        }
        ResponseHeadersBuilder rhb = ResponseHeaders.builder((int)response.getStatus());
        Map<String, List<String>> headers = response.getHeaders();
        if (headers != null) {
            headers.forEach((k, v) -> rhb.add((CharSequence)k, (Iterable)v));
        }
        HttpResponse hr = HttpResponse.of((ResponseHeaders)rhb.build(), (HttpData)HttpData.wrap((byte[])body));
        if (response.getDelay() > 0) {
            return HttpResponse.delayed((HttpResponse)hr, (Duration)Duration.ofMillis(response.getDelay()), (ScheduledExecutorService)ctx.eventLoop());
        }
        return hr;
    }
}

