/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Constants;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.ResourceType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MultiPartBuilder.class);
    private final HttpClient client;
    private final boolean multipart;
    private final HttpPostRequestEncoder encoder;
    private Map<String, Object> formFields;
    private StringBuilder bodyForDisplay = new StringBuilder();
    private String contentTypeHeader;

    public String getBoundary() {
        if (this.contentTypeHeader == null) {
            return null;
        }
        int pos = this.contentTypeHeader.lastIndexOf(61);
        return pos == -1 ? null : this.contentTypeHeader.substring(pos + 1);
    }

    public Map<String, Object> getFormFields() {
        return this.formFields;
    }

    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getBodyForDisplay() {
        return this.bodyForDisplay.toString();
    }

    public MultiPartBuilder(boolean multipart, HttpClient client) {
        this.client = client;
        this.multipart = multipart;
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)"POST"), "/");
        try {
            this.encoder = new HttpPostRequestEncoder((HttpDataFactory)new DefaultHttpDataFactory(16384L), (HttpRequest)request, multipart, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addFile(String name, File file, Map<String, Object> map) {
        String contentType;
        ResourceType resourceType;
        String filename = (String)map.get("filename");
        if (filename == null) {
            filename = file.getName();
        }
        if ((resourceType = (contentType = (String)map.get("contentType")) == null ? ResourceType.fromFileExtension(filename) : ResourceType.fromContentType(contentType)) == null) {
            resourceType = ResourceType.BINARY;
        }
        if (contentType == null) {
            contentType = resourceType.contentType;
        }
        try {
            this.encoder.addBodyFileUpload(name, filename, file, contentType, !resourceType.isBinary());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public MultiPartBuilder part(Map<String, Object> map) {
        String name = (String)map.get("name");
        Object value = map.get("value");
        if (!this.multipart) {
            List<Object> list = value instanceof List ? (List)value : (value == null ? Collections.emptyList() : Collections.singletonList(value.toString()));
            if (this.formFields == null) {
                this.formFields = new HashMap<String, Object>();
            }
            for (String string : list) {
                this.formFields.put(name, string);
                try {
                    this.encoder.addBodyAttribute(name, string);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (value instanceof File) {
            File file = (File)value;
            this.addFile(name, file, map);
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object e : list) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("name", name);
                temp.put("value", e);
                this.part(temp);
            }
        } else {
            void var6_16;
            String contentType = (String)map.get("contentType");
            ResourceType resourceType = contentType == null ? ResourceType.fromObject(value) : ResourceType.fromContentType(contentType);
            if (resourceType == null) {
                resourceType = ResourceType.BINARY;
            }
            if (contentType == null) {
                contentType = resourceType.contentType;
            }
            Object var6_13 = null;
            if (!resourceType.isBinary()) {
                String charset = (String)map.get("charset");
                if (charset == null && this.client != null && this.client.getConfig() != null) {
                    Charset charset2 = this.client.getConfig().getCharset();
                } else if (charset != null) {
                    Charset charset3 = Charset.forName(charset);
                }
            }
            byte[] encoded = value == null ? Constants.ZERO_BYTES : JsonUtils.toBytes(value);
            String filename = (String)map.get("filename");
            if (filename == null) {
                filename = "";
            }
            String transferEncoding = (String)map.get("transferEncoding");
            void nullable = var6_16;
            MemoryFileUpload item = new MemoryFileUpload(name, filename, contentType, transferEncoding, (Charset)var6_16, encoded.length, (Charset)nullable){
                final /* synthetic */ Charset val$nullable;
                {
                    this.val$nullable = charset;
                    super(arg0, arg1, arg2, arg3, arg4, arg5);
                }

                public Charset getCharset() {
                    return this.val$nullable;
                }
            };
            try {
                item.setContent(Unpooled.wrappedBuffer((byte[])encoded));
                this.encoder.addBodyHttpData((InterfaceHttpData)item);
                logger.debug("multipart: {}", (Object)item);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public MultiPartBuilder part(String name, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("value", value);
        return this.part(map);
    }

    public String toCurlCommand() {
        StringBuilder sb = new StringBuilder();
        Iterator parts = this.encoder.getBodyListAttributes().iterator();
        while (parts.hasNext()) {
            String value;
            InterfaceHttpData part = (InterfaceHttpData)parts.next();
            if (!(part instanceof Attribute)) continue;
            Attribute attr = (Attribute)part;
            try {
                value = attr.getValue();
            }
            catch (Exception e) {
                value = null;
                logger.error("failed to get multipart value: {}", (Object)e.getMessage());
            }
            sb.append("-d ").append(part.getName()).append("=").append(value);
            if (!parts.hasNext()) continue;
            sb.append(" \\\n");
        }
        return sb.toString();
    }

    public byte[] build() {
        for (InterfaceHttpData part : this.encoder.getBodyListAttributes()) {
            this.bodyForDisplay.append('\n').append(part.toString()).append('\n');
        }
        try {
            ByteBuf content;
            HttpRequest request = this.encoder.finalizeRequest();
            this.contentTypeHeader = request.headers().get("Content-Type");
            if (request instanceof FullHttpRequest) {
                FullHttpRequest fullRequest = (FullHttpRequest)request;
                content = fullRequest.content();
            } else {
                HttpContent data;
                content = Unpooled.buffer();
                while ((data = this.encoder.readChunk(ByteBufAllocator.DEFAULT)) != null) {
                    content.writeBytes(data.content());
                }
            }
            byte[] bytes = new byte[content.readableBytes()];
            content.readBytes(bytes);
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

