/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerBase {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServerBase.class);
    private final Channel channel;
    private final int port;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        logger.info("stop: shutdown complete");
    }

    public WebSocketServerBase(int port, String path, final SimpleChannelInboundHandler handler) {
        this.port = port;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(8);
        final WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().websocketPath(path).allowExtensions(true).checkStartsWith(true).build();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    p.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    p.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
                    p.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(config)});
                    p.addLast(new ChannelHandler[]{handler});
                }
            });
            this.channel = b.bind(port).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            String host = "127.0.0.1";
            port = isa.getPort();
            logger.info("proxy server started - ws://{}:{}", (Object)host, (Object)port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

