/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.resource;

import com.intuit.karate.FileUtils;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;

public class JarResource
implements Resource {
    private final byte[] bytes;
    private final String relativePath;
    private final URI uri;

    public JarResource(byte[] bytes, String relativePath, URI uri) {
        this.bytes = bytes;
        this.relativePath = relativePath;
        this.uri = uri;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isClassPath() {
        return true;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public Resource resolve(String path) {
        int pos = this.relativePath.lastIndexOf(47);
        String parentPath = pos == -1 ? "" : this.relativePath.substring(0, pos);
        return ResourceUtils.getResource(FileUtils.WORKING_DIR, "classpath:" + parentPath + "/" + path);
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public boolean equals(Object obj) {
        return this.relativePath.equals(obj);
    }

    public int hashCode() {
        return this.relativePath.hashCode();
    }

    public String toString() {
        return this.getPrefixedPath();
    }
}

