/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.shell;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.StringUtils;
import com.intuit.karate.http.Response;
import com.intuit.karate.shell.Console;
import com.intuit.karate.shell.FileLogAppender;
import com.intuit.karate.shell.StopListenerThread;
import com.intuit.karate.shell.StringLogAppender;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public class Command
extends Thread {
    protected static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(Command.class);
    private final boolean useLineFeed;
    private final File workingDir;
    private final String uniqueName;
    private final Logger logger;
    private final String[] args;
    private final List argList;
    private final boolean sharedAppender;
    private final LogAppender appender;
    private Map<String, String> environment;
    private Consumer<String> listener;
    private Consumer<String> errorListener;
    private boolean redirectErrorStream = true;
    private Console sysOut;
    private Console sysErr;
    private Process process;
    private int exitCode = -1;
    private Exception failureReason;
    private int pollAttempts = 30;
    private int pollInterval = 250;
    private static final Pattern CLI_ARG = Pattern.compile("'([^']*)'[^\\S]|\"([^\"]*)\"[^\\S]|(\\S+)");
    private static final Set<Integer> PORTS_IN_USE = ConcurrentHashMap.newKeySet();
    private static final int SLEEP_TIME = 2000;
    private static final int POLL_ATTEMPTS_MAX = 30;

    public void setPollAttempts(int pollAttempts) {
        this.pollAttempts = pollAttempts;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public synchronized boolean isFailed() {
        return this.failureReason != null;
    }

    public Exception getFailureReason() {
        return this.failureReason;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void setListener(Consumer<String> listener) {
        this.listener = listener;
    }

    public void setErrorListener(Consumer<String> errorListener) {
        this.errorListener = errorListener;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
    }

    public String getSysOut() {
        return this.sysOut == null ? null : this.sysOut.getBuffer();
    }

    public String getSysErr() {
        return this.sysErr == null ? null : this.sysErr.getBuffer();
    }

    public static String exec(boolean useLineFeed, File workingDir, String ... args) {
        Command command = new Command(useLineFeed, workingDir, args);
        command.start();
        command.waitSync();
        return command.getSysOut();
    }

    public static String[] tokenize(String command) {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = CLI_ARG.matcher(command + " ");
        while (m.find()) {
            if (m.group(1) != null) {
                args.add(m.group(1));
                continue;
            }
            if (m.group(2) != null) {
                args.add(m.group(2));
                continue;
            }
            args.add(m.group(3));
        }
        return args.toArray(new String[args.size()]);
    }

    public static String execLine(File workingDir, String command) {
        return Command.exec(false, workingDir, Command.tokenize(command));
    }

    public static String[] prefixShellArgs(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (FileUtils.getOsType()) {
            case WINDOWS: {
                list.add("cmd");
                list.add("/c");
                break;
            }
            default: {
                list.add("sh");
                list.add("-c");
            }
        }
        list.add(StringUtils.join(args, ' '));
        return list.toArray(new String[list.size()]);
    }

    public static synchronized int getFreePort(int preferred) {
        if (preferred != 0 && PORTS_IN_USE.contains(preferred)) {
            LOGGER.trace("preferred port {} in use (karate), will attempt to find free port ...", (Object)preferred);
            preferred = 0;
        }
        try {
            ServerSocket s = new ServerSocket(preferred);
            int port = s.getLocalPort();
            LOGGER.debug("found / verified free local port: {}", (Object)port);
            s.close();
            PORTS_IN_USE.add(port);
            return port;
        }
        catch (Exception e) {
            if (preferred > 0) {
                LOGGER.trace("preferred port {} in use (system), re-trying ...", (Object)preferred);
                PORTS_IN_USE.add(preferred);
                return Command.getFreePort(0);
            }
            LOGGER.error("failed to find free port: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void sleep(int millis) {
        try {
            LOGGER.trace("sleeping for millis: {}", (Object)millis);
            Thread.sleep(millis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean waitForPort(String host, int port) {
        int attempts = 0;
        while (true) {
            InetSocketAddress address = new InetSocketAddress(host, port);
            try {
                if (this.isFailed()) {
                    throw this.failureReason;
                }
                this.logger.debug("poll attempt #{} for port to be ready - {}:{}", attempts, host, port);
                SocketChannel sock = SocketChannel.open(address);
                sock.close();
                return true;
            }
            catch (Exception e) {
                Command.sleep(this.pollInterval);
                if (attempts++ < this.pollAttempts) continue;
                return false;
            }
            break;
        }
    }

    public static boolean waitForHttp(String url) {
        return Command.waitForHttp(url, r -> r.getStatus() == 200);
    }

    public static boolean waitForHttp(String url, Predicate<Response> condition) {
        int attempts = 0;
        long startTime = System.currentTimeMillis();
        Http http = Http.to(url);
        do {
            if (attempts > 0) {
                LOGGER.debug("attempt #{} waiting for http to be ready at: {}", (Object)attempts, (Object)url);
            }
            try {
                Response response = http.get();
                if (condition.test(response)) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    LOGGER.debug("ready to accept http connections after {} ms - {}", (Object)elapsedTime, (Object)url);
                    return true;
                }
                LOGGER.warn("not ready / http get returned status: {} - {}", (Object)response.getStatus(), (Object)url);
            }
            catch (Exception e) {
                Command.sleep(2000);
            }
        } while (attempts++ < 30);
        return false;
    }

    public static boolean waitForSocket(int port) {
        StopListenerThread waiter = new StopListenerThread(port, () -> LOGGER.info("*** exited socket wait succesfully"));
        waiter.start();
        port = waiter.getPort();
        System.out.println("*** waiting for socket, type the command below:\ncurl http://localhost:" + port + "\nin a new terminal (or open the URL in a web-browser) to proceed ...");
        try {
            waiter.join();
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("*** wait thread failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Command(String ... args) {
        this(false, (Logger)null, (String)null, (String)null, (File)null, args);
    }

    public Command(boolean useLineFeed, File workingDir, String ... args) {
        this(useLineFeed, null, null, null, workingDir, args);
    }

    public Command(boolean useLineFeed, Logger logger, String uniqueName, String logFile, File workingDir, String ... args) {
        this.useLineFeed = useLineFeed;
        this.setDaemon(true);
        this.uniqueName = uniqueName == null ? "" + System.currentTimeMillis() : uniqueName;
        this.setName(this.uniqueName);
        this.logger = logger == null ? new Logger() : logger;
        this.workingDir = workingDir;
        this.args = args;
        if (workingDir != null) {
            workingDir.mkdirs();
        }
        this.argList = Arrays.asList(args);
        if (logFile == null) {
            this.appender = new StringLogAppender(useLineFeed);
            this.sharedAppender = false;
        } else {
            LogAppender temp = this.logger.getAppender();
            boolean bl = this.sharedAppender = temp != null;
            if (this.sharedAppender) {
                this.appender = temp;
            } else {
                this.appender = new FileLogAppender(new File(logFile));
                this.logger.setAppender(this.appender);
            }
        }
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public List getArgList() {
        return this.argList;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LogAppender getAppender() {
        return this.appender;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public int waitSync() {
        try {
            this.join();
            return this.exitCode;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void close(boolean force) {
        LOGGER.debug("closing command: {}", (Object)this.uniqueName);
        if (force) {
            this.process.destroyForcibly();
        } else {
            this.process.destroy();
        }
    }

    @Override
    public void run() {
        try {
            this.logger.debug("command: {}, working dir: {}", this.argList, this.workingDir);
            ProcessBuilder pb = new ProcessBuilder(this.args);
            if (this.environment != null) {
                pb.environment().putAll(this.environment);
                this.environment = pb.environment();
            }
            this.logger.trace("env PATH: {}", pb.environment().get("PATH"));
            if (this.workingDir != null) {
                pb.directory(this.workingDir);
            }
            pb.redirectErrorStream(this.redirectErrorStream);
            this.process = pb.start();
            this.sysOut = new Console(this.uniqueName + "-out", this.useLineFeed, this.process.getInputStream(), this.logger, this.appender, this.listener);
            this.sysOut.start();
            this.sysErr = new Console(this.uniqueName + "-err", this.useLineFeed, this.process.getErrorStream(), this.logger, this.appender, this.errorListener);
            this.sysErr.start();
            this.exitCode = this.process.waitFor();
            if (this.exitCode == 0) {
                LOGGER.debug("command complete, exit code: {} - {}", (Object)this.exitCode, (Object)this.argList);
            } else {
                LOGGER.warn("exit code was non-zero: {} - {} working dir: {}", new Object[]{this.exitCode, this.argList, this.workingDir});
            }
            this.sysErr.join();
            this.sysOut.join();
            LOGGER.trace("console readers complete");
            if (!this.sharedAppender) {
                this.appender.close();
            }
        }
        catch (Exception e) {
            this.failureReason = e;
            LOGGER.error("command error: {} - {}", (Object)this.argList, (Object)e.getMessage());
        }
    }
}

