/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsValue;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceResolver;
import com.intuit.karate.template.KarateEngineContext;
import com.intuit.karate.template.KarateTemplateResource;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.templateresource.ITemplateResource;

public class ResourceHtmlTemplateResolver
implements ITemplateResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHtmlTemplateResolver.class);
    private final ResourceResolver resourceResolver;

    public ResourceHtmlTemplateResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Integer getOrder() {
        return 1;
    }

    public TemplateResolution resolveTemplate(IEngineConfiguration ec, String ownerTemplate, String name, Map<String, Object> templateResolutionAttributes) {
        if (((String)name).startsWith("${")) {
            JsValue jv = KarateEngineContext.get().evalLocal("`" + (String)name + "`", true);
            name = jv.getAsString();
        }
        if (!((String)name).endsWith(".html")) {
            name = (String)name + ".html";
        }
        Resource resource = this.resourceResolver.resolve(ownerTemplate, (String)name);
        KarateTemplateResource templateResource = new KarateTemplateResource(ownerTemplate, resource);
        return new TemplateResolution((ITemplateResource)templateResource, TemplateMode.HTML, (ICacheEntryValidity)AlwaysValidCacheEntryValidity.INSTANCE);
    }
}

