/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="dry-run", defaultPhase=LifecyclePhase.TEST)
public class DryRunMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="action", defaultValue="install")
    private String action;
    @Parameter(property="helm.dry-run.skip", defaultValue="false")
    private boolean skipDryRun;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipDryRun) {
            this.getLog().info((CharSequence)"Skip dry run");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("\n\nPerform dry-run for chart " + inputDirectory + "..."));
            this.callCli(this.getHelmExecuteablePath() + " " + this.action + " " + inputDirectory + " --dry-run --generate-name" + (StringUtils.isNotEmpty((String)this.getRegistryConfig()) ? " --registry-config=" + this.getRegistryConfig() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryCache()) ? " --repository-cache=" + this.getRepositoryCache() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryConfig()) ? " --repository-config=" + this.getRepositoryConfig() : "") + this.getValuesOptions(), "There are test failures", true);
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

