/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.throwables;

import io.kotest.assertions.AssertionErrorBuilder;
import io.kotest.assertions.CollectorKt;
import io.kotest.assertions.print.PrintKt;
import io.kotest.assertions.print.StringPrint;
import io.kotest.matchers.AssertionCounter_jvmKt;
import io.kotest.matchers.ErrorCollector;
import io.kotest.matchers.jvmerrorcollector;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\b\u00f8\u0001\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\b\u00f8\u0001\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0003H\u0086\b\u00f8\u0001\u0000\u001a%\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\t0\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a(\u0010\u000b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\t0\u0003H\u0086\b\u00f8\u0001\u0000\u001a(\u0010\u000e\u001a\u00020\u0004\"\u0004\b\u0000\u0010\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\t0\u0003H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000f"}, d2={"shouldThrowAnyUnit", "", "block", "Lkotlin/Function0;", "", "shouldNotThrowAnyUnit", "shouldThrowAny", "", "shouldNotThrowAny", "T", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shouldThrowMessage", "message", "", "shouldNotThrowMessage", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nAnyThrowableHandling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnyThrowableHandling.kt\nio/kotest/assertions/throwables/AnyThrowableHandlingKt\n*L\n1#1,181:1\n84#1,9:182\n*S KotlinDebug\n*F\n+ 1 AnyThrowableHandling.kt\nio/kotest/assertions/throwables/AnyThrowableHandlingKt\n*L\n23#1:182,9\n*E\n"})
public final class AnyThrowableHandlingKt {
    @NotNull
    public static final Throwable shouldThrowAnyUnit(@NotNull Function0<Unit> block) {
        Throwable thrownException$iv;
        Throwable throwable;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$shouldThrowAnyUnit = false;
        boolean $i$f$shouldThrowAny = false;
        AssertionCounter_jvmKt.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e$iv) {
            throwable = e$iv;
        }
        Throwable throwable2 = thrownException$iv = throwable;
        if (throwable2 == null) {
            AssertionErrorBuilder.Companion.fail("Expected a throwable, but nothing was thrown.");
            throw new KotlinNothingValueException();
        }
        return throwable2;
    }

    public static final void shouldNotThrowAnyUnit(@NotNull Function0<Unit> block) {
        block2: {
            Throwable thrownException;
            Throwable throwable;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$shouldNotThrowAnyUnit = false;
            AssertionCounter_jvmKt.getAssertionCounter().inc();
            try {
                block.invoke();
                throwable = null;
            }
            catch (Throwable e) {
                throwable = e;
            }
            Throwable throwable2 = thrownException = throwable;
            if (throwable2 == null) break block2;
            Throwable it = throwable2;
            boolean bl = false;
            CollectorKt.collectOrThrow((ErrorCollector)jvmerrorcollector.getErrorCollector(), (Throwable)((Throwable)((Object)AssertionErrorBuilder.Companion.create().withMessage("No exception expected, but a " + Reflection.getOrCreateKotlinClass(thrownException.getClass()).getSimpleName() + " was thrown with message: \"" + thrownException.getMessage() + "\".").withCause(thrownException).build())));
        }
    }

    @NotNull
    public static final Throwable shouldThrowAny(@NotNull Function0<? extends Object> block) {
        Throwable thrownException;
        Throwable throwable;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$shouldThrowAny = false;
        AssertionCounter_jvmKt.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        Throwable throwable2 = thrownException = throwable;
        if (throwable2 == null) {
            AssertionErrorBuilder.Companion.fail("Expected a throwable, but nothing was thrown.");
            throw new KotlinNothingValueException();
        }
        return throwable2;
    }

    public static final <T> T shouldNotThrowAny(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$shouldNotThrowAny = false;
        AssertionCounter_jvmKt.getAssertionCounter().inc();
        try {
            return (T)block.invoke();
        }
        catch (Throwable e) {
            Throwable throwable;
            Throwable thrownException = throwable = e;
            throw AssertionErrorBuilder.Companion.create().withMessage("No exception expected, but a " + Reflection.getOrCreateKotlinClass(thrownException.getClass()).getSimpleName() + " was thrown with message: \"" + thrownException.getMessage() + "\".").withCause(thrownException).build();
        }
    }

    public static final <T> void shouldThrowMessage(@NotNull String message, @NotNull Function0<? extends T> block) {
        Throwable thrownException;
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$shouldThrowMessage = false;
        AssertionCounter_jvmKt.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        if ((thrownException = throwable) == null) {
            throw AssertionErrorBuilder.Companion.create().withMessage(StringsKt.trimMargin$default((String)("Expected a throwable with message " + StringPrint.INSTANCE.print(message).getValue() + " but nothing was thrown"), null, (int)1, null)).build();
        }
        if (!Intrinsics.areEqual((Object)thrownException.getMessage(), (Object)message)) {
            throw AssertionErrorBuilder.Companion.create().withMessage(StringsKt.trimMargin$default((String)("Expected a throwable with message " + StringPrint.INSTANCE.print(message).getValue() + " but got a throwable with message " + PrintKt.print(thrownException.getMessage()).getValue()), null, (int)1, null)).withCause(thrownException).build();
        }
    }

    public static final <T> void shouldNotThrowMessage(@NotNull String message, @NotNull Function0<? extends T> block) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$shouldNotThrowMessage = false;
        AssertionCounter_jvmKt.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        Throwable thrownException = throwable;
        if (thrownException != null && Intrinsics.areEqual((Object)thrownException.getMessage(), (Object)message)) {
            throw AssertionErrorBuilder.Companion.create().withMessage(StringsKt.trimMargin$default((String)("Expected no exception with message: \"" + message + "\"\n                          |but a " + Reflection.getOrCreateKotlinClass(thrownException.getClass()).getSimpleName() + " was thrown with given message"), null, (int)1, null)).withCause(thrownException).build();
        }
    }
}

