/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.floats;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0011\u0010\n\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002H\u0086\u0004R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kotest/matchers/floats/FloatToleranceMatcher;", "Lio/kotest/matchers/Matcher;", "", "expected", "tolerance", "<init>", "(FF)V", "test", "Lio/kotest/matchers/MatcherResult;", "value", "plusOrMinus", "kotest-assertions-core"})
public final class FloatToleranceMatcher
implements Matcher<Float> {
    private final float expected;
    private final float tolerance;

    public FloatToleranceMatcher(float expected, float tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @NotNull
    public MatcherResult test(float value) {
        MatcherResult matcherResult;
        if (Float.isNaN(this.expected) && Float.isNaN(value)) {
            System.out.println((Object)"[WARN] By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
            matcherResult = MatcherResult.Companion.invoke(false, FloatToleranceMatcher::test$lambda$0, FloatToleranceMatcher::test$lambda$1);
        } else {
            float diff;
            if (this.tolerance == 0.0f) {
                System.out.println((Object)"[WARN] When comparing Float consider using tolerance, eg: a shouldBe b plusOrMinus c");
            }
            matcherResult = MatcherResult.Companion.invoke((diff = Math.abs(value - this.expected)) <= this.tolerance, () -> FloatToleranceMatcher.test$lambda$2(value, this), () -> FloatToleranceMatcher.test$lambda$3(value, this));
        }
        return matcherResult;
    }

    @NotNull
    public final FloatToleranceMatcher plusOrMinus(float tolerance) {
        return new FloatToleranceMatcher(this.expected, tolerance);
    }

    @NotNull
    public Matcher<Float> invert() {
        return super.invert();
    }

    @NotNull
    public <U> Matcher<U> contramap(@NotNull Function1<? super U, Float> f) {
        return super.contramap(f);
    }

    @NotNull
    public Matcher<Float> invertIf(boolean invert) {
        return super.invertIf(invert);
    }

    private static final String test$lambda$0() {
        return "By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
    }

    private static final String test$lambda$1() {
        return "By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
    }

    private static final String test$lambda$2(float $value, FloatToleranceMatcher this$0) {
        return $value + " should be equal to " + this$0.expected;
    }

    private static final String test$lambda$3(float $value, FloatToleranceMatcher this$0) {
        return $value + " should not be equal to " + this$0.expected;
    }
}

