/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.bigdecimal;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.bigdecimal.BigDecimalToleranceKt;
import io.kotest.matchers.bigdecimal.ToleranceMatcher;
import io.kotest.matchers.doubles.Percentage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a\u001a\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u00a8\u0006\f"}, d2={"plusOrMinus", "Lio/kotest/matchers/bigdecimal/ToleranceMatcher;", "Ljava/math/BigDecimal;", "tolerance", "Lio/kotest/matchers/doubles/Percentage;", "shouldBeWithinPercentageOf", "", "other", "percentage", "shouldNotBeWithinPercentageOf", "beWithinPercentageOf", "Lio/kotest/matchers/Matcher;", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nBigDecimalTolerance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigDecimalTolerance.kt\nio/kotest/matchers/bigdecimal/BigDecimalToleranceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class BigDecimalToleranceKt {
    @NotNull
    public static final ToleranceMatcher plusOrMinus(@NotNull BigDecimal $this$plusOrMinus, @NotNull BigDecimal tolerance) {
        Intrinsics.checkNotNullParameter((Object)$this$plusOrMinus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tolerance, (String)"tolerance");
        if (!(tolerance.compareTo(BigDecimal.ZERO) >= 0)) {
            boolean bl = false;
            String string = "tolerance must be non-negative, was: " + tolerance;
            throw new IllegalArgumentException(string.toString());
        }
        return new ToleranceMatcher($this$plusOrMinus, tolerance);
    }

    @NotNull
    public static final ToleranceMatcher plusOrMinus(@NotNull BigDecimal $this$plusOrMinus, @NotNull Percentage tolerance) {
        Intrinsics.checkNotNullParameter((Object)$this$plusOrMinus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tolerance, (String)"tolerance");
        BigDecimal bigDecimal = $this$plusOrMinus.multiply(new BigDecimal(tolerance.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
        BigDecimal bigDecimal2 = bigDecimal.divide(new BigDecimal(100), RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"divide(...)");
        BigDecimal realValue = bigDecimal2.abs();
        Intrinsics.checkNotNull((Object)realValue);
        return new ToleranceMatcher($this$plusOrMinus, realValue);
    }

    public static final void shouldBeWithinPercentageOf(@NotNull BigDecimal $this$shouldBeWithinPercentageOf, @NotNull BigDecimal other, @NotNull BigDecimal percentage) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeWithinPercentageOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
        if (!(percentage.compareTo(BigDecimal.ZERO) > 0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.should($this$shouldBeWithinPercentageOf, BigDecimalToleranceKt.beWithinPercentageOf(other, percentage));
    }

    public static final void shouldNotBeWithinPercentageOf(@NotNull BigDecimal $this$shouldNotBeWithinPercentageOf, @NotNull BigDecimal other, @NotNull BigDecimal percentage) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeWithinPercentageOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
        if (!(percentage.compareTo(BigDecimal.ZERO) > 0)) {
            boolean bl = false;
            String string = "Percentage must be > 0, was: " + percentage;
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.shouldNot($this$shouldNotBeWithinPercentageOf, BigDecimalToleranceKt.beWithinPercentageOf(other, percentage));
    }

    @NotNull
    public static final Matcher<BigDecimal> beWithinPercentageOf(@NotNull BigDecimal other, @NotNull BigDecimal percentage) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
        return (Matcher)new Matcher<BigDecimal>(other, percentage){
            private final BigDecimal tolerance;
            private final ClosedRange<BigDecimal> range;
            {
                BigDecimal bigDecimal = $percentage.divide(new BigDecimal(100), RoundingMode.HALF_EVEN);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"divide(...)");
                BigDecimal bigDecimal2 = $other.multiply(bigDecimal);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"multiply(...)");
                this.tolerance = bigDecimal2.abs();
                BigDecimal bigDecimal3 = $other;
                BigDecimal bigDecimal4 = this.tolerance;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"tolerance");
                BigDecimal bigDecimal5 = bigDecimal3.subtract(bigDecimal4);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"subtract(...)");
                Comparable comparable = bigDecimal5;
                bigDecimal3 = $other;
                BigDecimal bigDecimal6 = this.tolerance;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"tolerance");
                BigDecimal bigDecimal7 = bigDecimal3.add(bigDecimal6);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"add(...)");
                this.range = RangesKt.rangeTo((Comparable)comparable, (Comparable)bigDecimal7);
            }

            public MatcherResult test(BigDecimal value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.range.contains((Comparable)value), () -> beWithinPercentageOf.1.test$lambda$0(value, this), () -> beWithinPercentageOf.1.test$lambda$1(value, this));
            }

            public Matcher<BigDecimal> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends BigDecimal> f) {
                return super.contramap(f);
            }

            public Matcher<BigDecimal> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(BigDecimal $value, beWithinPercentageOf.1 this$0) {
                return $value + " should be in " + this$0.range;
            }

            private static final String test$lambda$1(BigDecimal $value, beWithinPercentageOf.1 this$0) {
                return $value + " should not be in " + this$0.range;
            }
        };
    }
}

