/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.similarity;

import io.kotest.assertions.AssertionsConfig;
import io.kotest.assertions.print.PrintKt;
import io.kotest.assertions.similarity.ComparisonKt;
import io.kotest.assertions.similarity.ComparisonResult;
import io.kotest.assertions.similarity.Distance;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0003H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006%"}, d2={"Lio/kotest/assertions/similarity/StringMismatch;", "Lio/kotest/assertions/similarity/ComparisonResult;", "field", "", "expected", "actual", "mismatchDescription", "distance", "Lio/kotest/assertions/similarity/Distance;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/kotest/assertions/similarity/Distance;)V", "getField", "()Ljava/lang/String;", "getExpected", "getActual", "getMismatchDescription", "getDistance", "()Lio/kotest/assertions/similarity/Distance;", "description", "match", "", "getMatch", "()Z", "canBeSimilar", "getCanBeSimilar", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "kotest-assertions-core"})
public final class StringMismatch
implements ComparisonResult {
    @NotNull
    private final String field;
    @NotNull
    private final String expected;
    @NotNull
    private final String actual;
    @NotNull
    private final String mismatchDescription;
    @NotNull
    private final Distance distance;

    public StringMismatch(@NotNull String field, @NotNull String expected, @NotNull String actual, @NotNull String mismatchDescription, @NotNull Distance distance) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)mismatchDescription, (String)"mismatchDescription");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        this.field = field;
        this.expected = expected;
        this.actual = actual;
        this.mismatchDescription = mismatchDescription;
        this.distance = distance;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    @NotNull
    public final String getExpected() {
        return this.expected;
    }

    @NotNull
    public final String getActual() {
        return this.actual;
    }

    @NotNull
    public final String getMismatchDescription() {
        return this.mismatchDescription;
    }

    @Override
    @NotNull
    public Distance getDistance() {
        return this.distance;
    }

    @Override
    @NotNull
    public String description() {
        BigDecimal bigDecimal = this.getDistance().getDistance();
        BigDecimal bigDecimal2 = new BigDecimal(((Number)AssertionsConfig.INSTANCE.getSimilarityThresholdInPercentForStrings().getValue()).intValue()).multiply(Distance.Companion.getPERCENT_TO_DISTANCE());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"multiply(...)");
        return bigDecimal.compareTo(bigDecimal2) > 0 ? "    " + ComparisonKt.quotedIfNotEmpty(this.field) + " expected: <" + PrintKt.print(this.expected).getValue() + ">, found a similar value: <" + PrintKt.print(this.actual).getValue() + ">\n" + this.mismatchDescription : "    " + ComparisonKt.quotedIfNotEmpty(this.field) + " expected: <" + PrintKt.print(this.expected).getValue() + ">, but was: <" + PrintKt.print(this.actual).getValue() + ">";
    }

    @Override
    public boolean getMatch() {
        return false;
    }

    @Override
    public boolean getCanBeSimilar() {
        return true;
    }

    @NotNull
    public final String component1() {
        return this.field;
    }

    @NotNull
    public final String component2() {
        return this.expected;
    }

    @NotNull
    public final String component3() {
        return this.actual;
    }

    @NotNull
    public final String component4() {
        return this.mismatchDescription;
    }

    @NotNull
    public final Distance component5() {
        return this.distance;
    }

    @NotNull
    public final StringMismatch copy(@NotNull String field, @NotNull String expected, @NotNull String actual, @NotNull String mismatchDescription, @NotNull Distance distance) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)mismatchDescription, (String)"mismatchDescription");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        return new StringMismatch(field, expected, actual, mismatchDescription, distance);
    }

    public static /* synthetic */ StringMismatch copy$default(StringMismatch stringMismatch, String string, String string2, String string3, String string4, Distance distance, int n, Object object) {
        if ((n & 1) != 0) {
            string = stringMismatch.field;
        }
        if ((n & 2) != 0) {
            string2 = stringMismatch.expected;
        }
        if ((n & 4) != 0) {
            string3 = stringMismatch.actual;
        }
        if ((n & 8) != 0) {
            string4 = stringMismatch.mismatchDescription;
        }
        if ((n & 0x10) != 0) {
            distance = stringMismatch.distance;
        }
        return stringMismatch.copy(string, string2, string3, string4, distance);
    }

    @NotNull
    public String toString() {
        return "StringMismatch(field=" + this.field + ", expected=" + this.expected + ", actual=" + this.actual + ", mismatchDescription=" + this.mismatchDescription + ", distance=" + this.distance + ")";
    }

    public int hashCode() {
        int result2 = this.field.hashCode();
        result2 = result2 * 31 + this.expected.hashCode();
        result2 = result2 * 31 + this.actual.hashCode();
        result2 = result2 * 31 + this.mismatchDescription.hashCode();
        result2 = result2 * 31 + this.distance.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringMismatch)) {
            return false;
        }
        StringMismatch stringMismatch = (StringMismatch)other;
        if (!Intrinsics.areEqual((Object)this.field, (Object)stringMismatch.field)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expected, (Object)stringMismatch.expected)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.actual, (Object)stringMismatch.actual)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mismatchDescription, (Object)stringMismatch.mismatchDescription)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.distance, (Object)stringMismatch.distance);
    }
}

