/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.doubles;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/kotest/matchers/doubles/ToleranceMatcher;", "Lio/kotest/matchers/Matcher;", "", "expected", "tolerance", "<init>", "(Ljava/lang/Double;D)V", "Ljava/lang/Double;", "test", "Lio/kotest/matchers/MatcherResult;", "value", "(Ljava/lang/Double;)Lio/kotest/matchers/MatcherResult;", "kotest-assertions-core"})
public final class ToleranceMatcher
implements Matcher<Double> {
    @Nullable
    private final Double expected;
    private final double tolerance;

    public ToleranceMatcher(@Nullable Double expected, double tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @NotNull
    public MatcherResult test(@Nullable Double value) {
        MatcherResult matcherResult;
        if (value == null || this.expected == null || Double.isInfinite(this.expected)) {
            matcherResult = MatcherResult.Companion.invoke(Intrinsics.areEqual((Double)value, (Double)this.expected), () -> ToleranceMatcher.test$lambda$0(value, this), () -> ToleranceMatcher.test$lambda$1(value, this));
        } else if (Double.isNaN(this.expected) && Double.isNaN(value)) {
            System.out.println((Object)"[WARN] By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
            matcherResult = MatcherResult.Companion.invoke(false, ToleranceMatcher::test$lambda$2, ToleranceMatcher::test$lambda$3);
        } else {
            double diff;
            if (this.tolerance == 0.0) {
                System.out.println((Object)"[WARN] When comparing doubles consider using tolerance, eg: a shouldBe (b plusOrMinus c)");
            }
            boolean passed = (diff = Math.abs(value - this.expected)) <= this.tolerance;
            double low = this.expected - this.tolerance;
            double high = this.expected + this.tolerance;
            String msg = this.tolerance == 0.0 ? value + " should be equal to " + this.expected : value + " should be equal to " + this.expected + " within tolerance of " + this.tolerance + " (lowest acceptable value is " + low + "; highest acceptable value is " + high + ")";
            matcherResult = MatcherResult.Companion.invoke(passed, () -> ToleranceMatcher.test$lambda$4(msg), () -> ToleranceMatcher.test$lambda$5(value, this));
        }
        return matcherResult;
    }

    private static final String test$lambda$0(Double $value, ToleranceMatcher this$0) {
        return $value + " should be equal to " + this$0.expected;
    }

    private static final String test$lambda$1(Double $value, ToleranceMatcher this$0) {
        return $value + " should not be equal to " + this$0.expected;
    }

    private static final String test$lambda$2() {
        return "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
    }

    private static final String test$lambda$3() {
        return "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
    }

    private static final String test$lambda$4(String $msg) {
        return $msg;
    }

    private static final String test$lambda$5(Double $value, ToleranceMatcher this$0) {
        return $value + " should not be equal to " + this$0.expected;
    }
}

