/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.paths;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.paths.ContentsKt;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u001a#\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a#\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u001a\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0005H\u0086\u0004\u001a\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0005H\u0086\u0004\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"shouldContainFiles", "", "Ljava/nio/file/Path;", "files", "", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)V", "shouldNotContainFiles", "containFiles", "Lio/kotest/matchers/Matcher;", "names", "", "shouldContainFile", "name", "shouldNotContainFile", "containFile", "kotest-assertions-core"})
public final class ContentsKt {
    public static final void shouldContainFiles(@NotNull Path $this$shouldContainFiles, String ... files) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        ShouldKt.should($this$shouldContainFiles, ContentsKt.containFiles(ArraysKt.asList((Object[])files)));
    }

    public static final void shouldNotContainFiles(@NotNull Path $this$shouldNotContainFiles, String ... files) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        ShouldKt.shouldNot($this$shouldNotContainFiles, ContentsKt.containFiles(ArraysKt.asList((Object[])files)));
    }

    @NotNull
    public static final Matcher<Path> containFiles(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return (Matcher)new Matcher<Path>(names){
            final /* synthetic */ List<String> $names;
            {
                this.$names = $names;
            }

            /*
             * WARNING - void declaration
             */
            public MatcherResult test(Path value) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(value);
                Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"newDirectoryStream(...)");
                Iterable $this$map$iv = CollectionsKt.toList((Iterable)directoryStream);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(PathsKt.getName((Path)it));
                }
                List contents = (List)destination$iv$iv;
                Set existingFiles = CollectionsKt.intersect((Iterable)this.$names, (Iterable)CollectionsKt.toSet((Iterable)contents));
                Set nonExistingFiles = CollectionsKt.subtract((Iterable)this.$names, (Iterable)existingFiles);
                return MatcherResult.Companion.invoke(nonExistingFiles.isEmpty(), () -> containFiles.1.test$lambda$1(this, value, nonExistingFiles), () -> containFiles.1.test$lambda$2(this, value, existingFiles));
            }

            private final String buildMessage(Path path, Set<String> fileList, boolean isNegative) {
                String fileString = fileList.size() > 1 ? "Files" : "File";
                String negativeWord = isNegative ? " not" : "";
                String filesString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)fileList), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                return fileString + " " + filesString + " should" + negativeWord + " exist in " + path;
            }

            private static final String test$lambda$1(containFiles.1 this$0, Path $value, Set $nonExistingFiles) {
                return this$0.buildMessage($value, $nonExistingFiles, false);
            }

            private static final String test$lambda$2(containFiles.1 this$0, Path $value, Set $existingFiles) {
                return this$0.buildMessage($value, $existingFiles, true);
            }
        };
    }

    public static final void shouldContainFile(@NotNull Path $this$shouldContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should($this$shouldContainFile, ContentsKt.containFile(name));
    }

    public static final void shouldNotContainFile(@NotNull Path $this$shouldNotContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot($this$shouldNotContainFile, ContentsKt.containFile(name));
    }

    @NotNull
    public static final Matcher<Path> containFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<Path>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            /*
             * WARNING - void declaration
             */
            public MatcherResult test(Path value) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(value);
                Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"newDirectoryStream(...)");
                Iterable $this$map$iv = CollectionsKt.toList((Iterable)directoryStream);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(PathsKt.getName((Path)it));
                }
                List contents = (List)destination$iv$iv;
                boolean passed = Files.isDirectory(value, new LinkOption[0]) && contents.contains(this.$name);
                return MatcherResult.Companion.invoke(passed, () -> containFile.1.test$lambda$1(value, this.$name, contents), () -> containFile.1.test$lambda$2(value, this.$name));
            }

            private static final String test$lambda$1(Path $value, String $name, List $contents) {
                return "Directory " + $value + " should contain a file with filename " + $name + " (detected " + $contents.size() + " other files)";
            }

            private static final String test$lambda$2(Path $value, String $name) {
                return "Directory " + $value + " should not contain a file with filename " + $name;
            }
        };
    }
}

