/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.paths;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.paths.SizesKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a8\u0006\u000b"}, d2={"shouldBeLarger", "", "Ljava/nio/file/Path;", "other", "Ljava/io/File;", "shouldNotBeLarger", "beLarger", "Lio/kotest/matchers/Matcher;", "shouldBeSmaller", "shouldNotBeSmaller", "beSmaller", "kotest-assertions-core"})
public final class SizesKt {
    public static final void shouldBeLarger(@NotNull Path $this$shouldBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should($this$shouldBeLarger, SizesKt.beLarger(other));
    }

    public static final void shouldBeLarger(@NotNull Path $this$shouldBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = other.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ShouldKt.should($this$shouldBeLarger, SizesKt.beLarger(path));
    }

    public static final void shouldNotBeLarger(@NotNull Path $this$shouldNotBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot($this$shouldNotBeLarger, SizesKt.beLarger(other));
    }

    public static final void shouldNotBeLarger(@NotNull Path $this$shouldNotBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = other.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ShouldKt.shouldNot($this$shouldNotBeLarger, SizesKt.beLarger(path));
    }

    @NotNull
    public static final Matcher<Path> beLarger(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<Path>(other){
            final /* synthetic */ Path $other;
            {
                this.$other = $other;
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = Files.size(value);
                long sizeb = Files.size(this.$other);
                return MatcherResult.Companion.invoke(sizea > sizeb, () -> beLarger.1.test$lambda$0(value, sizea, this.$other, sizeb), () -> beLarger.1.test$lambda$1(value, sizea, this.$other, sizeb));
            }

            private static final String test$lambda$0(Path $value, long $sizea, Path $other, long $sizeb) {
                return "Path " + $value + " (" + $sizea + " bytes) should be larger than " + $other + " (" + $sizeb + " bytes)";
            }

            private static final String test$lambda$1(Path $value, long $sizea, Path $other, long $sizeb) {
                return "Path " + $value + " (" + $sizea + " bytes) should not be larger than " + $other + " (" + $sizeb + " bytes)";
            }
        };
    }

    public static final void shouldBeSmaller(@NotNull Path $this$shouldBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should($this$shouldBeSmaller, SizesKt.beSmaller(other));
    }

    public static final void shouldBeSmaller(@NotNull Path $this$shouldBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = other.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ShouldKt.should($this$shouldBeSmaller, SizesKt.beSmaller(path));
    }

    public static final void shouldNotBeSmaller(@NotNull Path $this$shouldNotBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot($this$shouldNotBeSmaller, SizesKt.beSmaller(other));
    }

    public static final void shouldNotBeSmaller(@NotNull Path $this$shouldNotBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = other.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ShouldKt.shouldNot($this$shouldNotBeSmaller, SizesKt.beSmaller(path));
    }

    @NotNull
    public static final Matcher<Path> beSmaller(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<Path>(other){
            final /* synthetic */ Path $other;
            {
                this.$other = $other;
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = Files.size(value);
                long sizeb = Files.size(this.$other);
                return MatcherResult.Companion.invoke(sizea < sizeb, () -> beSmaller.1.test$lambda$0(value, sizea, this.$other, sizeb), () -> beSmaller.1.test$lambda$1(value, sizea, this.$other, sizeb));
            }

            private static final String test$lambda$0(Path $value, long $sizea, Path $other, long $sizeb) {
                return "Path " + $value + " (" + $sizea + " bytes) should be smaller than " + $other + " (" + $sizeb + " bytes)";
            }

            private static final String test$lambda$1(Path $value, long $sizea, Path $other, long $sizeb) {
                return "Path " + $value + " (" + $sizea + " bytes) should not be smaller than " + $other + " (" + $sizeb + " bytes)";
            }
        };
    }
}

