/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.system;

import io.kotest.common.SoftDeprecated;
import io.kotest.core.descriptors.Descriptor;
import io.kotest.core.descriptors.KclassesKt;
import io.kotest.core.listeners.TestListener;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.extensions.system.NoExitSecurityManager;
import io.kotest.matchers.ShouldKt;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000eR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/kotest/extensions/system/SpecSystemExitListener;", "Lio/kotest/core/listeners/TestListener;", "()V", "previousSecurityManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/kotest/core/descriptors/Descriptor;", "Ljava/lang/SecurityManager;", "afterSpec", "", "spec", "Lio/kotest/core/spec/Spec;", "(Lio/kotest/core/spec/Spec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beforeSpec", "lastExitCode", "", "()Ljava/lang/Integer;", "shouldHaveExitCode", "code", "kotest-extensions"})
public final class SpecSystemExitListener
implements TestListener {
    @NotNull
    public static final SpecSystemExitListener INSTANCE = new SpecSystemExitListener();
    @NotNull
    private static final ConcurrentHashMap<Descriptor, SecurityManager> previousSecurityManagers = new ConcurrentHashMap();

    private SpecSystemExitListener() {
    }

    @Nullable
    public Object beforeSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
        SecurityManager previous = System.getSecurityManager();
        if (previous != null) {
            ((Map)previousSecurityManagers).put(KclassesKt.toDescriptor((KClass)Reflection.getOrCreateKotlinClass(spec.getClass())), previous);
        }
        System.setSecurityManager(new NoExitSecurityManager(previous));
        return Unit.INSTANCE;
    }

    @Nullable
    public Object afterSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
        if (previousSecurityManagers.contains(KclassesKt.toDescriptor((KClass)Reflection.getOrCreateKotlinClass(spec.getClass())))) {
            System.setSecurityManager(previousSecurityManagers.get(KclassesKt.toDescriptor((KClass)Reflection.getOrCreateKotlinClass(spec.getClass()))));
        } else {
            System.setSecurityManager(null);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Integer lastExitCode() {
        SecurityManager manager = System.getSecurityManager();
        return manager instanceof NoExitSecurityManager ? ((NoExitSecurityManager)manager).getLastExitCode() : null;
    }

    public final void shouldHaveExitCode(int code) {
        ShouldKt.shouldBe((Object)this.lastExitCode(), (Object)code);
    }

    @NotNull
    public String getName() {
        return TestListener.DefaultImpls.getName((TestListener)this);
    }

    @Nullable
    public Object afterAny(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterAny((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object afterContainer(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterContainer((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object afterEach(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterEach((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object afterInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterInvocation((TestListener)this, (TestCase)testCase, (int)iteration, $completion);
    }

    @SoftDeprecated(message="Use afterAny")
    @Nullable
    public Object afterTest(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterTest((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object beforeAny(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeAny((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object beforeContainer(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeContainer((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object beforeEach(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeEach((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object beforeInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeInvocation((TestListener)this, (TestCase)testCase, (int)iteration, $completion);
    }

    @SoftDeprecated(message="Use beforeAny")
    @Nullable
    public Object beforeTest(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeTest((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object finalizeSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Map<TestCase, ? extends TestResult> results, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.finalizeSpec((TestListener)this, kclass, results, $completion);
    }

    @Nullable
    public Object prepareSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.prepareSpec((TestListener)this, kclass, $completion);
    }
}

