/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.property.seed;

import io.kotest.assertions.print.PrintKt;
import io.kotest.core.descriptors.DescriptorPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u001a\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\u0003H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0003H\u0002\"\u001b\u0010\t\u001a\u00020\n8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"readSeed", "", "path", "Lio/kotest/core/descriptors/DescriptorPath;", "(Lio/kotest/core/descriptors/DescriptorPath;)Ljava/lang/Long;", "writeSeed", "", "seed", "clearSeed", "seedDirectory", "Ljava/nio/file/Path;", "getSeedDirectory", "()Ljava/nio/file/Path;", "seedDirectory$delegate", "Lkotlin/Lazy;", "seedPath", "seedFileName", "", "kotest-property"})
@SourceDebugExtension(value={"SMAP\nseedio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 seedio.kt\nio/kotest/property/seed/SeedioKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class SeedioKt {
    @NotNull
    private static final Lazy seedDirectory$delegate = LazyKt.lazy(SeedioKt::seedDirectory_delegate$lambda$2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Long readSeed(@NotNull DescriptorPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Object object = SeedioKt.seedPath(path);
            Path p0 = object;
            boolean $i$f$readSeed$exists = false;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return null;
            Path path2 = object;
            Path path3 = path2;
            if (path3 == null) return null;
            object = PathsKt.readText$default((Path)path3, null, (int)1, null);
            if (object == null) return null;
            String string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
            if (string == null) return null;
            Long l = StringsKt.toLongOrNull((String)string);
            return l;
        }
        catch (Exception e) {
            System.out.println((Object)("Error reading seed for " + path));
            PrintKt.print((Object)e);
            return null;
        }
    }

    public static final void writeSeed(@NotNull DescriptorPath path, long seed) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Path f = SeedioKt.seedPath(path);
            PathsKt.createParentDirectories((Path)f, (FileAttribute[])new FileAttribute[0]);
            PathsKt.writeText$default((Path)f, (CharSequence)String.valueOf(seed), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        catch (Exception e) {
            System.out.println((Object)("Error writing seed " + seed + " for " + path));
            e.printStackTrace();
        }
    }

    public static final void clearSeed(@NotNull DescriptorPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Path f = SeedioKt.seedPath(path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(f, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !Intrinsics.areEqual((Object)f, (Object)SeedioKt.getSeedDirectory()) && f.startsWith(SeedioKt.getSeedDirectory())) {
                Files.deleteIfExists(f);
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Error clearing seed " + path));
            e.printStackTrace();
        }
    }

    @NotNull
    public static final Path seedDirectory() {
        return SeedioKt.getSeedDirectory();
    }

    @NotNull
    public static final Path getSeedDirectory() {
        Lazy lazy2 = seedDirectory$delegate;
        Object object = lazy2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    private static final Path seedPath(DescriptorPath $this$seedPath) {
        Path path = SeedioKt.getSeedDirectory().resolve(SeedioKt.seedFileName($this$seedPath));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final String seedFileName(DescriptorPath $this$seedFileName) {
        CharSequence charSequence = $this$seedFileName.getValue();
        Regex regex = new Regex("[/\\\\<>:()]");
        String string = "_";
        return regex.replace(charSequence, string);
    }

    private static final Path seedDirectory_delegate$lambda$2() {
        Path path;
        String string;
        block6: {
            block5: {
                CharSequence charSequence;
                string = System.getenv("XDG_CACHE_HOME");
                if (string == null) break block5;
                CharSequence charSequence2 = string;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                if ((string = (String)charSequence) != null) break block6;
            }
            string = System.getProperty("user.home");
        }
        String baseDir = string;
        Intrinsics.checkNotNull((Object)baseDir);
        Path path2 = Paths.get(baseDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path kotestConfigDir = path2.resolve(".kotest");
        Path $this$seedDirectory_delegate_u24lambda_u242_u24lambda_u241 = path = kotestConfigDir.resolve("seeds");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$seedDirectory_delegate_u24lambda_u242_u24lambda_u241);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$seedDirectory_delegate_u24lambda_u242_u24lambda_u241, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        return path;
    }
}

