/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.okhttp;

import io.ktor.client.engine.okhttp.OkHttpCallback;
import io.ktor.client.engine.okhttp.StreamAdapterIOException;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestData;
import io.ktor.http.Headers;
import io.ktor.http.HttpProtocolVersion;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.Job;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a,\u0010\b\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0080@\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\f\u001a\u00020\u000b*\u00020\nH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0013\u0010\f\u001a\u00020\u000f*\u00020\u000eH\u0000\u00a2\u0006\u0004\b\f\u0010\u0010\u001a\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0013\u0010\u0017\u001a\u00020\u0016*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lokhttp3/OkHttpClient;", "Lokhttp3/Request;", "request", "Lio/ktor/client/request/HttpRequestData;", "requestData", "Lkotlin/coroutines/CoroutineContext;", "callContext", "Lokhttp3/Response;", "execute", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lokhttp3/Headers;", "Lio/ktor/http/Headers;", "fromOkHttp", "(Lokhttp3/Headers;)Lio/ktor/http/Headers;", "Lokhttp3/Protocol;", "Lio/ktor/http/HttpProtocolVersion;", "(Lokhttp3/Protocol;)Lio/ktor/http/HttpProtocolVersion;", "Ljava/io/IOException;", "origin", "", "mapOkHttpException", "(Lio/ktor/client/request/HttpRequestData;Ljava/io/IOException;)Ljava/lang/Throwable;", "", "isConnectException", "(Ljava/io/IOException;)Z", "ktor-client-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkUtils.kt\nio/ktor/client/engine/okhttp/OkUtilsKt\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,96:1\n426#2,11:97\n*S KotlinDebug\n*F\n+ 1 OkUtils.kt\nio/ktor/client/engine/okhttp/OkUtilsKt\n*L\n28#1:97,11\n*E\n"})
public final class OkUtilsKt {
    @Nullable
    public static final Object execute(@NotNull OkHttpClient $this$execute, @NotNull Request request, @NotNull HttpRequestData requestData, @NotNull CoroutineContext callContext, @NotNull Continuation<? super Response> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Response> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Call call = $this$execute.newCall(request);
        CoroutineContext.Element element = callContext.get((CoroutineContext.Key)Job.Key);
        Intrinsics.checkNotNull((Object)element);
        Job.DefaultImpls.invokeOnCompletion$default((Job)((Job)element), (boolean)true, (boolean)false, (Function1)((Function1)new Function1<Throwable, Unit>(call){
            final /* synthetic */ Call $call;
            {
                this.$call = $call;
            }

            public final void invoke(Throwable it) {
                this.$call.cancel();
            }
        }), (int)2, null);
        OkHttpCallback callback = new OkHttpCallback(requestData, (CancellableContinuation<? super Response>)continuation);
        call.enqueue((Callback)callback);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @NotNull
    public static final Headers fromOkHttp(@NotNull okhttp3.Headers $this$fromOkHttp) {
        Intrinsics.checkNotNullParameter((Object)$this$fromOkHttp, (String)"<this>");
        return new Headers($this$fromOkHttp){
            private final boolean caseInsensitiveName;
            final /* synthetic */ okhttp3.Headers $this_fromOkHttp;
            {
                this.$this_fromOkHttp = $receiver;
                this.caseInsensitiveName = true;
            }

            public boolean getCaseInsensitiveName() {
                return this.caseInsensitiveName;
            }

            public List<String> getAll(String name) {
                List<E> list;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                List<E> it = list = this.$this_fromOkHttp.values(name);
                boolean bl = false;
                return !((Collection)it).isEmpty() ? list : null;
            }

            public Set<String> names() {
                return this.$this_fromOkHttp.names();
            }

            public Set<Map.Entry<String, List<String>>> entries() {
                return this.$this_fromOkHttp.toMultimap().entrySet();
            }

            public boolean isEmpty() {
                return this.$this_fromOkHttp.size() == 0;
            }
        };
    }

    @NotNull
    public static final HttpProtocolVersion fromOkHttp(@NotNull Protocol $this$fromOkHttp) {
        HttpProtocolVersion httpProtocolVersion;
        Intrinsics.checkNotNullParameter((Object)$this$fromOkHttp, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$fromOkHttp.ordinal()]) {
            case 1: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_1_0();
                break;
            }
            case 2: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_1_1();
                break;
            }
            case 3: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getSPDY_3();
                break;
            }
            case 4: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_2_0();
                break;
            }
            case 5: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_2_0();
                break;
            }
            case 6: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getQUIC();
                break;
            }
            case 7: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_3_0();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpProtocolVersion;
    }

    private static final Throwable mapOkHttpException(HttpRequestData requestData, IOException origin) {
        Throwable throwable;
        IOException iOException = origin;
        if (iOException instanceof StreamAdapterIOException) {
            throwable = origin.getCause();
            if (throwable == null) {
                throwable = origin;
            }
        } else {
            throwable = iOException instanceof SocketTimeoutException ? (Throwable)(OkUtilsKt.isConnectException(origin) ? (IOException)HttpTimeoutKt.ConnectTimeoutException((HttpRequestData)requestData, (Throwable)origin) : (IOException)HttpTimeoutKt.SocketTimeoutException((HttpRequestData)requestData, (Throwable)origin)) : (Throwable)origin;
        }
        return throwable;
    }

    private static final boolean isConnectException(IOException $this$isConnectException) {
        String string = $this$isConnectException.getMessage();
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"connect", (boolean)true) : false;
    }

    public static final /* synthetic */ Throwable access$mapOkHttpException(HttpRequestData requestData, IOException origin) {
        return OkUtilsKt.mapOkHttpException(requestData, origin);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Protocol.values().length];
            try {
                nArray[Protocol.HTTP_1_0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.HTTP_1_1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.SPDY_3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.HTTP_2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.H2_PRIOR_KNOWLEDGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.QUIC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.HTTP_3.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

