/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.compiler.utils;

import io.ktor.compiler.utils.FirScopedEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007\u001a&\u0010\b\u001a\u00020\t2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a,\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a,\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a,\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0001H\u0002\u00a8\u0006\u0017"}, d2={"createCallStackEvaluator", "Lio/ktor/compiler/utils/FirScopedEvaluator;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "callStack", "", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;)Lio/ktor/compiler/utils/FirScopedEvaluator;", "processCallStack", "", "evaluator", "processFunction", "call", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "mapArgumentsToParameters", "inferTypeParameters", "inferTypeParametersFromTypes", "argumentType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "parameterType", "typeScope", "Lio/ktor/compiler/utils/FirScopedEvaluator$TypeSubstitutionContext;", "ktor-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nCallStackEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallStackEvaluator.kt\nio/ktor/compiler/utils/CallStackEvaluatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1869#2:211\n1870#2:213\n808#2,11:214\n1869#2,2:225\n1#3:212\n*S KotlinDebug\n*F\n+ 1 CallStackEvaluator.kt\nio/ktor/compiler/utils/CallStackEvaluatorKt\n*L\n98#1:211\n98#1:213\n164#1:214,11\n164#1:225,2\n*E\n"})
public final class CallStackEvaluatorKt {
    @NotNull
    public static final FirScopedEvaluator createCallStackEvaluator(@NotNull FirSession session, @NotNull List<? extends FirFunctionCall> callStack) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(callStack, (String)"callStack");
        FirScopedEvaluator evaluator = new FirScopedEvaluator(session);
        CallStackEvaluatorKt.processCallStack(callStack, evaluator, session);
        return evaluator;
    }

    private static final void processCallStack(List<? extends FirFunctionCall> callStack, FirScopedEvaluator evaluator, FirSession session) {
        if (callStack.isEmpty()) {
            return;
        }
        int n = callStack.size();
        for (int i = 0; i < n; ++i) {
            FirFunctionSymbol functionSymbol;
            FirResolvedNamedReference calleeReference;
            FirBasedSymbol firBasedSymbol;
            FirFunctionCall call = callStack.get(i);
            FirNamedReference firNamedReference = call.getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = firNamedReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firNamedReference : null;
            if (firResolvedNamedReference == null || ((firBasedSymbol = (calleeReference = firResolvedNamedReference).getResolvedSymbol()) instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol : null) == null) continue;
            functionSymbol = functionSymbol;
            CallStackEvaluatorKt.processFunction(call, functionSymbol, evaluator, session);
        }
    }

    private static final void processFunction(FirFunctionCall call, FirFunctionSymbol<?> function, FirScopedEvaluator evaluator, FirSession session) {
        CallStackEvaluatorKt.mapArgumentsToParameters(call, function, evaluator, session);
        CallStackEvaluatorKt.inferTypeParameters(call, function, evaluator, session);
    }

    private static final void mapArgumentsToParameters(FirFunctionCall call, FirFunctionSymbol<?> function, FirScopedEvaluator evaluator, FirSession session) {
        block6: {
            List arguments = call.getArgumentList().getArguments();
            List parameters = function.getValueParameterSymbols();
            int paramIndex = 0;
            int n = ((Collection)arguments).size();
            for (int i = 0; i < n && paramIndex < parameters.size(); ++i) {
                FirExpression it;
                FirExpression argument = (FirExpression)arguments.get(i);
                if (argument instanceof FirNamedArgumentExpression) continue;
                FirValueParameterSymbol parameter = (FirValueParameterSymbol)parameters.get(paramIndex++);
                FirExpression evaluatedArg = evaluator.evaluateAsExpression(argument);
                if (evaluatedArg == null) continue;
                boolean bl2 = false;
                evaluator.getVariables().setVariableValue((FirBasedSymbol)parameter, it);
            }
            Iterable $this$forEach$iv = arguments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it;
                FirValueParameterSymbol parameter;
                Object v0;
                FirExpression arg;
                block5: {
                    arg = (FirExpression)element$iv;
                    boolean bl = false;
                    if (!(arg instanceof FirNamedArgumentExpression)) continue;
                    Name paramName = ((FirNamedArgumentExpression)arg).getName();
                    Iterable bl2 = parameters;
                    for (Object t : bl2) {
                        FirValueParameterSymbol it2 = (FirValueParameterSymbol)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)paramName)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                if ((FirValueParameterSymbol)v0 == null) continue;
                FirExpression evaluatedArg = evaluator.evaluateAsExpression(((FirNamedArgumentExpression)arg).getExpression());
                if (evaluatedArg == null) continue;
                boolean bl = false;
                evaluator.getVariables().setVariableValue((FirBasedSymbol)parameter, it);
            }
            FirReceiverParameterSymbol firReceiverParameterSymbol = function.getReceiverParameterSymbol();
            if (firReceiverParameterSymbol == null) break block6;
            FirReceiverParameterSymbol receiverParam = firReceiverParameterSymbol;
            boolean bl = false;
            FirExpression firExpression = call.getExtensionReceiver();
            if (firExpression != null) {
                FirExpression evaluatedReceiver;
                FirExpression receiver = firExpression;
                boolean bl4 = false;
                FirExpression firExpression2 = evaluatedReceiver = evaluator.evaluateAsExpression(receiver);
                if (firExpression2 != null) {
                    FirExpression it = firExpression2;
                    boolean bl5 = false;
                    evaluator.getVariables().setVariableValue((FirBasedSymbol)receiverParam, it);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void inferTypeParameters(FirFunctionCall call, FirFunctionSymbol<?> function, FirScopedEvaluator evaluator, FirSession session) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable parameter;
        List typeParameters = function.getTypeParameterSymbols();
        if (typeParameters.isEmpty()) {
            return;
        }
        List typeArguments = call.getTypeArguments();
        int n = ((Collection)typeArguments).size();
        for (int i = 0; i < n && i < typeParameters.size(); ++i) {
            ConeKotlinType concreteType;
            FirTypeProjection typeArg = (FirTypeProjection)typeArguments.get(i);
            FirTypeParameterSymbol typeParamSymbol = (FirTypeParameterSymbol)typeParameters.get(i);
            if (!(typeArg instanceof FirTypeProjectionWithVariance)) continue;
            FirTypeRef firTypeRef = ((FirTypeProjectionWithVariance)typeArg).getTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            Object object = concreteType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            if (concreteType == null) continue;
            evaluator.getTypes().setTypeSubstitution(typeParamSymbol, concreteType);
        }
        List arguments = call.getArgumentList().getArguments();
        List valueParameters = function.getValueParameterSymbols();
        int paramIndex = 0;
        for (FirExpression arg : arguments) {
            if (arg instanceof FirNamedArgumentExpression) continue;
            if ((FirValueParameterSymbol)CollectionsKt.getOrNull((List)valueParameters, (int)paramIndex++) == null) break;
            CallStackEvaluatorKt.inferTypeParametersFromTypes(FirTypeUtilsKt.getResolvedType((FirExpression)arg), parameter.getResolvedReturnType(), evaluator.getTypes());
        }
        Iterable $this$filterIsInstance$iv = arguments;
        boolean $i$f$filterIsInstance = false;
        parameter = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirNamedArgumentExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol parameter2;
            Object v2;
            FirNamedArgumentExpression named;
            block6: {
                named = (FirNamedArgumentExpression)element$iv;
                boolean bl = false;
                Iterable iterable = valueParameters;
                for (Object t : iterable) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)named.getName())) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            if ((FirValueParameterSymbol)v2 == null) continue;
            CallStackEvaluatorKt.inferTypeParametersFromTypes(FirTypeUtilsKt.getResolvedType((FirExpression)named.getExpression()), parameter2.getResolvedReturnType(), evaluator.getTypes());
        }
    }

    private static final void inferTypeParametersFromTypes(ConeKotlinType argumentType, ConeKotlinType parameterType, FirScopedEvaluator.TypeSubstitutionContext typeScope) {
        if (parameterType instanceof ConeTypeParameterType) {
            FirTypeParameterSymbol symbol = ((ConeTypeParameterType)parameterType).getLookupTag().getTypeParameterSymbol();
            typeScope.setTypeSubstitution(symbol, argumentType);
        } else if (argumentType instanceof ConeClassLikeType && parameterType instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)argumentType).getLookupTag().getClassId(), (Object)((ConeClassLikeType)parameterType).getLookupTag().getClassId())) {
            ConeTypeProjection[] argumentTypeArgs = argumentType.getTypeArguments();
            ConeTypeProjection[] parameterTypeArgs = parameterType.getTypeArguments();
            int minSize = Math.min(argumentTypeArgs.length, parameterTypeArgs.length);
            for (int i = 0; i < minSize; ++i) {
                ConeTypeProjection argTypeArg = argumentTypeArgs[i];
                ConeTypeProjection paramTypeArg = parameterTypeArgs[i];
                if (!(argTypeArg instanceof ConeKotlinTypeProjection) || !(paramTypeArg instanceof ConeKotlinTypeProjection) || argTypeArg.getKind() != paramTypeArg.getKind()) continue;
                CallStackEvaluatorKt.inferTypeParametersFromTypes(((ConeKotlinTypeProjection)argTypeArg).getType(), ((ConeKotlinTypeProjection)paramTypeArg).getType(), typeScope);
            }
        } else if (argumentType instanceof ConeFlexibleType && parameterType instanceof ConeFlexibleType) {
            CallStackEvaluatorKt.inferTypeParametersFromTypes((ConeKotlinType)((ConeFlexibleType)argumentType).getLowerBound(), (ConeKotlinType)((ConeFlexibleType)parameterType).getLowerBound(), typeScope);
            CallStackEvaluatorKt.inferTypeParametersFromTypes((ConeKotlinType)((ConeFlexibleType)argumentType).getUpperBound(), (ConeKotlinType)((ConeFlexibleType)parameterType).getUpperBound(), typeScope);
        }
    }
}

