/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.openapi;

import io.ktor.openapi.OpenApiExtension;
import io.ktor.openapi.OpenApiProcessorConfig;
import io.ktor.openapi.OpenApiRouteCallReader;
import io.ktor.openapi.OpenApiSpecGenerator;
import io.ktor.openapi.model.SpecInfo;
import io.ktor.openapi.routing.ContentType;
import io.ktor.openapi.routing.RouteCallGraph;
import io.ktor.openapi.routing.RouteNode;
import io.ktor.openapi.routing.RoutingReferenceResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.ExpressionCheckers;
import org.jetbrains.kotlin.fir.analysis.extensions.FirAdditionalCheckersExtension;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000e\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u0011*\u00060\u0012R\u00020\u0001H\u0014J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lio/ktor/openapi/OpenApiExtension;", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionRegistrar;", "config", "Lio/ktor/openapi/OpenApiProcessorConfig;", "<init>", "(Lio/ktor/openapi/OpenApiProcessorConfig;)V", "routeGraph", "Lio/ktor/openapi/routing/RouteCallGraph;", "defaultContentType", "", "securitySchemes", "", "Lio/ktor/openapi/routing/RoutingReferenceResult$SecurityScheme;", "routeCallReader", "io/ktor/openapi/OpenApiExtension$routeCallReader$1", "Lio/ktor/openapi/OpenApiExtension$routeCallReader$1;", "configurePlugin", "", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionRegistrar$ExtensionRegistrarContext;", "isEmpty", "", "registerChecker", "Lorg/jetbrains/kotlin/fir/analysis/extensions/FirAdditionalCheckersExtension;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "saveSpecification", "json", "Lkotlinx/serialization/json/Json;", "OpenApiFirAdditionalChecksExtension", "ktor-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nOpenApiExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiExtension.kt\nio/ktor/openapi/OpenApiExtension\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,115:1\n205#2:116\n*S KotlinDebug\n*F\n+ 1 OpenApiExtension.kt\nio/ktor/openapi/OpenApiExtension\n*L\n66#1:116\n*E\n"})
public final class OpenApiExtension
extends FirExtensionRegistrar {
    @NotNull
    private final OpenApiProcessorConfig config;
    private RouteCallGraph routeGraph;
    @NotNull
    private String defaultContentType;
    @NotNull
    private final List<RoutingReferenceResult.SecurityScheme> securitySchemes;
    @NotNull
    private final routeCallReader.1 routeCallReader;

    public OpenApiExtension(@NotNull OpenApiProcessorConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.defaultContentType = ContentType.JSON.getValue();
        this.securitySchemes = new ArrayList();
        this.routeCallReader = new OpenApiRouteCallReader(this){
            final /* synthetic */ OpenApiExtension this$0;
            {
                this.this$0 = $receiver;
                super(null, 1, null);
            }

            public void onRoutingReference(RouteNode reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                RouteCallGraph routeCallGraph = OpenApiExtension.access$getRouteGraph$p(this.this$0);
                if (routeCallGraph == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"routeGraph");
                    routeCallGraph = null;
                }
                routeCallGraph.add(reference);
            }

            public void onContentNegotiation(ContentType contentType) {
                Intrinsics.checkNotNullParameter((Object)((Object)contentType), (String)"contentType");
                OpenApiExtension.access$setDefaultContentType$p(this.this$0, contentType.getValue());
            }

            public void onSecurityScheme(RoutingReferenceResult.SecurityScheme security) {
                Intrinsics.checkNotNullParameter((Object)security, (String)"security");
                OpenApiExtension.access$getSecuritySchemes$p(this.this$0).add(security);
            }
        };
    }

    protected void configurePlugin(@NotNull FirExtensionRegistrar.ExtensionRegistrarContext $this$configurePlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$configurePlugin, (String)"<this>");
        $this$configurePlugin.plusAdditionalCheckersExtension((Function1)new Function1<FirSession, FirAdditionalCheckersExtension>((Object)this){

            public final FirAdditionalCheckersExtension invoke(FirSession p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((OpenApiExtension)((Object)this.receiver)).registerChecker(p0);
            }
        });
    }

    public final boolean isEmpty() {
        RouteCallGraph routeCallGraph = this.routeGraph;
        if (routeCallGraph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"routeGraph");
            routeCallGraph = null;
        }
        return routeCallGraph.isEmpty();
    }

    @NotNull
    public final FirAdditionalCheckersExtension registerChecker(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.routeGraph = new RouteCallGraph(session);
        return new OpenApiFirAdditionalChecksExtension(session);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSpecification(@NotNull Json json) {
        void this_$iv;
        Path path;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (this.isEmpty()) {
            return;
        }
        Path $this$saveSpecification_u24lambda_u240 = path = Paths.get(this.config.getOutputFile(), new String[0]);
        boolean $i$a$-apply-OpenApiExtension$saveSpecification$outputFile$22 = false;
        if ($this$saveSpecification_u24lambda_u240.getParent() != null) {
            Path path2 = $this$saveSpecification_u24lambda_u240.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            Path path3 = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.createDirectories($this$saveSpecification_u24lambda_u240.getParent(), new FileAttribute[0]);
            }
        }
        Path outputFile = path;
        SpecInfo specInfo = this.config.getInfo();
        RouteCallGraph routeCallGraph = this.routeGraph;
        if (routeCallGraph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"routeGraph");
            routeCallGraph = null;
        }
        JsonObject openApiSpec = OpenApiSpecGenerator.INSTANCE.buildSpecification(specInfo, routeCallGraph.build(), this.defaultContentType, this.securitySchemes, json);
        Json $i$a$-apply-OpenApiExtension$saveSpecification$outputFile$22 = json;
        JsonObject value$iv = openApiSpec;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String jsonString = this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)value$iv);
        Intrinsics.checkNotNull((Object)outputFile);
        PathsKt.writeText$default((Path)outputFile, (CharSequence)jsonString, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    public static final /* synthetic */ routeCallReader.1 access$getRouteCallReader$p(OpenApiExtension $this) {
        return $this.routeCallReader;
    }

    public static final /* synthetic */ RouteCallGraph access$getRouteGraph$p(OpenApiExtension $this) {
        return $this.routeGraph;
    }

    public static final /* synthetic */ void access$setDefaultContentType$p(OpenApiExtension $this, String string) {
        $this.defaultContentType = string;
    }

    public static final /* synthetic */ List access$getSecuritySchemes$p(OpenApiExtension $this) {
        return $this.securitySchemes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/ktor/openapi/OpenApiExtension$OpenApiFirAdditionalChecksExtension;", "Lorg/jetbrains/kotlin/fir/analysis/extensions/FirAdditionalCheckersExtension;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lio/ktor/openapi/OpenApiExtension;Lorg/jetbrains/kotlin/fir/FirSession;)V", "expressionCheckers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/ExpressionCheckers;", "getExpressionCheckers", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/ExpressionCheckers;", "ktor-compiler-plugin"})
    private final class OpenApiFirAdditionalChecksExtension
    extends FirAdditionalCheckersExtension {
        public OpenApiFirAdditionalChecksExtension(FirSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            super(session);
        }

        @NotNull
        public ExpressionCheckers getExpressionCheckers() {
            return new ExpressionCheckers(OpenApiExtension.this){
                private final Set<routeCallReader.1> functionCallCheckers;
                {
                    this.functionCallCheckers = SetsKt.setOf((Object)((Object)OpenApiExtension.access$getRouteCallReader$p($receiver)));
                }

                public Set<routeCallReader.1> getFunctionCallCheckers() {
                    return this.functionCallCheckers;
                }
            };
        }
    }
}

