/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.openapi.routing.interpreters;

import io.ktor.compiler.utils.ExpressionUtilsKt;
import io.ktor.openapi.model.JsonSchema;
import io.ktor.openapi.routing.RouteField;
import io.ktor.openapi.routing.RouteNode;
import io.ktor.openapi.routing.RouteStack;
import io.ktor.openapi.routing.RoutingCallInterpreter;
import io.ktor.openapi.routing.RoutingReferenceResult;
import io.ktor.openapi.routing.SchemaReference;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J#\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0014*\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u0014*\u00020\u001cH\u0002\u00a8\u0006\u001f"}, d2={"Lio/ktor/openapi/routing/interpreters/CallRespondInterpreter;", "Lio/ktor/openapi/routing/RoutingCallInterpreter;", "<init>", "()V", "check", "Lio/ktor/openapi/routing/RoutingReferenceResult;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lio/ktor/openapi/routing/RoutingReferenceResult;", "isCallRespond", "", "call", "findResponseBodyArgument", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getStatusArgument", "", "getStatusFromFunction", "getContentTypeArgument", "getContentTypeFromFunction", "getSchemaFromContentType", "Lio/ktor/openapi/routing/SchemaReference;", "contentType", "toCode", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toContentTypeString", "Companion", "ktor-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nCallRespondInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallRespondInterpreter.kt\nio/ktor/openapi/routing/interpreters/CallRespondInterpreter\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,182:1\n56#2:183\n56#2:186\n56#2:189\n295#3,2:184\n295#3,2:187\n295#3,2:190\n1#4:192\n1321#5,2:193\n*S KotlinDebug\n*F\n+ 1 CallRespondInterpreter.kt\nio/ktor/openapi/routing/interpreters/CallRespondInterpreter\n*L\n61#1:183\n71#1:186\n82#1:189\n61#1:184,2\n71#1:187,2\n82#1:190,2\n43#1:193,2\n*E\n"})
public final class CallRespondInterpreter
implements RoutingCallInterpreter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String HTTP_STATUS_CODE = "HttpStatusCode";
    @NotNull
    public static final String CONTENT_TYPE = "ContentType";

    @Override
    @NotNull
    public RoutingReferenceResult check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!this.isCallRespond(expression)) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        RouteNode.CallFeature routeNode = new RouteNode.CallFeature(context.getContainingFilePath(), expression, (Function1<? super RouteStack, ? extends List<? extends RouteField>>)((Function1)arg_0 -> CallRespondInterpreter.check$lambda$0(this, context, expression, arg_0)));
        return new RoutingReferenceResult.Match(routeNode);
    }

    private final boolean isCallRespond(FirFunctionCall call) {
        FirExpression firExpression;
        return StringsKt.startsWith$default((String)ExpressionUtilsKt.getFunctionName(call), (String)"respond", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)((firExpression = call.getExtensionReceiver()) != null && (firExpression = firExpression.getSource()) != null ? KtSourceElementKt.getText((KtSourceElement)firExpression) : null), (Object)"call") && ExpressionUtilsKt.isInPackage(call, "io.ktor.server.response");
    }

    private final ConeKotlinType findResponseBodyArgument(CheckerContext context, FirFunctionCall expression) {
        Object v2;
        block2: {
            if (!Intrinsics.areEqual((Object)ExpressionUtilsKt.getFunctionName(expression), (Object)"respond")) {
                return null;
            }
            FirCall $this$arguments$iv = (FirCall)expression;
            boolean $i$f$getArguments = false;
            Iterable $this$firstOrNull$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClassId classId;
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{HTTP_STATUS_CODE, CONTENT_TYPE, "Boolean"};
                boolean bl2 = !CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)FirTypeUtilsKt.getResolvedType((FirExpression)it))) != null && (classId = classId.getShortClassName()) != null ? classId.asString() : null);
                if (!bl2) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        FirExpression firExpression = v2;
        return firExpression != null ? FirTypeUtilsKt.getResolvedType((FirExpression)firExpression) : null;
    }

    private final String getStatusArgument(FirFunctionCall expression) {
        Object v1;
        block1: {
            FirCall $this$arguments$iv = (FirCall)expression;
            boolean $i$f$getArguments = false;
            Iterable $this$firstOrNull$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)FirTypeUtilsKt.getResolvedType((FirExpression)it));
                if (!Intrinsics.areEqual((Object)(classId != null && (classId = classId.getShortClassName()) != null ? classId.asString() : null), (Object)HTTP_STATUS_CODE)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        FirExpression firExpression = v1;
        return firExpression != null ? this.toCode(firExpression) : null;
    }

    private final String getStatusFromFunction(FirFunctionCall expression) {
        return Intrinsics.areEqual((Object)ExpressionUtilsKt.getFunctionName(expression), (Object)"respondRedirect") ? "302" : "200";
    }

    private final String getContentTypeArgument(FirFunctionCall expression) {
        Object v1;
        block1: {
            FirCall $this$arguments$iv = (FirCall)expression;
            boolean $i$f$getArguments = false;
            Iterable $this$firstOrNull$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)FirTypeUtilsKt.getResolvedType((FirExpression)it));
                if (!Intrinsics.areEqual((Object)(classId != null && (classId = classId.getShortClassName()) != null ? classId.asString() : null), (Object)CONTENT_TYPE)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        FirExpression firExpression = v1;
        return firExpression != null ? this.toContentTypeString(firExpression) : null;
    }

    private final String getContentTypeFromFunction(FirFunctionCall expression) {
        String string;
        switch (ExpressionUtilsKt.getFunctionName(expression)) {
            case "respondText": {
                string = "text/plain";
                break;
            }
            case "respondBytes": {
                string = "application/octet-stream";
                break;
            }
            case "respondHtml": {
                string = "text/html";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private final SchemaReference getSchemaFromContentType(String contentType) {
        return StringsKt.startsWith$default((String)contentType, (String)"text", (boolean)false, (int)2, null) ? (SchemaReference)new SchemaReference.Resolved(JsonSchema.Companion.getString()) : null;
    }

    private final String toCode(FirExpression $this$toCode) {
        String string;
        FirPropertyAccessExpression firPropertyAccessExpression = $this$toCode instanceof FirPropertyAccessExpression ? (FirPropertyAccessExpression)$this$toCode : null;
        if (firPropertyAccessExpression == null) {
            return null;
        }
        FirPropertyAccessExpression expr = firPropertyAccessExpression;
        switch (expr.getCalleeReference().getName().asString()) {
            case "Continue": {
                string = "100";
                break;
            }
            case "SwitchingProtocols": {
                string = "101";
                break;
            }
            case "Processing": {
                string = "102";
                break;
            }
            case "OK": {
                string = "200";
                break;
            }
            case "Created": {
                string = "201";
                break;
            }
            case "Accepted": {
                string = "202";
                break;
            }
            case "NonAuthoritativeInformation": {
                string = "203";
                break;
            }
            case "NoContent": {
                string = "204";
                break;
            }
            case "ResetContent": {
                string = "205";
                break;
            }
            case "PartialContent": {
                string = "206";
                break;
            }
            case "MultiStatus": {
                string = "207";
                break;
            }
            case "MultipleChoices": {
                string = "300";
                break;
            }
            case "MovedPermanently": {
                string = "301";
                break;
            }
            case "Found": {
                string = "302";
                break;
            }
            case "SeeOther": {
                string = "303";
                break;
            }
            case "NotModified": {
                string = "304";
                break;
            }
            case "UseProxy": {
                string = "305";
                break;
            }
            case "SwitchProxy": {
                string = "306";
                break;
            }
            case "TemporaryRedirect": {
                string = "307";
                break;
            }
            case "PermanentRedirect": {
                string = "308";
                break;
            }
            case "BadRequest": {
                string = "400";
                break;
            }
            case "Unauthorized": {
                string = "401";
                break;
            }
            case "PaymentRequired": {
                string = "402";
                break;
            }
            case "Forbidden": {
                string = "403";
                break;
            }
            case "NotFound": {
                string = "404";
                break;
            }
            case "MethodNotAllowed": {
                string = "405";
                break;
            }
            case "NotAcceptable": {
                string = "406";
                break;
            }
            case "ProxyAuthenticationRequired": {
                string = "407";
                break;
            }
            case "RequestTimeout": {
                string = "408";
                break;
            }
            case "Conflict": {
                string = "409";
                break;
            }
            case "Gone": {
                string = "410";
                break;
            }
            case "LengthRequired": {
                string = "411";
                break;
            }
            case "PreconditionFailed": {
                string = "412";
                break;
            }
            case "PayloadTooLarge": {
                string = "413";
                break;
            }
            case "RequestURITooLong": {
                string = "414";
                break;
            }
            case "UnsupportedMediaType": {
                string = "415";
                break;
            }
            case "RequestedRangeNotSatisfiable": {
                string = "416";
                break;
            }
            case "ExpectationFailed": {
                string = "417";
                break;
            }
            case "UnprocessableEntity": {
                string = "422";
                break;
            }
            case "Locked": {
                string = "423";
                break;
            }
            case "FailedDependency": {
                string = "424";
                break;
            }
            case "TooEarly": {
                string = "425";
                break;
            }
            case "UpgradeRequired": {
                string = "426";
                break;
            }
            case "TooManyRequests": {
                string = "429";
                break;
            }
            case "RequestHeaderFieldTooLarge": {
                string = "431";
                break;
            }
            case "InternalServerError": {
                string = "500";
                break;
            }
            case "NotImplemented": {
                string = "501";
                break;
            }
            case "BadGateway": {
                string = "502";
                break;
            }
            case "ServiceUnavailable": {
                string = "503";
                break;
            }
            case "GatewayTimeout": {
                string = "504";
                break;
            }
            case "VersionNotSupported": {
                string = "505";
                break;
            }
            case "VariantAlsoNegotiates": {
                string = "506";
                break;
            }
            case "InsufficientStorage": {
                string = "507";
                break;
            }
            default: {
                string = "200";
            }
        }
        return string;
    }

    private final String toContentTypeString(FirExpression $this$toContentTypeString) {
        FirPropertyAccessExpression firPropertyAccessExpression = $this$toContentTypeString instanceof FirPropertyAccessExpression ? (FirPropertyAccessExpression)$this$toContentTypeString : null;
        if (firPropertyAccessExpression == null) {
            return null;
        }
        FirPropertyAccessExpression expr = firPropertyAccessExpression;
        CharSequence charSequence = KtSourceElementKt.getText((KtSourceElement)expr.getSource());
        if (charSequence == null) {
            return null;
        }
        CharSequence text = charSequence;
        String string = StringsKt.replace$default((String)((Object)StringsKt.removePrefix((CharSequence)text, (CharSequence)"ContentType.")).toString(), (char)'.', (char)'/', (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List check$lambda$0(CallRespondInterpreter this$0, CheckerContext $context, FirFunctionCall $expression, RouteStack $this$CallFeature) {
        Sequence<Pair<String, JsonSchema>> sequence;
        SchemaReference schemaReference;
        String string;
        String statusCode;
        String string2;
        SchemaReference.Resolved schema;
        SchemaReference.Resolved resolved;
        JsonSchema jsonSchema;
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$CallFeature, (String)"$this$CallFeature");
        List $this$check_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ConeKotlinType coneType = this$0.findResponseBodyArgument($context, $expression);
        if (coneType != null && (jsonSchema = JsonSchema.Companion.asJsonSchema($this$CallFeature, coneType, false)) != null) {
            JsonSchema p0 = jsonSchema;
            boolean bl2 = false;
            resolved = new SchemaReference.Resolved(p0);
        } else {
            resolved = schema = null;
        }
        if ((string2 = this$0.getStatusArgument($expression)) == null) {
            string2 = statusCode = this$0.getStatusFromFunction($expression);
        }
        if ((string = this$0.getContentTypeArgument($expression)) == null) {
            string = this$0.getContentTypeFromFunction($expression);
        }
        String contentType = string;
        List list2 = $this$check_u24lambda_u240_u240;
        String string3 = statusCode;
        String string4 = contentType;
        SchemaReference.Resolved resolved2 = schema;
        if (resolved2 != null) {
            schemaReference = resolved2;
        } else {
            String string5 = contentType;
            if (string5 != null) {
                void p0;
                String bl2 = string5;
                String string6 = string4;
                String string7 = string3;
                List list3 = list2;
                boolean bl3 = false;
                SchemaReference schemaReference2 = this$0.getSchemaFromContentType((String)p0);
                list2 = list3;
                string3 = string7;
                string4 = string6;
                schemaReference = schemaReference2;
            } else {
                schemaReference = null;
            }
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 24;
        Map map = null;
        String string8 = null;
        SchemaReference schemaReference3 = schemaReference;
        String string9 = string4;
        String string10 = string3;
        list2.add(new RouteField.Response(string10, string9, schemaReference3, string8, map, n, defaultConstructorMarker));
        if (coneType != null && (sequence = JsonSchema.Companion.findSchemaDefinitions($this$CallFeature, coneType)) != null) {
            Sequence<Pair<String, JsonSchema>> $this$forEach$iv = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl4 = false;
                String name = (String)pair.component1();
                JsonSchema schema2 = (JsonSchema)pair.component2();
                $this$check_u24lambda_u240_u240.add(new RouteField.Schema(name, schema2));
            }
        }
        return CollectionsKt.build((List)list);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/ktor/openapi/routing/interpreters/CallRespondInterpreter$Companion;", "", "<init>", "()V", "HTTP_STATUS_CODE", "", "CONTENT_TYPE", "ktor-compiler-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

