/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.openapi.routing.interpreters;

import io.ktor.compiler.utils.ExpressionUtilsKt;
import io.ktor.openapi.OpenApiKDocParserKt;
import io.ktor.openapi.model.JsonSchema;
import io.ktor.openapi.routing.RouteField;
import io.ktor.openapi.routing.RouteFieldKt;
import io.ktor.openapi.routing.RouteNode;
import io.ktor.openapi.routing.RouteStack;
import io.ktor.openapi.routing.RouteStackKt;
import io.ktor.openapi.routing.RoutingCallInterpreter;
import io.ktor.openapi.routing.RoutingFunctionConstants;
import io.ktor.openapi.routing.RoutingReferenceResult;
import io.ktor.openapi.routing.SchemaReference;
import io.ktor.openapi.routing.SourceTextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J;\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u00020\u0006R\u00020\u0013R\u00020\bj\u0006\u0010\u0012\u001a\u00020\u0006j\u0006\u0010\u0014\u001a\u00020\u0013j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u00020\u0013j\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001bJ5\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 H\u0002R\u00020\u0013j\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010!J5\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 H\u0002R\u00020\u0013j\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010!J#\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u00020\u0013j\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010$\u00a8\u0006&"}, d2={"Lio/ktor/openapi/routing/interpreters/ResourceRoutingCallInterpreter;", "Lio/ktor/openapi/routing/RoutingCallInterpreter;", "<init>", "()V", "check", "Lio/ktor/openapi/routing/RoutingReferenceResult;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lio/ktor/openapi/routing/RoutingReferenceResult;", "isResourceRouteFunction", "", "call", "getFullResourcePath", "", "checker", "Lio/ktor/openapi/routing/RouteStack;", "stack", "resourceType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lio/ktor/openapi/routing/RouteStack;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Ljava/lang/String;", "findParentResourceType", "resourceClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lio/ktor/openapi/routing/RouteStack;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getPathParameters", "", "Lio/ktor/openapi/routing/interpreters/ResourceRoutingCallInterpreter$ParameterInfo;", "pathParams", "", "(Lio/ktor/openapi/routing/RouteStack;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Ljava/util/Set;)Ljava/util/List;", "getQueryParameters", "getMethod", "(Lio/ktor/openapi/routing/RouteStack;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Ljava/lang/String;", "ParameterInfo", "ktor-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceRoutingCallInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceRoutingCallInterpreter.kt\nio/ktor/openapi/routing/interpreters/ResourceRoutingCallInterpreter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n295#2,2:213\n1869#2,2:216\n1869#2,2:218\n1#3:215\n*S KotlinDebug\n*F\n+ 1 ResourceRoutingCallInterpreter.kt\nio/ktor/openapi/routing/interpreters/ResourceRoutingCallInterpreter\n*L\n100#1:213,2\n55#1:216,2\n63#1:218,2\n*E\n"})
public final class ResourceRoutingCallInterpreter
implements RoutingCallInterpreter {
    @Override
    @NotNull
    public RoutingReferenceResult check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!this.isResourceRouteFunction(expression)) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        SourceTextRange sourceTextRange = ExpressionUtilsKt.getLocation(context, (FirExpression)expression);
        if (sourceTextRange == null) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        SourceTextRange invocation = sourceTextRange;
        RouteNode.Route routeNode = new RouteNode.Route(context.getContainingFilePath(), expression, (Function1<? super RouteStack, ? extends List<? extends RouteField>>)((Function1)arg_0 -> ResourceRoutingCallInterpreter.check$lambda$0(expression, this, context, reporter, invocation, arg_0)));
        return new RoutingReferenceResult.Match(routeNode);
    }

    private final boolean isResourceRouteFunction(FirFunctionCall call) {
        return ExpressionUtilsKt.isInPackage(call, "io.ktor.server.resources") && RoutingFunctionConstants.INSTANCE.getHTTP_METHODS().contains(ExpressionUtilsKt.getFunctionName(call)) && !((Collection)call.getTypeArguments()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final String getFullResourcePath(CheckerContext checker, RouteStack stack, DiagnosticReporter reporter, ConeKotlinType resourceType) {
        ClassId classId;
        FirClassLikeSymbol firClassLikeSymbol;
        List list;
        List $this$getFullResourcePath_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ConeKotlinType currentType = resourceType;
        while (currentType != null && ConeTypeUtilsKt.getClassId((ConeKotlinType)currentType) != null && ((firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider((FirSession)stack.getSession()).getClassLikeSymbolByClassId(classId)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) != null) {
            FirEvaluatorResult firEvaluatorResult;
            Object v3;
            Object object;
            Iterable iterable;
            FirRegularClassSymbol resourceClass;
            block2: {
                void $this$firstOrNull$iv;
                FirAnnotation annotation;
                resourceClass = resourceClass;
                FirBasedSymbol firBasedSymbol = (FirBasedSymbol)resourceClass;
                FqName fqName = new FqName("io.ktor.resources");
                Name name = Name.identifier((String)"Resource");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
                if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)firBasedSymbol, (ClassId)new ClassId(fqName, name), (FirSession)checker.getSession()) == null) break;
                iterable = annotation.getArgumentMapping().getMapping().entrySet();
                boolean $i$f$firstOrNull = false;
                object = $this$firstOrNull$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((Name)it.getKey()).asString(), (Object)"path")) continue;
                    v3 = element$iv;
                    break block2;
                }
                v3 = null;
            }
            Map.Entry entry = v3;
            String path = entry != null && (iterable = (FirExpression)entry.getValue()) != null && (firEvaluatorResult = RouteStackKt.evaluate(stack, checker, reporter, (FirExpression)iterable)) != null && (object = ExpressionUtilsKt.asString(firEvaluatorResult)) != null ? object : "";
            $this$getFullResourcePath_u24lambda_u240.add(0, path);
            currentType = this.findParentResourceType(stack, resourceClass);
        }
        List paths = CollectionsKt.build((List)list);
        return paths.isEmpty() ? null : CollectionsKt.joinToString$default((Iterable)paths, (CharSequence)"", null, null, (int)0, null, ResourceRoutingCallInterpreter::getFullResourcePath$lambda$1, (int)30, null);
    }

    private final ConeKotlinType findParentResourceType(RouteStack stack, FirRegularClassSymbol resourceClass) {
        Object v1;
        block3: {
            FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny((FirClassSymbol)((FirClassSymbol)resourceClass), (FirSession)stack.getSession());
            if (firConstructorSymbol == null) {
                return null;
            }
            FirConstructorSymbol primaryConstructor = firConstructorSymbol;
            Iterable iterable = primaryConstructor.getValueParameterSymbols();
            for (Object t : iterable) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"parent")) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        FirValueParameterSymbol firValueParameterSymbol = v1;
        if (firValueParameterSymbol == null) {
            return null;
        }
        FirValueParameterSymbol parentParameter = firValueParameterSymbol;
        return parentParameter.getResolvedReturnType();
    }

    private final List<ParameterInfo> getPathParameters(RouteStack stack, ConeKotlinType resourceType, Set<String> pathParams) {
        List result = new ArrayList();
        ConeKotlinType currentType = resourceType;
        while (currentType != null && ConeTypeUtilsKt.getClassId((ConeKotlinType)currentType) != null) {
            FirConstructorSymbol primaryConstructor;
            FirRegularClassSymbol resourceClass;
            ClassId classId;
            FirClassLikeSymbol firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider((FirSession)stack.getSession()).getClassLikeSymbolByClassId(classId);
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null || DeclarationUtilsKt.primaryConstructorIfAny((FirClassSymbol)((FirClassSymbol)(resourceClass = firRegularClassSymbol)), (FirSession)stack.getSession()) == null) break;
            for (FirValueParameterSymbol param : primaryConstructor.getValueParameterSymbols()) {
                String paramName;
                Intrinsics.checkNotNullExpressionValue((Object)param.getName().asString(), (String)"asString(...)");
                if (Intrinsics.areEqual((Object)paramName, (Object)"parent") || !pathParams.contains(paramName)) continue;
                result.add(new ParameterInfo(paramName, new SchemaReference.Resolved(JsonSchema.Companion.asJsonSchema(stack, param.getResolvedReturnType(), false)), param.getHasDefaultValue()));
            }
            currentType = this.findParentResourceType(stack, resourceClass);
        }
        return result;
    }

    private final List<ParameterInfo> getQueryParameters(RouteStack stack, ConeKotlinType resourceType, Set<String> pathParams) {
        List result = new ArrayList();
        ConeKotlinType currentType = resourceType;
        while (currentType != null && ConeTypeUtilsKt.getClassId((ConeKotlinType)currentType) != null) {
            FirConstructorSymbol primaryConstructor;
            FirRegularClassSymbol resourceClass;
            ClassId classId;
            FirClassLikeSymbol firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider((FirSession)stack.getSession()).getClassLikeSymbolByClassId(classId);
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null || DeclarationUtilsKt.primaryConstructorIfAny((FirClassSymbol)((FirClassSymbol)(resourceClass = firRegularClassSymbol)), (FirSession)stack.getSession()) == null) break;
            for (FirValueParameterSymbol param : primaryConstructor.getValueParameterSymbols()) {
                String paramName;
                Intrinsics.checkNotNullExpressionValue((Object)param.getName().asString(), (String)"asString(...)");
                if (Intrinsics.areEqual((Object)paramName, (Object)"parent") || pathParams.contains(paramName)) continue;
                result.add(new ParameterInfo(paramName, new SchemaReference.Resolved(JsonSchema.Companion.asJsonSchema(stack, param.getResolvedReturnType(), false)), param.getHasDefaultValue()));
            }
            currentType = this.findParentResourceType(stack, resourceClass);
        }
        return result;
    }

    private final String getMethod(RouteStack stack, FirFunctionCall expression) {
        String string;
        String it = string = ExpressionUtilsKt.getFunctionName(expression);
        boolean bl = false;
        return RoutingFunctionConstants.INSTANCE.getHTTP_METHODS().contains(it) ? string : null;
    }

    private static final List check$lambda$0(FirFunctionCall $expression, ResourceRoutingCallInterpreter this$0, CheckerContext $context, DiagnosticReporter $reporter, SourceTextRange $invocation, RouteStack $this$Route) {
        ParameterInfo paramInfo;
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$Route, (String)"$this$Route");
        FirTypeProjection firTypeProjection = (FirTypeProjection)CollectionsKt.firstOrNull((List)$expression.getTypeArguments());
        if (firTypeProjection == null || (firTypeProjection = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)firTypeProjection)) == null || (firTypeProjection = RouteStackKt.resolveType($this$Route, (ConeTypeProjection)firTypeProjection)) == null) {
            return CollectionsKt.emptyList();
        }
        FirTypeProjection resourceType = firTypeProjection;
        String string = this$0.getFullResourcePath($context, $this$Route, $reporter, (ConeKotlinType)resourceType);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String fullPath = string;
        List $this$check_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$check_u24lambda_u240_u240.addAll((Collection)RouteFieldKt.resolveSchemaReferences($this$Route, $context, OpenApiKDocParserKt.parseKDoc($invocation)));
        $this$check_u24lambda_u240_u240.add(new RouteField.Path(fullPath));
        String string2 = this$0.getMethod($this$Route, $expression);
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            $this$check_u24lambda_u240_u240.add(new RouteField.Method(it));
        }
        Set pathParamKeys = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)new Regex("\\{([^}]+)}"), (CharSequence)fullPath, (int)0, (int)2, null), ResourceRoutingCallInterpreter::check$lambda$0$0$1));
        Iterable $this$forEach$iv = this$0.getPathParameters($this$Route, (ConeKotlinType)resourceType, pathParamKeys);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            paramInfo = (ParameterInfo)element$iv;
            boolean bl3 = false;
            $this$check_u24lambda_u240_u240.add(new RouteField.PathParam(paramInfo.getName(), paramInfo.getSchema(), null, null, 12, null));
        }
        $this$forEach$iv = this$0.getQueryParameters($this$Route, (ConeKotlinType)resourceType, pathParamKeys);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            paramInfo = (ParameterInfo)element$iv;
            boolean bl4 = false;
            $this$check_u24lambda_u240_u240.add(new RouteField.QueryParam(paramInfo.getName(), paramInfo.getSchema(), null, null, 12, null));
        }
        return CollectionsKt.build((List)list);
    }

    private static final String check$lambda$0$0$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getGroupValues().get(1);
    }

    private static final CharSequence getFullResourcePath$lambda$1(String segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        return ((CharSequence)segment).length() == 0 || Intrinsics.areEqual((Object)segment, (Object)"/") ? (CharSequence)"" : (CharSequence)(StringsKt.startsWith$default((String)segment, (String)"/", (boolean)false, (int)2, null) ? segment : "/" + segment);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lio/ktor/openapi/routing/interpreters/ResourceRoutingCallInterpreter$ParameterInfo;", "", "name", "", "schema", "Lio/ktor/openapi/routing/SchemaReference;", "hasDefault", "", "<init>", "(Ljava/lang/String;Lio/ktor/openapi/routing/SchemaReference;Z)V", "getName", "()Ljava/lang/String;", "getSchema", "()Lio/ktor/openapi/routing/SchemaReference;", "getHasDefault", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "ktor-compiler-plugin"})
    private static final class ParameterInfo {
        @NotNull
        private final String name;
        @NotNull
        private final SchemaReference schema;
        private final boolean hasDefault;

        public ParameterInfo(@NotNull String name, @NotNull SchemaReference schema, boolean hasDefault) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this.name = name;
            this.schema = schema;
            this.hasDefault = hasDefault;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final SchemaReference getSchema() {
            return this.schema;
        }

        public final boolean getHasDefault() {
            return this.hasDefault;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final SchemaReference component2() {
            return this.schema;
        }

        public final boolean component3() {
            return this.hasDefault;
        }

        @NotNull
        public final ParameterInfo copy(@NotNull String name, @NotNull SchemaReference schema, boolean hasDefault) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return new ParameterInfo(name, schema, hasDefault);
        }

        public static /* synthetic */ ParameterInfo copy$default(ParameterInfo parameterInfo, String string, SchemaReference schemaReference, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameterInfo.name;
            }
            if ((n & 2) != 0) {
                schemaReference = parameterInfo.schema;
            }
            if ((n & 4) != 0) {
                bl = parameterInfo.hasDefault;
            }
            return parameterInfo.copy(string, schemaReference, bl);
        }

        @NotNull
        public String toString() {
            return "ParameterInfo(name=" + this.name + ", schema=" + this.schema + ", hasDefault=" + this.hasDefault + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.schema.hashCode();
            result = result * 31 + Boolean.hashCode(this.hasDefault);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterInfo)) {
                return false;
            }
            ParameterInfo parameterInfo = (ParameterInfo)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)parameterInfo.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schema, (Object)parameterInfo.schema)) {
                return false;
            }
            return this.hasDefault == parameterInfo.hasDefault;
        }
    }
}

