/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.util;

import io.ktor.utils.io.pool.DefaultPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="ByteBufferPool is moved to `io` module", replaceWith=@ReplaceWith(expression="ByteBufferPool", imports={"io.ktor.utils.io.pool.ByteBufferPool"}), level=DeprecationLevel.WARNING)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/network/util/DirectByteBufferPool;", "Lio/ktor/utils/io/pool/DefaultPool;", "Ljava/nio/ByteBuffer;", "bufferSize", "", "size", "(II)V", "clearInstance", "instance", "produceInstance", "validateInstance", "", "ktor-network"})
public final class DirectByteBufferPool
extends DefaultPool<ByteBuffer> {
    private final int bufferSize;

    public DirectByteBufferPool(int bufferSize, int size) {
        super(size);
        this.bufferSize = bufferSize;
    }

    @NotNull
    protected ByteBuffer produceInstance() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(bufferSize)");
        return byteBuffer;
    }

    @NotNull
    protected ByteBuffer clearInstance(@NotNull ByteBuffer instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        instance.clear();
        instance.order(ByteOrder.BIG_ENDIAN);
        return instance;
    }

    protected void validateInstance(@NotNull ByteBuffer instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (!instance.isDirect()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(instance.capacity() == this.bufferSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

