/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OIDKt;
import io.ktor.network.tls.certificates.CertificateInfo;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.KeyType;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001QB\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\u000eJ\u000f\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\u00020\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u00020!8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010(\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\"\u0010/\u001a\u00020.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\"\u00106\u001a\u0002058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010=\u001a\u00020<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR(\u0010D\u001a\b\u0012\u0004\u0012\u00020!0C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR(\u0010K\u001a\b\u0012\u0004\u0012\u00020J0C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010E\u001a\u0004\bL\u0010G\"\u0004\bM\u0010IR\u0018\u0010O\u001a\u0004\u0018\u00010N8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010P\u00a8\u0006R"}, d2={"Lio/ktor/network/tls/certificates/CertificateBuilder;", "", "<init>", "()V", "Ljava/security/KeyPair;", "issuerKeyPair", "Ljava/security/cert/X509Certificate;", "issuerKeyCertificate", "", "signWith", "(Ljava/security/KeyPair;Ljava/security/cert/X509Certificate;)V", "Ljava/security/cert/Certificate;", "Ljavax/security/auth/x500/X500Principal;", "issuerName", "(Ljava/security/KeyPair;Ljava/security/cert/Certificate;Ljavax/security/auth/x500/X500Principal;)V", "Lio/ktor/network/tls/certificates/CertificateInfo;", "build$ktor_network_tls_certificates", "()Lio/ktor/network/tls/certificates/CertificateInfo;", "build", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "hash", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "getHash", "()Lio/ktor/network/tls/extensions/HashAlgorithm;", "setHash", "(Lio/ktor/network/tls/extensions/HashAlgorithm;)V", "Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "sign", "Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "getSign", "()Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "setSign", "(Lio/ktor/network/tls/extensions/SignatureAlgorithm;)V", "", "password", "Ljava/lang/String;", "getPassword", "()Ljava/lang/String;", "setPassword", "(Ljava/lang/String;)V", "subject", "Ljavax/security/auth/x500/X500Principal;", "getSubject", "()Ljavax/security/auth/x500/X500Principal;", "setSubject", "(Ljavax/security/auth/x500/X500Principal;)V", "", "daysValid", "J", "getDaysValid", "()J", "setDaysValid", "(J)V", "", "keySizeInBits", "I", "getKeySizeInBits", "()I", "setKeySizeInBits", "(I)V", "Lio/ktor/network/tls/certificates/KeyType;", "keyType", "Lio/ktor/network/tls/certificates/KeyType;", "getKeyType", "()Lio/ktor/network/tls/certificates/KeyType;", "setKeyType", "(Lio/ktor/network/tls/certificates/KeyType;)V", "", "domains", "Ljava/util/List;", "getDomains", "()Ljava/util/List;", "setDomains", "(Ljava/util/List;)V", "Ljava/net/InetAddress;", "ipAddresses", "getIpAddresses", "setIpAddresses", "Lio/ktor/network/tls/certificates/CertificateBuilder$CertificateIssuer;", "issuer", "Lio/ktor/network/tls/certificates/CertificateBuilder$CertificateIssuer;", "CertificateIssuer", "ktor-network-tls-certificates"})
public final class CertificateBuilder {
    @NotNull
    private HashAlgorithm hash = HashAlgorithm.SHA1;
    @NotNull
    private SignatureAlgorithm sign = SignatureAlgorithm.RSA;
    public String password;
    @NotNull
    private X500Principal subject = CertificatesKt.getDEFAULT_PRINCIPAL();
    private long daysValid = 3L;
    private int keySizeInBits = 1024;
    @NotNull
    private KeyType keyType = KeyType.Server;
    @NotNull
    private List<String> domains = CollectionsKt.listOf((Object)"localhost");
    @NotNull
    private List<? extends InetAddress> ipAddresses = CollectionsKt.listOf((Object)Inet4Address.getByName("127.0.0.1"));
    @Nullable
    private CertificateIssuer issuer;

    @NotNull
    public final HashAlgorithm getHash() {
        return this.hash;
    }

    public final void setHash(@NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)hashAlgorithm, (String)"<set-?>");
        this.hash = hashAlgorithm;
    }

    @NotNull
    public final SignatureAlgorithm getSign() {
        return this.sign;
    }

    public final void setSign(@NotNull SignatureAlgorithm signatureAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"<set-?>");
        this.sign = signatureAlgorithm;
    }

    @NotNull
    public final String getPassword() {
        String string = this.password;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"password");
        return null;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    @NotNull
    public final X500Principal getSubject() {
        return this.subject;
    }

    public final void setSubject(@NotNull X500Principal x500Principal) {
        Intrinsics.checkNotNullParameter((Object)x500Principal, (String)"<set-?>");
        this.subject = x500Principal;
    }

    public final long getDaysValid() {
        return this.daysValid;
    }

    public final void setDaysValid(long l) {
        this.daysValid = l;
    }

    public final int getKeySizeInBits() {
        return this.keySizeInBits;
    }

    public final void setKeySizeInBits(int n) {
        this.keySizeInBits = n;
    }

    @NotNull
    public final KeyType getKeyType() {
        return this.keyType;
    }

    public final void setKeyType(@NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"<set-?>");
        this.keyType = keyType;
    }

    @NotNull
    public final List<String> getDomains() {
        return this.domains;
    }

    public final void setDomains(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.domains = list;
    }

    @NotNull
    public final List<InetAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public final void setIpAddresses(@NotNull List<? extends InetAddress> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.ipAddresses = list;
    }

    public final void signWith(@NotNull KeyPair issuerKeyPair, @NotNull X509Certificate issuerKeyCertificate) {
        Intrinsics.checkNotNullParameter((Object)issuerKeyPair, (String)"issuerKeyPair");
        Intrinsics.checkNotNullParameter((Object)issuerKeyCertificate, (String)"issuerKeyCertificate");
        X500Principal x500Principal = issuerKeyCertificate.getSubjectX500Principal();
        Intrinsics.checkNotNullExpressionValue((Object)x500Principal, (String)"getSubjectX500Principal(...)");
        this.issuer = new CertificateIssuer(x500Principal, issuerKeyPair, issuerKeyCertificate);
    }

    public final void signWith(@NotNull KeyPair issuerKeyPair, @NotNull Certificate issuerKeyCertificate, @NotNull X500Principal issuerName) {
        Intrinsics.checkNotNullParameter((Object)issuerKeyPair, (String)"issuerKeyPair");
        Intrinsics.checkNotNullParameter((Object)issuerKeyCertificate, (String)"issuerKeyCertificate");
        Intrinsics.checkNotNullParameter((Object)issuerName, (String)"issuerName");
        this.issuer = new CertificateIssuer(issuerName, issuerKeyPair, issuerKeyCertificate);
    }

    @NotNull
    public final CertificateInfo build$ktor_network_tls_certificates() {
        KeyPairGenerator keyPairGenerator;
        HashAndSign algorithm = new HashAndSign(this.hash, this.sign, null, 4, null);
        KeyPairGenerator $this$build_u24lambda_u240 = keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm((String)algorithm.getName()));
        boolean bl = false;
        $this$build_u24lambda_u240.initialize(this.keySizeInBits);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        Intrinsics.checkNotNull((Object)keyPair);
        KeyPair keys = keyPair;
        Object object = this.issuer;
        if (object == null || (object = ((CertificateIssuer)object).getName()) == null) {
            object = this.subject;
        }
        Object object2 = object;
        X500Principal x500Principal = this.subject;
        PublicKey publicKey = keys.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        PublicKey publicKey2 = publicKey;
        Object object3 = this.issuer;
        if (object3 == null || (object3 = ((CertificateIssuer)object3).getKeyPair()) == null) {
            object3 = keys;
        }
        Object object4 = object3;
        String string = algorithm.getName();
        long l = DurationKt.toDuration((long)this.daysValid, (DurationUnit)DurationUnit.DAYS);
        KeyType keyType = this.keyType;
        List<String> list = this.domains;
        List<? extends InetAddress> list2 = this.ipAddresses;
        X509Certificate cert = CertificatesKt.generateX509Certificate-Tu6dINM(x500Principal, (X500Principal)object2, publicKey2, (KeyPair)object4, string, l, keyType, list, list2);
        CertificateIssuer certificateIssuer = this.issuer;
        return new CertificateInfo(cert, keys, this.getPassword(), certificateIssuer != null ? certificateIssuer.getKeyCertificate() : null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\u000f\u00a8\u0006\""}, d2={"Lio/ktor/network/tls/certificates/CertificateBuilder$CertificateIssuer;", "", "Ljavax/security/auth/x500/X500Principal;", "name", "Ljava/security/KeyPair;", "keyPair", "Ljava/security/cert/Certificate;", "keyCertificate", "<init>", "(Ljavax/security/auth/x500/X500Principal;Ljava/security/KeyPair;Ljava/security/cert/Certificate;)V", "component1", "()Ljavax/security/auth/x500/X500Principal;", "component2", "()Ljava/security/KeyPair;", "component3", "()Ljava/security/cert/Certificate;", "copy", "(Ljavax/security/auth/x500/X500Principal;Ljava/security/KeyPair;Ljava/security/cert/Certificate;)Lio/ktor/network/tls/certificates/CertificateBuilder$CertificateIssuer;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljavax/security/auth/x500/X500Principal;", "getName", "Ljava/security/KeyPair;", "getKeyPair", "Ljava/security/cert/Certificate;", "getKeyCertificate", "ktor-network-tls-certificates"})
    private static final class CertificateIssuer {
        @NotNull
        private final X500Principal name;
        @NotNull
        private final KeyPair keyPair;
        @NotNull
        private final Certificate keyCertificate;

        public CertificateIssuer(@NotNull X500Principal name, @NotNull KeyPair keyPair, @NotNull Certificate keyCertificate) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter((Object)keyCertificate, (String)"keyCertificate");
            this.name = name;
            this.keyPair = keyPair;
            this.keyCertificate = keyCertificate;
        }

        @NotNull
        public final X500Principal getName() {
            return this.name;
        }

        @NotNull
        public final KeyPair getKeyPair() {
            return this.keyPair;
        }

        @NotNull
        public final Certificate getKeyCertificate() {
            return this.keyCertificate;
        }

        @NotNull
        public final X500Principal component1() {
            return this.name;
        }

        @NotNull
        public final KeyPair component2() {
            return this.keyPair;
        }

        @NotNull
        public final Certificate component3() {
            return this.keyCertificate;
        }

        @NotNull
        public final CertificateIssuer copy(@NotNull X500Principal name, @NotNull KeyPair keyPair, @NotNull Certificate keyCertificate) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter((Object)keyCertificate, (String)"keyCertificate");
            return new CertificateIssuer(name, keyPair, keyCertificate);
        }

        public static /* synthetic */ CertificateIssuer copy$default(CertificateIssuer certificateIssuer, X500Principal x500Principal, KeyPair keyPair, Certificate certificate, int n, Object object) {
            if ((n & 1) != 0) {
                x500Principal = certificateIssuer.name;
            }
            if ((n & 2) != 0) {
                keyPair = certificateIssuer.keyPair;
            }
            if ((n & 4) != 0) {
                certificate = certificateIssuer.keyCertificate;
            }
            return certificateIssuer.copy(x500Principal, keyPair, certificate);
        }

        @NotNull
        public String toString() {
            return "CertificateIssuer(name=" + this.name + ", keyPair=" + this.keyPair + ", keyCertificate=" + this.keyCertificate + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.keyPair.hashCode();
            result = result * 31 + this.keyCertificate.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CertificateIssuer)) {
                return false;
            }
            CertificateIssuer certificateIssuer = (CertificateIssuer)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)certificateIssuer.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.keyPair, (Object)certificateIssuer.keyPair)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.keyCertificate, (Object)certificateIssuer.keyCertificate);
        }
    }
}

