/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.certificates.CertificateBuilder;
import io.ktor.network.tls.certificates.CertificateInfo;
import io.ktor.util.CharsetKt;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/network/tls/certificates/KeyStoreBuilder;", "", "<init>", "()V", "", "alias", "Lkotlin/Function1;", "Lio/ktor/network/tls/certificates/CertificateBuilder;", "", "Lkotlin/ExtensionFunctionType;", "block", "certificate", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Ljava/security/KeyStore;", "build$ktor_network_tls_certificates", "()Ljava/security/KeyStore;", "build", "", "Lio/ktor/network/tls/certificates/CertificateInfo;", "certificates", "Ljava/util/Map;", "ktor-network-tls-certificates"})
@SourceDebugExtension(value={"SMAP\nbuilders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 builders.kt\nio/ktor/network/tls/certificates/KeyStoreBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,219:1\n216#2:220\n217#2:223\n37#3,2:221\n*S KotlinDebug\n*F\n+ 1 builders.kt\nio/ktor/network/tls/certificates/KeyStoreBuilder\n*L\n190#1:220\n190#1:223\n192#1:221,2\n*E\n"})
public final class KeyStoreBuilder {
    @NotNull
    private final Map<String, CertificateInfo> certificates = new LinkedHashMap();

    public final void certificate(@NotNull String alias, @NotNull Function1<? super CertificateBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Map<String, CertificateInfo> map = this.certificates;
        Object object = new CertificateBuilder();
        block.invoke(object);
        object = ((CertificateBuilder)object).build$ktor_network_tls_certificates();
        map.put(alias, (CertificateInfo)object);
    }

    @NotNull
    public final KeyStore build$ktor_network_tls_certificates() {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Intrinsics.checkNotNull((Object)keyStore);
        KeyStore store = keyStore;
        store.load(null, null);
        Map<String, CertificateInfo> $this$forEach$iv = this.certificates;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, CertificateInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CertificateInfo> element$iv;
            Map.Entry<String, CertificateInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            String alias = entry.getKey();
            CertificateInfo info = entry.getValue();
            Certificate certificate = info.component1();
            KeyPair keys = info.component2();
            String password = info.component3();
            Certificate issuerCertificate = info.component4();
            Object[] objectArray = new Certificate[]{certificate, issuerCertificate};
            Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Certificate[] certChain = thisCollection$iv.toArray(new Certificate[0]);
            store.setKeyEntry(alias, keys.getPrivate(), CharsetKt.toCharArray((String)password), certChain);
        }
        return store;
    }
}

