/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet.jakarta;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultUncaughtExceptionHandler;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.servlet.jakarta.AsyncServletApplicationCall;
import io.ktor.server.servlet.jakarta.BlockingServletApplicationCall;
import io.ktor.server.servlet.jakarta.KtorServletKt;
import io.ktor.server.servlet.jakarta.ServletUpgrade;
import io.ktor.util.AttributeKey;
import io.ktor.util.Attributes;
import io.ktor.util.cio.ChannelIOException;
import io.ktor.util.debug.ContextUtilsKt;
import io.ktor.util.pipeline.Pipeline;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\u001eH\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0014\u0010'\u001a\u00020\u001e*\u00020\"2\u0006\u0010(\u001a\u00020\u0016H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lio/ktor/server/servlet/jakarta/KtorServlet;", "Ljakarta/servlet/http/HttpServlet;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "application", "Lio/ktor/server/application/Application;", "getApplication", "()Lio/ktor/server/application/Application;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "getEnginePipeline", "()Lio/ktor/server/engine/EnginePipeline;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "managedByEngineHeaders", "", "", "getManagedByEngineHeaders", "()Ljava/util/Set;", "upgrade", "Lio/ktor/server/servlet/jakarta/ServletUpgrade;", "getUpgrade", "()Lio/ktor/server/servlet/jakarta/ServletUpgrade;", "asyncService", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "blockingService", "destroy", "init", "service", "sendErrorIfNotCommitted", "message", "ktor-server-servlet-jakarta"})
public abstract class KtorServlet
extends HttpServlet
implements CoroutineScope {
    @NotNull
    private final Set<String> managedByEngineHeaders = SetsKt.emptySet();
    @NotNull
    private final CoroutineContext coroutineContext = Dispatchers.getUnconfined().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("servlet")).plus((CoroutineContext)new DefaultUncaughtExceptionHandler((Function0)new Function0<Logger>(this){
        final /* synthetic */ KtorServlet this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Logger invoke() {
            return this.this$0.getLogger();
        }
    }));

    @NotNull
    protected Set<String> getManagedByEngineHeaders() {
        return this.managedByEngineHeaders;
    }

    @NotNull
    protected abstract Application getApplication();

    @NotNull
    protected abstract EnginePipeline getEnginePipeline();

    @NotNull
    protected Logger getLogger() {
        Logger logger = LoggerFactory.getLogger((String)this.getServletName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(servletName)");
        return logger;
    }

    @NotNull
    protected abstract ServletUpgrade getUpgrade();

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public void init() {
        super.init();
        Attributes attributes = this.getApplication().getAttributes();
        AttributeKey<ServletContext> attributeKey = KtorServletKt.getServletContextAttribute();
        ServletContext servletContext = this.getServletContext();
        Intrinsics.checkNotNull((Object)servletContext);
        attributes.put(attributeKey, (Object)servletContext);
    }

    public void destroy() {
        JobKt.cancel$default((CoroutineContext)this.getCoroutineContext(), null, (int)1, null);
    }

    protected void service(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        if (response2.isCommitted()) {
            return;
        }
        try {
            if (request.isAsyncSupported()) {
                this.asyncService(request, response2);
            } else {
                this.blockingService(request, response2);
            }
        }
        catch (ChannelIOException ioError) {
            ApplicationKt.getLog((Application)this.getApplication()).debug("I/O error", (Throwable)ioError);
        }
        catch (CancellationException cancelled) {
            ApplicationKt.getLog((Application)this.getApplication()).debug("Request cancelled", (Throwable)cancelled);
            this.sendErrorIfNotCommitted(response2, "Cancelled");
        }
        catch (Throwable ex) {
            ApplicationKt.getLog((Application)this.getApplication()).error("ServletApplicationEngine cannot service the request", ex);
            String string = ex.getMessage();
            if (string == null) {
                string = ex.toString();
            }
            this.sendErrorIfNotCommitted(response2, string);
        }
    }

    private final void sendErrorIfNotCommitted(HttpServletResponse $this$sendErrorIfNotCommitted, String message) {
        try {
            if (!$this$sendErrorIfNotCommitted.isCommitted()) {
                $this$sendErrorIfNotCommitted.sendError(500, message);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private final void asyncService(HttpServletRequest request, HttpServletResponse response2) {
        AsyncContext asyncContext;
        AsyncContext asyncContext2 = request.startAsync();
        Intrinsics.checkNotNull((Object)asyncContext2);
        AsyncContext $this$asyncService_u24lambda_u240 = asyncContext = asyncContext2;
        boolean bl = false;
        $this$asyncService_u24lambda_u240.setTimeout(0L);
        AsyncContext asyncContext3 = asyncContext;
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, response2, asyncContext3, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KtorServlet this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ HttpServletResponse $response;
            final /* synthetic */ AsyncContext $asyncContext;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$response = $response;
                this.$asyncContext = $asyncContext;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        call = new AsyncServletApplicationCall(this.this$0.getApplication(), this.$request, this.$response, (CoroutineContext)Dispatchers.getIO(), (CoroutineContext)Dispatchers.getIO(), this.this$0.getUpgrade(), $this$launch.getCoroutineContext(), this.this$0.getManagedByEngineHeaders());
                        $this$execute$iv = (Pipeline)this.this$0.getEnginePipeline();
                        $i$f$execute = false;
                        this.L$0 = call;
                        this.label = 1;
                        v0 = ContextUtilsKt.initContextInDebugMode((Function1)((Function1)new Function1<Continuation<? super Unit>, Object>($this$execute$iv, (Object)call, null){
                            int label;
                            final /* synthetic */ Pipeline $this_execute;
                            final /* synthetic */ Object $context;
                            {
                                this.$this_execute = $receiver;
                                this.$context = $context;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$this_execute.execute(this.$context, (Object)Unit.INSTANCE, (Continuation)this);
                                        Object object4 = object3;
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object4 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl16
lbl15:
                        // 1 sources

                        return var6_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl24
                    }
                    case 1: {
                        $i$f$execute = false;
                        call = (AsyncServletApplicationCall)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        try {
                            this.$asyncContext.complete();
                        }
                        catch (IllegalStateException alreadyCompleted) {
                            ApplicationKt.getLog((Application)this.this$0.getApplication()).debug("AsyncContext is already completed due to previous I/O error", (Throwable)alreadyCompleted);
                        }
                        ** GOTO lbl56
                        catch (Throwable cause) {
                            this.L$0 = null;
                            this.label = 2;
                            v1 = DefaultEnginePipelineKt.logError((ApplicationCall)((ApplicationCall)call), (Throwable)cause, (Continuation)((Continuation)this));
                            ** if (v1 != var6_2) goto lbl38
lbl37:
                            // 1 sources

                            return var6_2;
lbl38:
                            // 1 sources

                            ** GOTO lbl44
                        }
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl44:
                        // 2 sources

                        KtorServlet.access$sendErrorIfNotCommitted(this.this$0, this.$response, "");
                        ** GOTO lbl56
                        {
                            catch (Throwable var4_9) {
                                throw var4_9;
                            }
                        }
                        finally {
                            try {
                                this.$asyncContext.complete();
                            }
                            catch (IllegalStateException alreadyCompleted) {
                                ApplicationKt.getLog((Application)this.this$0.getApplication()).debug("AsyncContext is already completed due to previous I/O error", (Throwable)alreadyCompleted);
                            }
                        }
lbl56:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void blockingService(HttpServletRequest request, HttpServletResponse response2) {
        BuildersKt.runBlocking((CoroutineContext)this.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, response2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KtorServlet this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ HttpServletResponse $response;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        BlockingServletApplicationCall call = new BlockingServletApplicationCall(this.this$0.getApplication(), this.$request, this.$response, $this$runBlocking.getCoroutineContext(), this.this$0.getManagedByEngineHeaders());
                        Pipeline $this$execute$iv = (Pipeline)this.this$0.getEnginePipeline();
                        boolean $i$f$execute = false;
                        this.label = 1;
                        Object object3 = ContextUtilsKt.initContextInDebugMode((Function1)((Function1)new Function1<Continuation<? super Unit>, Object>($this$execute$iv, (Object)((Object)call), null){
                            int label;
                            final /* synthetic */ Pipeline $this_execute;
                            final /* synthetic */ Object $context;
                            {
                                this.$this_execute = $receiver;
                                this.$context = $context;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$this_execute.execute(this.$context, (Object)Unit.INSTANCE, (Continuation)this);
                                        Object object4 = object3;
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object4 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$execute = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ void access$sendErrorIfNotCommitted(KtorServlet $this, HttpServletResponse $receiver, String message) {
        $this.sendErrorIfNotCommitted($receiver, message);
    }
}

