/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1APIResource;
import io.kubernetes.client.openapi.models.V1APIResourceBuilder;
import io.kubernetes.client.openapi.models.V1APIResourceFluentImpl;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1APIResourceListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1APIResourceListFluentImpl<A extends V1APIResourceListFluent<A>>
extends BaseFluent<A>
implements V1APIResourceListFluent<A> {
    private String apiVersion;
    private String groupVersion;
    private String kind;
    private ArrayList<V1APIResourceBuilder> resources;

    public V1APIResourceListFluentImpl() {
    }

    public V1APIResourceListFluentImpl(V1APIResourceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupVersion(instance.getGroupVersion());
        this.withKind(instance.getKind());
        this.withResources(instance.getResources());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getGroupVersion() {
        return this.groupVersion;
    }

    @Override
    public A withGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return (A)this;
    }

    @Override
    public Boolean hasGroupVersion() {
        return this.groupVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A addToResources(Integer index, V1APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
        this._visitables.get("resources").add(index >= 0 ? index.intValue() : this._visitables.get("resources").size(), builder);
        this.resources.add(index >= 0 ? index.intValue() : this.resources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResources(Integer index, V1APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("resources").size()) {
            this._visitables.get("resources").add(builder);
        } else {
            this._visitables.get("resources").set(index, builder);
        }
        if (index < 0 || index >= this.resources.size()) {
            this.resources.add(builder);
        } else {
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(V1APIResource ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<V1APIResource> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(V1APIResource ... items) {
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<V1APIResource> items) {
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResources(Predicate<V1APIResourceBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<V1APIResourceBuilder> each = this.resources.iterator();
        Object visitables = this._visitables.get("resources");
        while (each.hasNext()) {
            V1APIResourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1APIResource> getResources() {
        return this.resources != null ? V1APIResourceListFluentImpl.build(this.resources) : null;
    }

    @Override
    public List<V1APIResource> buildResources() {
        return this.resources != null ? V1APIResourceListFluentImpl.build(this.resources) : null;
    }

    @Override
    public V1APIResource buildResource(Integer index) {
        return this.resources.get(index).build();
    }

    @Override
    public V1APIResource buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public V1APIResource buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public V1APIResource buildMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        for (V1APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        for (V1APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<V1APIResource> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (V1APIResource item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(V1APIResource ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (V1APIResource item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> addNewResourceLike(V1APIResource item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> setNewResourceLike(Integer index, V1APIResource item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editResource(Integer index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIResourceListFluentImpl that = (V1APIResourceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupVersion != null ? !this.groupVersion.equals(that.groupVersion) : that.groupVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.resources != null ? !this.resources.equals(that.resources) : that.resources != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupVersion, this.kind, this.resources, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groupVersion != null) {
            sb.append("groupVersion:");
            sb.append(this.groupVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourcesNestedImpl<N>
    extends V1APIResourceFluentImpl<V1APIResourceListFluent.ResourcesNested<N>>
    implements V1APIResourceListFluent.ResourcesNested<N>,
    Nested<N> {
        V1APIResourceBuilder builder;
        Integer index;

        ResourcesNestedImpl(Integer index, V1APIResource item) {
            this.index = index;
            this.builder = new V1APIResourceBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new V1APIResourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIResourceListFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }
}

