/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CinderVolumeSource;
import io.kubernetes.client.openapi.models.V1CinderVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluentImpl;
import java.util.Objects;

public class V1CinderVolumeSourceFluentImpl<A extends V1CinderVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1CinderVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private V1LocalObjectReferenceBuilder secretRef;
    private String volumeID;

    public V1CinderVolumeSourceFluentImpl() {
    }

    public V1CinderVolumeSourceFluentImpl(V1CinderVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withVolumeID(instance.getVolumeID());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public V1LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(V1LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new V1LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public V1CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public V1CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public V1CinderVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public V1CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new V1LocalObjectReferenceBuilder().build());
    }

    @Override
    public V1CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeID() {
        return this.volumeID;
    }

    @Override
    public A withVolumeID(String volumeID) {
        this.volumeID = volumeID;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeID() {
        return this.volumeID != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CinderVolumeSourceFluentImpl that = (V1CinderVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.volumeID != null ? !this.volumeID.equals(that.volumeID) : that.volumeID != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeID, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.volumeID != null) {
            sb.append("volumeID:");
            sb.append(this.volumeID);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class SecretRefNestedImpl<N>
    extends V1LocalObjectReferenceFluentImpl<V1CinderVolumeSourceFluent.SecretRefNested<N>>
    implements V1CinderVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        V1LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(V1LocalObjectReference item) {
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new V1LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CinderVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

