/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CronJob;
import io.kubernetes.client.openapi.models.V1CronJobFluent;
import io.kubernetes.client.openapi.models.V1CronJobSpec;
import io.kubernetes.client.openapi.models.V1CronJobSpecBuilder;
import io.kubernetes.client.openapi.models.V1CronJobSpecFluentImpl;
import io.kubernetes.client.openapi.models.V1CronJobStatus;
import io.kubernetes.client.openapi.models.V1CronJobStatusBuilder;
import io.kubernetes.client.openapi.models.V1CronJobStatusFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import java.util.Objects;

public class V1CronJobFluentImpl<A extends V1CronJobFluent<A>>
extends BaseFluent<A>
implements V1CronJobFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1CronJobSpecBuilder spec;
    private V1CronJobStatusBuilder status;

    public V1CronJobFluentImpl() {
    }

    public V1CronJobFluentImpl(V1CronJob instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1CronJobFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1CronJobFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1CronJobFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1CronJobFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1CronJobFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1CronJobSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1CronJobSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1CronJobSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new V1CronJobSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1CronJobFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1CronJobFluent.SpecNested<A> withNewSpecLike(V1CronJobSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1CronJobFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1CronJobFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1CronJobSpecBuilder().build());
    }

    @Override
    public V1CronJobFluent.SpecNested<A> editOrNewSpecLike(V1CronJobSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1CronJobStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1CronJobStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1CronJobStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new V1CronJobStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1CronJobFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1CronJobFluent.StatusNested<A> withNewStatusLike(V1CronJobStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1CronJobFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1CronJobFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1CronJobStatusBuilder().build());
    }

    @Override
    public V1CronJobFluent.StatusNested<A> editOrNewStatusLike(V1CronJobStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CronJobFluentImpl that = (V1CronJobFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends V1CronJobStatusFluentImpl<V1CronJobFluent.StatusNested<N>>
    implements V1CronJobFluent.StatusNested<N>,
    Nested<N> {
        V1CronJobStatusBuilder builder;

        StatusNestedImpl(V1CronJobStatus item) {
            this.builder = new V1CronJobStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1CronJobStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CronJobFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends V1CronJobSpecFluentImpl<V1CronJobFluent.SpecNested<N>>
    implements V1CronJobFluent.SpecNested<N>,
    Nested<N> {
        V1CronJobSpecBuilder builder;

        SpecNestedImpl(V1CronJobSpec item) {
            this.builder = new V1CronJobSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1CronJobSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CronJobFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1CronJobFluent.MetadataNested<N>>
    implements V1CronJobFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CronJobFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

