/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CustomResourceConversion;
import io.kubernetes.client.openapi.models.V1CustomResourceConversionFluent;
import io.kubernetes.client.openapi.models.V1WebhookConversion;
import io.kubernetes.client.openapi.models.V1WebhookConversionBuilder;
import io.kubernetes.client.openapi.models.V1WebhookConversionFluentImpl;
import java.util.Objects;

public class V1CustomResourceConversionFluentImpl<A extends V1CustomResourceConversionFluent<A>>
extends BaseFluent<A>
implements V1CustomResourceConversionFluent<A> {
    private String strategy;
    private V1WebhookConversionBuilder webhook;

    public V1CustomResourceConversionFluentImpl() {
    }

    public V1CustomResourceConversionFluentImpl(V1CustomResourceConversion instance) {
        this.withStrategy(instance.getStrategy());
        this.withWebhook(instance.getWebhook());
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    @Deprecated
    public V1WebhookConversion getWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    @Override
    public V1WebhookConversion buildWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    @Override
    public A withWebhook(V1WebhookConversion webhook) {
        this._visitables.get("webhook").remove(this.webhook);
        if (webhook != null) {
            this.webhook = new V1WebhookConversionBuilder(webhook);
            this._visitables.get("webhook").add(this.webhook);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhook() {
        return this.webhook != null;
    }

    @Override
    public V1CustomResourceConversionFluent.WebhookNested<A> withNewWebhook() {
        return new WebhookNestedImpl();
    }

    @Override
    public V1CustomResourceConversionFluent.WebhookNested<A> withNewWebhookLike(V1WebhookConversion item) {
        return new WebhookNestedImpl(item);
    }

    @Override
    public V1CustomResourceConversionFluent.WebhookNested<A> editWebhook() {
        return this.withNewWebhookLike(this.getWebhook());
    }

    @Override
    public V1CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhook() {
        return this.withNewWebhookLike(this.getWebhook() != null ? this.getWebhook() : new V1WebhookConversionBuilder().build());
    }

    @Override
    public V1CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhookLike(V1WebhookConversion item) {
        return this.withNewWebhookLike(this.getWebhook() != null ? this.getWebhook() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceConversionFluentImpl that = (V1CustomResourceConversionFluentImpl)o;
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.webhook != null ? !this.webhook.equals(that.webhook) : that.webhook != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.strategy, this.webhook, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.webhook != null) {
            sb.append("webhook:");
            sb.append(this.webhook);
        }
        sb.append("}");
        return sb.toString();
    }

    class WebhookNestedImpl<N>
    extends V1WebhookConversionFluentImpl<V1CustomResourceConversionFluent.WebhookNested<N>>
    implements V1CustomResourceConversionFluent.WebhookNested<N>,
    Nested<N> {
        V1WebhookConversionBuilder builder;

        WebhookNestedImpl(V1WebhookConversion item) {
            this.builder = new V1WebhookConversionBuilder(this, item);
        }

        WebhookNestedImpl() {
            this.builder = new V1WebhookConversionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceConversionFluentImpl.this.withWebhook(this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }
}

