/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointPort is a tuple that describes a single port.")
public class CoreV1EndpointPort {
    public static final String SERIALIZED_NAME_APP_PROTOCOL = "appProtocol";
    @SerializedName(value="appProtocol")
    private String appProtocol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private Integer port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    private String protocol;

    public CoreV1EndpointPort appProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:  * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).  * Kubernetes-defined prefixed names:   * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-   * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455   * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455  * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.")
    public String getAppProtocol() {
        return this.appProtocol;
    }

    public void setAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
    }

    public CoreV1EndpointPort name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CoreV1EndpointPort port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="The port number of the endpoint.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public CoreV1EndpointPort protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreV1EndpointPort coreV1EndpointPort = (CoreV1EndpointPort)o;
        return Objects.equals(this.appProtocol, coreV1EndpointPort.appProtocol) && Objects.equals(this.name, coreV1EndpointPort.name) && Objects.equals(this.port, coreV1EndpointPort.port) && Objects.equals(this.protocol, coreV1EndpointPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoreV1EndpointPort {\n");
        sb.append("    appProtocol: ").append(this.toIndentedString(this.appProtocol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

