/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.ExtendedGeneratorConfiguration;
import io.leangen.graphql.ExtensionProvider;
import io.leangen.graphql.GeneratorConfiguration;
import io.leangen.graphql.GraphQLSchemaGenerator;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.generator.mapping.ArgumentInjector;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.SchemaTransformer;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.strategy.AbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.AnnotatedResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.BeanResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.PublicResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.module.Module;
import io.leangen.graphql.spqr.spring.annotations.GraphQLApi;
import io.leangen.graphql.spqr.spring.annotations.WithResolverBuilder;
import io.leangen.graphql.spqr.spring.annotations.WithResolverBuilders;
import io.leangen.graphql.spqr.spring.autoconfigure.Internal;
import io.leangen.graphql.spqr.spring.autoconfigure.SpqrProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={GraphQLSchemaGenerator.class})
@EnableConfigurationProperties(value={SpqrProperties.class})
public class SpqrAutoConfiguration {
    private final ConfigurableApplicationContext context;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, ResolverBuilder> globalResolverBuilderExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, TypeMapper> typeMapperExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, InputConverter> inputConverterExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, OutputConverter> outputConverterExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, ArgumentInjector> argumentInjectorExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, SchemaTransformer> schemaTransformerExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, ResolverInterceptorFactory> resolverInterceptorFactoryExtensionProvider;
    @Autowired(required=false)
    private ValueMapperFactory valueMapperFactory;
    @Autowired(required=false)
    private ExtensionProvider<ExtendedGeneratorConfiguration, InputFieldBuilder> inputFieldBuilderProvider;
    @Autowired(required=false)
    private TypeInfoGenerator typeInfoGenerator;
    @Autowired(required=false)
    private AbstractInputHandler abstractInputHandler;
    @Autowired(required=false)
    private InclusionStrategy inclusionStrategy;
    @Autowired(required=false)
    private InterfaceMappingStrategy interfaceMappingStrategy;
    @Autowired(required=false)
    private Set<MessageBundle> messageBundles;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, Module> moduleExtensionProvider;
    @Autowired(required=false)
    private Internal<Module> reactorModule;

    @Autowired
    public SpqrAutoConfiguration(ConfigurableApplicationContext context) {
        this.context = context;
    }

    @Bean
    @ConditionalOnMissingBean
    public AnnotatedResolverBuilder defaultAnnotatedResolverBuilder() {
        return new AnnotatedResolverBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    public BeanResolverBuilder defaultBeanResolverBuilder() {
        return new BeanResolverBuilder(new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public PublicResolverBuilder defaultPublicResolverBuilder() {
        return new PublicResolverBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaGenerator graphQLSchemaGenerator(SpqrProperties spqrProperties) {
        GraphQLSchemaGenerator schemaGenerator = new GraphQLSchemaGenerator();
        schemaGenerator.withBasePackages(spqrProperties.getBasePackages());
        if (spqrProperties.getRelay().isEnabled()) {
            if (!StringUtils.isEmpty((Object)spqrProperties.getRelay().getMutationWrapper())) {
                schemaGenerator.withRelayCompliantMutations(spqrProperties.getRelay().getMutationWrapper(), spqrProperties.getRelay().getMutationWrapperDescription());
            } else {
                schemaGenerator.withRelayCompliantMutations();
            }
        }
        Map<String, SpqrBean> beansWiredAsComponent = this.findGraphQLApiComponents();
        this.addOperationSources(schemaGenerator, beansWiredAsComponent.values());
        List<SpqrBean> beansWiredWithAsBeans = this.findGraphQLApiBeans();
        this.addOperationSources(schemaGenerator, beansWiredWithAsBeans);
        if (this.reactorModule != null) {
            schemaGenerator.withModules(new Module[]{this.reactorModule.get()});
        }
        if (this.moduleExtensionProvider != null) {
            schemaGenerator.withModules(this.moduleExtensionProvider);
        }
        if (this.globalResolverBuilderExtensionProvider != null) {
            schemaGenerator.withResolverBuilders(this.globalResolverBuilderExtensionProvider);
        }
        if (this.typeMapperExtensionProvider != null) {
            schemaGenerator.withTypeMappers(this.typeMapperExtensionProvider);
        }
        if (this.inputConverterExtensionProvider != null) {
            schemaGenerator.withInputConverters(this.inputConverterExtensionProvider);
        }
        if (this.outputConverterExtensionProvider != null) {
            schemaGenerator.withOutputConverters(this.outputConverterExtensionProvider);
        }
        if (this.argumentInjectorExtensionProvider != null) {
            schemaGenerator.withArgumentInjectors(this.argumentInjectorExtensionProvider);
        }
        if (this.schemaTransformerExtensionProvider != null) {
            schemaGenerator.withSchemaTransformers(this.schemaTransformerExtensionProvider);
        }
        if (this.resolverInterceptorFactoryExtensionProvider != null) {
            schemaGenerator.withResolverInterceptorFactories(this.resolverInterceptorFactoryExtensionProvider);
        }
        if (this.valueMapperFactory != null) {
            schemaGenerator.withValueMapperFactory(this.valueMapperFactory);
        }
        if (this.inputFieldBuilderProvider != null) {
            schemaGenerator.withInputFieldBuilders(this.inputFieldBuilderProvider);
        }
        if (this.typeInfoGenerator != null) {
            schemaGenerator.withTypeInfoGenerator(this.typeInfoGenerator);
        }
        if (spqrProperties.isAbstractInputTypeResolution()) {
            schemaGenerator.withAbstractInputTypeResolution();
        }
        if (this.abstractInputHandler != null) {
            schemaGenerator.withAbstractInputHandler(this.abstractInputHandler);
        }
        if (this.messageBundles != null && !this.messageBundles.isEmpty()) {
            schemaGenerator.withStringInterpolation(this.messageBundles.toArray(new MessageBundle[0]));
        }
        if (this.inclusionStrategy != null) {
            schemaGenerator.withInclusionStrategy(this.inclusionStrategy);
        }
        if (this.interfaceMappingStrategy != null) {
            schemaGenerator.withInterfaceMappingStrategy(this.interfaceMappingStrategy);
        }
        if (spqrProperties.getRelay().isConnectionCheckRelaxed()) {
            schemaGenerator.withRelayConnectionCheckRelaxed();
        }
        return schemaGenerator;
    }

    private void addOperationSources(GraphQLSchemaGenerator schemaGenerator, Collection<SpqrBean> spqrBeans) {
        spqrBeans.stream().filter(spqrBean -> spqrBean.getScope().equals((Object)BeanScope.SINGLETON)).forEach(spqrBean -> schemaGenerator.withOperationsFromSingleton(spqrBean.getSpringBean(), spqrBean.getType(), (ResolverBuilder[])((SpqrBean)spqrBean).resolverBuilders.stream().map(resolverBuilderBeanIdentity -> this.findQualifiedBeanByType(resolverBuilderBeanIdentity.getResolverType(), resolverBuilderBeanIdentity.getValue(), resolverBuilderBeanIdentity.getQualifierType())).toArray(ResolverBuilder[]::new)));
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchema graphQLSchema(GraphQLSchemaGenerator schemaGenerator) {
        return schemaGenerator.generate();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQL graphQL(GraphQLSchema schema) {
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema);
        return builder.build();
    }

    private <T> T findQualifiedBeanByType(Class<? extends T> type, String qualifierValue, Class<? extends Annotation> qualifierType) {
        NoSuchBeanDefinitionException noSuchBeanDefinitionException = new NoSuchBeanDefinitionException(qualifierValue, "No matching " + type.getSimpleName() + " bean found for qualifier " + qualifierValue + " of type " + qualifierType.getSimpleName() + " !");
        try {
            if (StringUtils.isEmpty((Object)qualifierValue)) {
                if (qualifierType.equals(Qualifier.class)) {
                    return (T)Optional.of(this.context.getBean(type)).orElseThrow(() -> noSuchBeanDefinitionException);
                }
                return (T)this.context.getBean(Arrays.stream(this.context.getBeanNamesForAnnotation(qualifierType)).filter(beanName -> type.isInstance(this.context.getBean(beanName))).findFirst().orElseThrow(() -> noSuchBeanDefinitionException), type);
            }
            return (T)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.context.getBeanFactory(), type, (String)qualifierValue);
        }
        catch (NoSuchBeanDefinitionException noBeanException) {
            ConfigurableListableBeanFactory factory = this.context.getBeanFactory();
            for (String name : factory.getBeanDefinitionNames()) {
                Map attributes;
                StandardMethodMetadata metadata;
                BeanDefinition bd = factory.getBeanDefinition(name);
                if (!(bd.getSource() instanceof StandardMethodMetadata) || !(metadata = (StandardMethodMetadata)bd.getSource()).getReturnTypeName().equals(type.getName()) || null == (attributes = metadata.getAnnotationAttributes(qualifierType.getName()))) continue;
                if (qualifierType.equals(Qualifier.class) && qualifierValue.equals(attributes.get("value"))) {
                    return (T)this.context.getBean(name, type);
                }
                return (T)this.context.getBean(name, type);
            }
            throw noSuchBeanDefinitionException;
        }
    }

    private List<SpqrBean> findGraphQLApiBeans() {
        ConfigurableListableBeanFactory factory = this.context.getBeanFactory();
        ArrayList<SpqrBean> spqrBeans = new ArrayList<SpqrBean>();
        for (String beanName : factory.getBeanDefinitionNames()) {
            StandardMethodMetadata metadata;
            Map attributes;
            BeanDefinition bd = factory.getBeanDefinition(beanName);
            if (!(bd.getSource() instanceof StandardMethodMetadata) || null == (attributes = (metadata = (StandardMethodMetadata)bd.getSource()).getAnnotationAttributes(GraphQLApi.class.getName()))) continue;
            SpqrBean spqrBean = new SpqrBean((ApplicationContext)this.context, beanName, metadata.getIntrospectedMethod().getAnnotatedReturnType());
            Map withResolverBuildersAttributes = metadata.getAnnotationAttributes(WithResolverBuilders.class.getTypeName());
            if (withResolverBuildersAttributes != null) {
                AnnotationAttributes[] annotationAttributesArray = (AnnotationAttributes[])withResolverBuildersAttributes.get("value");
                Arrays.stream(annotationAttributesArray).forEach(annotationAttributes -> spqrBean.getResolverBuilders().add(new ResolverBuilderBeanIdentity((Class)annotationAttributes.get((Object)"value"), (String)annotationAttributes.get((Object)"qualifierValue"), (Class)annotationAttributes.get((Object)"qualifierType"))));
            } else {
                Map withResolverBuilderAttributes = metadata.getAnnotationAttributes(WithResolverBuilder.class.getTypeName());
                if (withResolverBuilderAttributes != null) {
                    spqrBean.getResolverBuilders().add(new ResolverBuilderBeanIdentity((Class)withResolverBuilderAttributes.get("value"), (String)withResolverBuilderAttributes.get("qualifierValue"), (Class)withResolverBuilderAttributes.get("qualifierType")));
                }
            }
            spqrBeans.add(spqrBean);
        }
        return spqrBeans;
    }

    private Map<String, SpqrBean> findGraphQLApiComponents() {
        Map operationSourcesBeans = this.context.getBeansWithAnnotation(GraphQLApi.class);
        HashMap<String, SpqrBean> result = new HashMap<String, SpqrBean>();
        for (String beanName : operationSourcesBeans.keySet()) {
            Class<?> operationSourceBeanClass = operationSourcesBeans.get(beanName).getClass();
            result.put(beanName, new SpqrBean((ApplicationContext)this.context, beanName, GenericTypeReflector.annotate((Type)ClassUtils.getUserClass(operationSourceBeanClass))));
            if (operationSourceBeanClass.isAnnotationPresent(WithResolverBuilder.class)) {
                WithResolverBuilder withResolverBuilder = operationSourceBeanClass.getAnnotation(WithResolverBuilder.class);
                ((SpqrBean)result.get(beanName)).resolverBuilders.add(new ResolverBuilderBeanIdentity(withResolverBuilder.value(), withResolverBuilder.qualifierValue(), withResolverBuilder.qualifierType()));
                continue;
            }
            if (!operationSourceBeanClass.isAnnotationPresent(WithResolverBuilders.class)) continue;
            for (WithResolverBuilder withResolverBuilder : operationSourceBeanClass.getAnnotation(WithResolverBuilders.class).value()) {
                ((SpqrBean)result.get(beanName)).resolverBuilders.add(new ResolverBuilderBeanIdentity(withResolverBuilder.value(), withResolverBuilder.qualifierValue(), withResolverBuilder.qualifierType()));
            }
        }
        return result;
    }

    private static enum BeanScope {
        SINGLETON,
        PROTOTYPE;


        static BeanScope findBeanScope(ApplicationContext context, String beanName) {
            if (context.isSingleton(beanName)) {
                return SINGLETON;
            }
            if (context.isPrototype(beanName)) {
                return PROTOTYPE;
            }
            throw new RuntimeException("Unsupported bean scope");
        }
    }

    private class ResolverBuilderBeanIdentity {
        private final Class<? extends ResolverBuilder> resolverType;
        private final String value;
        private final Class<? extends Annotation> qualifierType;

        private ResolverBuilderBeanIdentity(Class<? extends ResolverBuilder> resolverType, String value, Class<? extends Annotation> qualifierType) {
            this.resolverType = resolverType;
            this.value = value;
            this.qualifierType = qualifierType;
        }

        String getValue() {
            return this.value;
        }

        Class<? extends Annotation> getQualifierType() {
            return this.qualifierType;
        }

        Class<? extends ResolverBuilder> getResolverType() {
            return this.resolverType;
        }
    }

    private static class SpqrBean {
        private final BeanScope scope;
        private final Object springBean;
        private final AnnotatedType type;
        private final List<ResolverBuilderBeanIdentity> resolverBuilders;

        SpqrBean(ApplicationContext context, String beanName, AnnotatedType type) {
            this.springBean = context.getBean(beanName);
            this.scope = BeanScope.findBeanScope(context, beanName);
            this.type = type;
            this.resolverBuilders = new ArrayList<ResolverBuilderBeanIdentity>();
        }

        BeanScope getScope() {
            return this.scope;
        }

        Object getSpringBean() {
            return this.springBean;
        }

        public AnnotatedType getType() {
            return this.type;
        }

        List<ResolverBuilderBeanIdentity> getResolverBuilders() {
            return this.resolverBuilders;
        }
    }
}

