/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="graphql.spqr")
public class SpqrProperties {
    public static String DEFAULT_ENDPOINT = "/graphql";
    public static String DEFAULT_GUI_ENDPOINT = "/gui";
    private String[] basePackages;
    private boolean abstractInputTypeResolution;
    private Relay relay = new Relay();
    private Http http = new Http();
    private WebSocket ws = new WebSocket();
    private Gui gui = new Gui();

    @PostConstruct
    public void setDefaults() {
        if (StringUtils.isEmpty((Object)this.ws.getEndpoint())) {
            this.ws.setEndpoint(this.http.endpoint);
        }
        if (StringUtils.isEmpty((Object)this.gui.getTargetEndpoint())) {
            this.gui.setTargetEndpoint(this.http.endpoint);
        }
        if (StringUtils.isEmpty((Object)this.gui.getTargetWsEndpoint())) {
            this.gui.setTargetWsEndpoint(this.ws.endpoint);
        }
    }

    public String[] getBasePackages() {
        return this.basePackages;
    }

    public void setBasePackages(String[] basePackages) {
        this.basePackages = basePackages;
    }

    public boolean isAbstractInputTypeResolution() {
        return this.abstractInputTypeResolution;
    }

    public void setAbstractInputTypeResolution(boolean abstractInputTypeResolution) {
        this.abstractInputTypeResolution = abstractInputTypeResolution;
    }

    public Relay getRelay() {
        return this.relay;
    }

    public void setRelay(Relay relay) {
        this.relay = relay;
    }

    public Http getHttp() {
        return this.http;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public WebSocket getWs() {
        return this.ws;
    }

    public void setWs(WebSocket ws) {
        this.ws = ws;
    }

    public Gui getGui() {
        return this.gui;
    }

    public void setGui(Gui gui) {
        this.gui = gui;
    }

    public class Gui {
        private boolean enabled = true;
        private String endpoint = DEFAULT_GUI_ENDPOINT;
        private String targetEndpoint;
        private String targetWsEndpoint;
        private String pageTitle = "GraphQL Playground";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getTargetEndpoint() {
            return this.targetEndpoint;
        }

        public void setTargetEndpoint(String targetEndpoint) {
            this.targetEndpoint = targetEndpoint;
        }

        public String getTargetWsEndpoint() {
            return this.targetWsEndpoint;
        }

        public void setTargetWsEndpoint(String targetWsEndpoint) {
            this.targetWsEndpoint = targetWsEndpoint;
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public void setPageTitle(String pageTitle) {
            this.pageTitle = pageTitle;
        }
    }

    public class WebSocket {
        private boolean enabled = true;
        private String endpoint;
        private String[] allowedOrigins = new String[]{"*"};
        private KeepAlive keepAlive = new KeepAlive();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String[] getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public KeepAlive getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(KeepAlive keepAlive) {
            this.keepAlive = keepAlive;
        }

        public class KeepAlive {
            private boolean enabled;
            private int intervalMillis = 10000;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public int getIntervalMillis() {
                return this.intervalMillis;
            }

            public void setIntervalMillis(int intervalMillis) {
                this.intervalMillis = intervalMillis;
            }
        }
    }

    public class Http {
        private boolean enabled = true;
        private String endpoint = DEFAULT_ENDPOINT;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }
    }

    public class Relay {
        private boolean enabled;
        private String mutationWrapper;
        private String mutationWrapperDescription;
        private boolean connectionCheckRelaxed;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getMutationWrapper() {
            return this.mutationWrapper;
        }

        public void setMutationWrapper(String mutationWrapper) {
            this.mutationWrapper = mutationWrapper;
        }

        public String getMutationWrapperDescription() {
            return this.mutationWrapperDescription;
        }

        public void setMutationWrapperDescription(String mutationWrapperDescription) {
            this.mutationWrapperDescription = mutationWrapperDescription;
        }

        public boolean isConnectionCheckRelaxed() {
            return this.connectionCheckRelaxed;
        }

        public void setConnectionCheckRelaxed(boolean connectionCheckRelaxed) {
            this.connectionCheckRelaxed = connectionCheckRelaxed;
        }
    }
}

