/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.SchemaTransformer;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.module.Module;
import io.leangen.graphql.spqr.spring.autoconfigure.DataLoaderRegistryFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.DefaultGlobalContext;
import io.leangen.graphql.spqr.spring.autoconfigure.Internal;
import io.leangen.graphql.spqr.spring.autoconfigure.ReactiveContextFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.SpqrProperties;
import io.leangen.graphql.spqr.spring.autoconfigure.reactive.FluxAdapter;
import io.leangen.graphql.spqr.spring.autoconfigure.reactive.MonoAdapter;
import io.leangen.graphql.spqr.spring.web.GraphQLController;
import io.leangen.graphql.spqr.spring.web.GuiController;
import io.leangen.graphql.spqr.spring.web.reactive.DefaultGraphQLController;
import io.leangen.graphql.spqr.spring.web.reactive.DefaultGraphQLExecutor;
import io.leangen.graphql.spqr.spring.web.reactive.GraphQLReactiveExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class SpqrReactiveAutoConfiguration {
    @Autowired(required=false)
    private DataLoaderRegistryFactory dataLoaderRegistryFactory;

    @Bean
    public Internal<Module> reactorModule() {
        MonoAdapter monoAdapter = new MonoAdapter();
        FluxAdapter fluxAdapter = new FluxAdapter();
        return new Internal<Module>(context -> context.getSchemaGenerator().withTypeMappers(new TypeMapper[]{monoAdapter, fluxAdapter}).withOutputConverters(new OutputConverter[]{monoAdapter, fluxAdapter}).withSchemaTransformers(new SchemaTransformer[]{fluxAdapter}));
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveContextFactory globalContextFactory() {
        return params -> new DefaultGlobalContext(params.getNativeRequest());
    }

    @Bean
    @ConditionalOnProperty(name={"graphql.spqr.http.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public GraphQLReactiveExecutor graphQLExecutor(ReactiveContextFactory contextFactory) {
        return new DefaultGraphQLExecutor(contextFactory, this.dataLoaderRegistryFactory);
    }

    @Bean
    @ConditionalOnProperty(name={"graphql.spqr.http.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={GraphQLController.class})
    @ConditionalOnBean(value={GraphQLSchema.class})
    public DefaultGraphQLController graphQLController(GraphQL graphQL, GraphQLReactiveExecutor executor) {
        return new DefaultGraphQLController(graphQL, executor);
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.spqr.gui.enabled"}, havingValue="true")
    public GuiController guiController(SpqrProperties config) {
        return new GuiController(config);
    }
}

