/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web;

import graphql.GraphQL;
import io.leangen.graphql.spqr.spring.web.GraphQLExecutor;
import io.leangen.graphql.spqr.spring.web.dto.GraphQLRequest;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public abstract class GraphQLController<R> {
    protected final GraphQL graphQL;
    protected final GraphQLExecutor<R> executor;

    public GraphQLController(GraphQL graphQL, GraphQLExecutor<R> executor) {
        this.graphQL = graphQL;
        this.executor = executor;
    }

    @PostMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, consumes={"application/json;charset=UTF-8", "application/json"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object executeJsonPost(@RequestBody GraphQLRequest requestBody, GraphQLRequest requestParams, R request) {
        String query = requestParams.getQuery() == null ? requestBody.getQuery() : requestParams.getQuery();
        String operationName = requestParams.getOperationName() == null ? requestBody.getOperationName() : requestParams.getOperationName();
        Map<String, Object> variables = requestParams.getVariables() == null ? requestBody.getVariables() : requestParams.getVariables();
        return this.executor.execute(this.graphQL, new GraphQLRequest(query, operationName, variables), request);
    }

    @PostMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, consumes={"application/graphql", "application/graphql;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object executeGraphQLPost(@RequestBody String queryBody, GraphQLRequest graphQLRequest, R request) {
        String query = graphQLRequest.getQuery() == null ? queryBody : graphQLRequest.getQuery();
        return this.executor.execute(this.graphQL, new GraphQLRequest(query, graphQLRequest.getOperationName(), graphQLRequest.getVariables()), request);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"${graphql.spqr.http.endpoint:/graphql}"}, consumes={"application/x-www-form-urlencoded", "application/x-www-form-urlencoded;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object executeFormPost(@RequestParam Map<String, String> queryParams, GraphQLRequest graphQLRequest, R request) {
        String queryParam = queryParams.get("query");
        String operationNameParam = queryParams.get("operationName");
        String query = StringUtils.isEmpty((Object)queryParam) ? graphQLRequest.getQuery() : queryParam;
        String operationName = StringUtils.isEmpty((Object)operationNameParam) ? graphQLRequest.getOperationName() : operationNameParam;
        return this.executor.execute(this.graphQL, new GraphQLRequest(query, operationName, graphQLRequest.getVariables()), request);
    }

    @GetMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, produces={"application/json;charset=UTF-8"}, headers={"Connection!=Upgrade"})
    @ResponseBody
    public Object executeGet(GraphQLRequest graphQLRequest, R request) {
        return this.executor.execute(this.graphQL, graphQLRequest, request);
    }
}

