/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.mapping.DelegatingOutputConverter;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CollectionOutputConverter
implements DelegatingOutputConverter<Collection<?>, Collection<?>> {
    @Override
    public Collection<?> convertOutput(Collection<?> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return this.processCollection(original, resolutionEnvironment.getDerived(type, 0), resolutionEnvironment);
    }

    @Override
    public List<AnnotatedType> getDerivedTypes(AnnotatedType collectionType) {
        return Collections.singletonList(this.getElementType(collectionType));
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return ClassUtils.isSuperClass(Collection.class, type);
    }

    private List<?> processCollection(Collection<?> collection, AnnotatedType elementType, ResolutionEnvironment resolutionEnvironment) {
        return collection.stream().map(e -> resolutionEnvironment.convertOutput(e, elementType)).collect(Collectors.toList());
    }

    private AnnotatedType getElementType(AnnotatedType collectionType) {
        return GenericTypeReflector.getTypeParameter((AnnotatedType)collectionType, Collection.class.getTypeParameters()[0]);
    }
}

