/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.exceptions.MappingException;
import io.leangen.graphql.metadata.execution.Executable;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Resolver {
    private final String operationName;
    private final String operationDescription;
    private final String operationDeprecationReason;
    private final List<OperationArgument> arguments;
    private final TypedElement typedElement;
    private final Set<OperationArgument> contextArguments;
    private final String complexityExpression;
    private final Executable executable;
    private final boolean batched;

    public Resolver(String operationName, String operationDescription, String operationDeprecationReason, boolean batched, Executable executable, TypedElement typedElement, List<OperationArgument> arguments, String complexityExpression) {
        Set<OperationArgument> contextArguments = this.resolveContexts(arguments);
        if (batched) {
            this.validateBatching(executable.toString(), typedElement.getJavaType(), contextArguments);
        }
        this.operationName = this.validateName(operationName, executable);
        this.operationDescription = operationDescription;
        this.operationDeprecationReason = operationDeprecationReason;
        this.arguments = arguments;
        this.typedElement = typedElement;
        this.contextArguments = contextArguments;
        this.complexityExpression = complexityExpression;
        this.executable = executable;
        this.batched = batched;
    }

    private String validateName(String operationName, Executable executable) {
        if (Utils.isEmpty(operationName)) {
            throw new MappingException("The operation name for executable " + executable.toString() + " could not be determined");
        }
        return operationName;
    }

    private void validateBatching(String executableSignature, AnnotatedType returnType, Set<OperationArgument> contextArguments) {
        if (contextArguments.isEmpty() || !Stream.concat(contextArguments.stream().map(arg -> arg.getJavaType().getType()), Stream.of(returnType.getType())).allMatch(type -> GenericTypeReflector.isSuperType(List.class, (Type)type))) {
            throw new IllegalArgumentException("Resolver method " + executableSignature + " is marked as batched but doesn't return a list or its context argument is not a list");
        }
    }

    private Set<OperationArgument> resolveContexts(List<OperationArgument> arguments) {
        return arguments.stream().filter(OperationArgument::isContext).collect(Collectors.toSet());
    }

    public Object resolve(Object source, Object[] args) throws InvocationTargetException, IllegalAccessException {
        return this.executable.execute(source, args);
    }

    public Set<Type> getSourceTypes() {
        return this.contextArguments.stream().map(arg -> arg.getJavaType().getType()).collect(Collectors.toSet());
    }

    public String getOperationName() {
        return this.operationName;
    }

    public boolean isBatched() {
        return this.batched;
    }

    public String getOperationDescription() {
        return this.operationDescription;
    }

    public String getOperationDeprecationReason() {
        return this.operationDeprecationReason;
    }

    String getFingerprint() {
        StringBuilder fingerprint = new StringBuilder();
        this.arguments.stream().filter(OperationArgument::isMappable).map(OperationArgument::getName).sorted().forEach(fingerprint::append);
        return fingerprint.toString();
    }

    public List<OperationArgument> getArguments() {
        return this.arguments;
    }

    public TypedElement getTypedElement() {
        return this.typedElement;
    }

    public AnnotatedType getReturnType() {
        return this.typedElement.getJavaType();
    }

    public String getComplexityExpression() {
        return this.complexityExpression;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Resolver && this.executable.equals(((Resolver)that).executable);
    }

    public int hashCode() {
        return this.executable.hashCode();
    }

    public String toString() {
        return this.executable.toString();
    }
}

