/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.module.common.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.GraphQLScalarType;
import io.leangen.graphql.module.common.jackson.JacksonScalars;
import io.leangen.graphql.util.Scalars;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonObjectScalars {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final GraphQLScalarType JsonObjectNode = new GraphQLScalarType("JsonObject", "JSON object", (Coercing)new Coercing<Object, Object>(){

        public Object serialize(Object dataFetcherResult) {
            return dataFetcherResult;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) throws CoercingParseLiteralException {
            return this.parseLiteral(input, Collections.emptyMap());
        }

        public Object parseLiteral(Object input, Map<String, Object> variables) {
            return JacksonObjectScalars.parseJsonValue((Value)Scalars.literalOrException(input, ObjectValue.class), variables);
        }
    });
    public static final GraphQLScalarType JsonAnyNode = new GraphQLScalarType("Json", "Any JSON value", (Coercing)new Coercing<Object, Object>(){

        public Object serialize(Object dataFetcherResult) {
            GraphQLScalarType scalar = JacksonScalars.toGraphQLScalarType(dataFetcherResult.getClass());
            return scalar != null ? scalar.getCoercing().serialize(dataFetcherResult) : dataFetcherResult;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) throws CoercingParseLiteralException {
            return this.parseLiteral(input, Collections.emptyMap());
        }

        public Object parseLiteral(Object input, Map<String, Object> variables) {
            return JacksonObjectScalars.parseJsonValue((Value)input, variables);
        }
    });
    private static final Map<Type, GraphQLScalarType> SCALAR_MAPPING = JacksonObjectScalars.getScalarMapping();

    private static JsonNode parseJsonValue(Value value, Map<String, Object> variables) {
        if (value instanceof BooleanValue) {
            return JsonNodeFactory.instance.booleanNode(((BooleanValue)value).isValue());
        }
        if (value instanceof EnumValue) {
            return JsonNodeFactory.instance.textNode(((EnumValue)value).getName());
        }
        if (value instanceof FloatValue) {
            return JsonNodeFactory.instance.numberNode(((FloatValue)value).getValue());
        }
        if (value instanceof IntValue) {
            return JsonNodeFactory.instance.numberNode(((IntValue)value).getValue());
        }
        if (value instanceof NullValue) {
            return JsonNodeFactory.instance.nullNode();
        }
        if (value instanceof StringValue) {
            return JsonNodeFactory.instance.textNode(((StringValue)value).getValue());
        }
        if (value instanceof ArrayValue) {
            List values = ((ArrayValue)value).getValues();
            ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode(values.size());
            values.forEach(v -> jsonArray.add(JacksonObjectScalars.parseJsonValue(v, variables)));
            return jsonArray;
        }
        if (value instanceof VariableReference) {
            return (JsonNode)OBJECT_MAPPER.convertValue(variables.get(((VariableReference)value).getName()), JsonNode.class);
        }
        if (value instanceof ObjectValue) {
            ObjectNode result = JsonNodeFactory.instance.objectNode();
            ((ObjectValue)value).getObjectFields().forEach(objectField -> result.set(objectField.getName(), JacksonObjectScalars.parseJsonValue(objectField.getValue(), variables)));
            return result;
        }
        throw new CoercingParseLiteralException("Unknown scalar AST type: " + value.getClass().getName());
    }

    public static boolean isScalar(Type javaType) {
        return SCALAR_MAPPING.containsKey(javaType);
    }

    public static GraphQLScalarType toGraphQLScalarType(Type javaType) {
        return SCALAR_MAPPING.get(javaType);
    }

    private static Map<Type, GraphQLScalarType> getScalarMapping() {
        HashMap<Class<JsonNode>, GraphQLScalarType> scalarMapping = new HashMap<Class<JsonNode>, GraphQLScalarType>();
        scalarMapping.put(ObjectNode.class, JsonObjectNode);
        scalarMapping.put(POJONode.class, JsonObjectNode);
        scalarMapping.put(JsonNode.class, JsonAnyNode);
        return Collections.unmodifiableMap(scalarMapping);
    }
}

