/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Utils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> Optional<T> or(Optional<T> left, Optional<T> right) {
        return left.isPresent() ? left : right;
    }

    public static <T> Optional<T> or(Optional<T> left, Supplier<Optional<T>> right) {
        return left.isPresent() ? left : right.get();
    }

    @SafeVarargs
    public static <T> Stream<T> flatten(Optional<T> ... optionals) {
        return Arrays.stream(optionals).filter(Optional::isPresent).map(Optional::get);
    }

    public static boolean isEmpty(String string) {
        return !Utils.isNotEmpty(string);
    }

    public static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    public static String coalesce(String ... values) {
        return Arrays.stream(values).filter(Utils::isNotEmpty).findFirst().orElse(null);
    }

    public static String capitalize(String str) {
        char newChar;
        char firstChar = str.charAt(0);
        if (firstChar == (newChar = Character.toUpperCase(firstChar))) {
            return str;
        }
        char[] newChars = new char[str.length()];
        newChars[0] = newChar;
        str.getChars(1, str.length(), newChars, 1);
        return String.valueOf(newChars);
    }

    public static boolean isArrayEmpty(Object array) {
        return !Utils.isArrayNotEmpty(array);
    }

    public static boolean isArrayNotEmpty(Object array) {
        return array != null && Array.getLength(array) != 0;
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<T> ... streams) {
        return Arrays.stream(streams).reduce(Stream::concat).orElse(Stream.empty());
    }

    public static <T> Stream<T> extractInstances(Collection<?> collection, Class<T> clazz) {
        return collection.stream().filter(clazz::isInstance).map(clazz::cast);
    }

    public static String[] emptyArray() {
        return EMPTY_STRING_ARRAY;
    }

    public static String[] emptyIfNull(String[] array) {
        return array == null ? Utils.emptyArray() : array;
    }

    public static String requireNonEmpty(String value) {
        if (Utils.isEmpty(value)) {
            throw new IllegalArgumentException("Empty string is not a valid value");
        }
        return value;
    }

    public static <T> List<T> singletonList(T element) {
        return element == null ? Collections.emptyList() : Collections.singletonList(element);
    }

    public static <T> List<T> asList(T[] elements) {
        return elements == null || elements.length == 0 ? Collections.emptyList() : Arrays.asList(elements);
    }
}

